/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEmbedClientHelper;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;

public class XEmbeddedFramePeer
extends XFramePeer {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed");
    LinkedList<AWTKeyStroke> strokes;
    XEmbedClientHelper embedder;

    public XEmbeddedFramePeer(EmbeddedFrame embeddedFrame) {
        super(new XCreateWindowParams(new Object[]{"target", embeddedFrame, "visible", Boolean.TRUE, "embedded", Boolean.TRUE}));
    }

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.strokes = new LinkedList();
        if (this.supportsXEmbed()) {
            this.embedder = new XEmbedClientHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        if (this.embedder != null) {
            this.embedder.install(this);
        } else if (this.getParentWindowHandle() != 0L) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.getWindow(), this.getParentWindowHandle(), 0, 0);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    public void updateMinimumSize() {
    }

    protected String getWMName() {
        return "JavaEmbeddedFrame";
    }

    final long getParentWindowHandle() {
        return ((XEmbeddedFrame)this.target).handle;
    }

    boolean supportsXEmbed() {
        return ((EmbeddedFrame)this.target).supportsXEmbed();
    }

    public boolean requestWindowFocus() {
        if (this.embedder != null && this.embedder.isActive()) {
            xembedLog.fine("Requesting focus from embedding host");
            return this.embedder.requestFocus();
        }
        xembedLog.fine("Requesting focus from X");
        return super.requestWindowFocus();
    }

    protected void requestInitialFocus() {
        if (this.embedder != null && this.supportsXEmbed()) {
            this.embedder.requestFocus();
        } else {
            super.requestInitialFocus();
        }
    }

    protected boolean isEventDisabled(XEvent xEvent) {
        if (this.embedder != null && this.embedder.isActive()) {
            switch (xEvent.get_type()) {
                case 9: 
                case 10: {
                    return true;
                }
            }
        }
        return super.isEventDisabled(xEvent);
    }

    public void handleConfigureNotifyEvent(XEvent xEvent) {
        XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
        this.checkIfOnNewScreen(this.toGlobal(new Rectangle(xConfigureEvent.get_x(), xConfigureEvent.get_y(), xConfigureEvent.get_width(), xConfigureEvent.get_height())));
        Rectangle rectangle = this.getBounds();
        this.x = xConfigureEvent.get_x();
        this.y = xConfigureEvent.get_y();
        this.width = xConfigureEvent.get_width();
        this.height = xConfigureEvent.get_height();
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.getSize().equals(rectangle.getSize())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
        }
        if (!rectangle2.getLocation().equals(rectangle.getLocation())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
        }
    }

    protected void traverseOutForward() {
        if (this.embedder != null && this.embedder.isActive() && this.embedder.isApplicationActive()) {
            xembedLog.fine("Traversing out Forward");
            this.embedder.traverseOutForward();
        }
    }

    protected void traverseOutBackward() {
        if (this.embedder != null && this.embedder.isActive() && this.embedder.isApplicationActive()) {
            xembedLog.fine("Traversing out Backward");
            this.embedder.traverseOutBackward();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        XToolkit.awtLock();
        try {
            Point point = this.toGlobal(0, 0);
            return point;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 16387);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBoundsPrivate() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        XToolkit.awtLock();
        try {
            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.getWindow(), xWindowAttributes.pData);
            n = xWindowAttributes.get_x();
            n2 = xWindowAttributes.get_y();
            n3 = xWindowAttributes.get_width();
            n4 = xWindowAttributes.get_height();
        }
        finally {
            XToolkit.awtUnlock();
        }
        xWindowAttributes.dispose();
        return new Rectangle(n, n2, n3, n4);
    }

    void registerAccelerator(AWTKeyStroke aWTKeyStroke) {
        if (aWTKeyStroke == null) {
            return;
        }
        this.strokes.add(aWTKeyStroke);
        if (this.embedder != null && this.embedder.isActive()) {
            this.embedder.registerAccelerator(aWTKeyStroke, this.strokes.size() - 1);
        }
    }

    void unregisterAccelerator(AWTKeyStroke aWTKeyStroke) {
        if (aWTKeyStroke == null) {
            return;
        }
        if (this.embedder != null && this.embedder.isActive()) {
            int n = this.strokes.indexOf(aWTKeyStroke);
            this.embedder.unregisterAccelerator(n);
        }
    }

    void notifyStarted() {
        if (this.embedder != null && this.embedder.isActive()) {
            int n = 0;
            Iterator iterator = this.strokes.iterator();
            while (iterator.hasNext()) {
                this.embedder.registerAccelerator((AWTKeyStroke)iterator.next(), n++);
            }
        }
        this.updateDropTarget();
    }

    long getFocusTargetWindow() {
        return this.getWindow();
    }

    boolean isXEmbedActive() {
        return this.embedder != null && this.embedder.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAbsoluteX() {
        XToolkit.awtLock();
        try {
            XTranslateCoordinates xTranslateCoordinates;
            block8: {
                xTranslateCoordinates = new XTranslateCoordinates(this.getWindow(), XToolkit.getDefaultRootWindow(), 0, 0);
                try {
                    int n = xTranslateCoordinates.execute(XToolkit.IgnoreBadWindowHandler);
                    if (n != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) break block8;
                    int n2 = 0;
                    xTranslateCoordinates.dispose();
                    return n2;
                }
                catch (Throwable throwable) {
                    xTranslateCoordinates.dispose();
                    throw throwable;
                }
            }
            int n = xTranslateCoordinates.get_dest_x();
            xTranslateCoordinates.dispose();
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAbsoluteY() {
        XToolkit.awtLock();
        try {
            XTranslateCoordinates xTranslateCoordinates;
            block8: {
                xTranslateCoordinates = new XTranslateCoordinates(this.getWindow(), XToolkit.getDefaultRootWindow(), 0, 0);
                try {
                    int n = xTranslateCoordinates.execute(XToolkit.IgnoreBadWindowHandler);
                    if (n != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) break block8;
                    int n2 = 0;
                    xTranslateCoordinates.dispose();
                    return n2;
                }
                catch (Throwable throwable) {
                    xTranslateCoordinates.dispose();
                    throw throwable;
                }
            }
            int n = xTranslateCoordinates.get_dest_y();
            xTranslateCoordinates.dispose();
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setModalBlocked(Dialog dialog, boolean bl) {
        super.setModalBlocked(dialog, bl);
        EmbeddedFrame embeddedFrame = (EmbeddedFrame)this.target;
        embeddedFrame.notifyModalBlocked(dialog, bl);
    }
}

