/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import sun.rmi.server.ActivationGroupImpl;
import sun.security.action.GetIntegerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivationGroup
extends UnicastRemoteObject
implements ActivationInstantiator {
    private ActivationGroupID groupID;
    private ActivationMonitor monitor;
    private long incarnation;
    private static ActivationGroup currGroup;
    private static ActivationGroupID currGroupID;
    private static ActivationSystem currSystem;
    private static boolean canCreate;
    private static final long serialVersionUID = -7696947875314805420L;

    protected ActivationGroup(ActivationGroupID activationGroupID) throws RemoteException {
        this.groupID = activationGroupID;
    }

    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        this.getMonitor().inactiveObject(activationID);
        return true;
    }

    public abstract void activeObject(ActivationID var1, Remote var2) throws ActivationException, UnknownObjectException, RemoteException;

    public static synchronized ActivationGroup createGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, long l) throws ActivationException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (currGroup != null) {
            throw new ActivationException("group already exists");
        }
        if (!canCreate) {
            throw new ActivationException("group deactivated and cannot be recreated");
        }
        try {
            AnnotatedElement annotatedElement;
            Class clazz;
            String string = activationGroupDesc.getClassName();
            Class<ActivationGroupImpl> clazz2 = ActivationGroupImpl.class;
            if (string == null || string.equals(clazz2.getName())) {
                clazz = clazz2;
            } else {
                try {
                    annotatedElement = RMIClassLoader.loadClass(activationGroupDesc.getLocation(), string);
                }
                catch (Exception exception) {
                    throw new ActivationException("Could not load group implementation class", exception);
                }
                if (ActivationGroup.class.isAssignableFrom((Class<?>)annotatedElement)) {
                    clazz = ((Class)annotatedElement).asSubclass(ActivationGroup.class);
                } else {
                    throw new ActivationException("group not correct class: " + ((Class)annotatedElement).getName());
                }
            }
            annotatedElement = clazz.getConstructor(ActivationGroupID.class, MarshalledObject.class);
            ActivationGroup activationGroup = (ActivationGroup)((Constructor)annotatedElement).newInstance(activationGroupID, activationGroupDesc.getData());
            currSystem = activationGroupID.getSystem();
            activationGroup.incarnation = l;
            activationGroup.monitor = currSystem.activeGroup(activationGroupID, activationGroup, l);
            currGroup = activationGroup;
            currGroupID = activationGroupID;
            canCreate = false;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            throw new ActivationException("exception in group constructor", invocationTargetException.getTargetException());
        }
        catch (ActivationException activationException) {
            throw activationException;
        }
        catch (Exception exception) {
            throw new ActivationException("exception creating group", exception);
        }
        return currGroup;
    }

    public static synchronized ActivationGroupID currentGroupID() {
        return currGroupID;
    }

    static synchronized ActivationGroupID internalCurrentGroupID() throws ActivationException {
        if (currGroupID == null) {
            throw new ActivationException("nonexistent group");
        }
        return currGroupID;
    }

    public static synchronized void setSystem(ActivationSystem activationSystem) throws ActivationException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (currSystem != null) {
            throw new ActivationException("activation system already set");
        }
        currSystem = activationSystem;
    }

    public static synchronized ActivationSystem getSystem() throws ActivationException {
        if (currSystem == null) {
            try {
                int n = AccessController.doPrivileged(new GetIntegerAction("java.rmi.activation.port", 1098));
                currSystem = (ActivationSystem)Naming.lookup("//:" + n + "/java.rmi.activation.ActivationSystem");
            }
            catch (Exception exception) {
                throw new ActivationException("unable to obtain ActivationSystem", exception);
            }
        }
        return currSystem;
    }

    protected void activeObject(ActivationID activationID, MarshalledObject<? extends Remote> marshalledObject) throws ActivationException, UnknownObjectException, RemoteException {
        this.getMonitor().activeObject(activationID, marshalledObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inactiveGroup() throws UnknownGroupException, RemoteException {
        try {
            this.getMonitor().inactiveGroup(this.groupID, this.incarnation);
        }
        finally {
            ActivationGroup.destroyGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivationMonitor getMonitor() throws RemoteException {
        Class<ActivationGroup> clazz = ActivationGroup.class;
        synchronized (ActivationGroup.class) {
            if (this.monitor != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.monitor;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw new RemoteException("monitor not received");
        }
    }

    private static synchronized void destroyGroup() {
        currGroup = null;
        currGroupID = null;
    }

    static synchronized ActivationGroup currentGroup() throws ActivationException {
        if (currGroup == null) {
            throw new ActivationException("group is not active");
        }
        return currGroup;
    }

    static {
        canCreate = true;
    }
}

