/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.soap.server;

import com.sun.xml.internal.messaging.saaj.soap.MessageImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.SOAPDecoder;
import com.sun.xml.internal.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.handler.HandlerChainCaller;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.handler.SOAPHandlerContext;
import com.sun.xml.internal.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.pept.presentation.TargetFinder;
import com.sun.xml.internal.ws.pept.presentation.Tie;
import com.sun.xml.internal.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.internal.ws.server.AppMsgContextImpl;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.spi.runtime.Binding;
import com.sun.xml.internal.ws.spi.runtime.Invoker;
import com.sun.xml.internal.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.spi.runtime.WebServiceContext;
import com.sun.xml.internal.ws.util.FastInfosetUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPConnectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;

public class SOAPMessageDispatcher
implements MessageDispatcher {
    private static final String[] contentTypes = new String[]{"text/xml", "application/soap+xml", "application/xop+xml", "application/fastinfoset", "application/soap+fastinfoset"};
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.soapmd");

    public void send(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageInfo messageInfo) {
        boolean bl;
        block21: {
            try {
                this.checkContentType(messageInfo);
            }
            catch (ServerRtException serverRtException) {
                SOAPConnectionUtil.sendKnownError(messageInfo, 415);
                return;
            }
            SOAPMessage sOAPMessage = null;
            try {
                sOAPMessage = this.getSOAPMessage(messageInfo);
            }
            catch (Exception exception) {
                this.sendResponseError(messageInfo, exception);
                return;
            }
            bl = false;
            try {
                try {
                    if (((MessageImpl)sOAPMessage).acceptFastInfoset()) {
                        messageInfo.setMetaData("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                SOAPHandlerContext sOAPHandlerContext = new SOAPHandlerContext(messageInfo, null, sOAPMessage);
                this.updateHandlerContext(messageInfo, sOAPHandlerContext);
                sOAPHandlerContext.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.FALSE);
                MessageContext messageContext = MessageInfoUtil.getMessageContext(messageInfo);
                if (messageContext != null) {
                    MessageContextUtil.copyInboundMessageAttachments(messageContext, sOAPMessage.getAttachments());
                }
                SystemHandlerDelegate systemHandlerDelegate = this.getSystemHandlerDelegate(messageInfo);
                SoapInvoker soapInvoker = new SoapInvoker(messageInfo, sOAPMessage, sOAPHandlerContext, systemHandlerDelegate);
                try {
                    if (systemHandlerDelegate == null) {
                        soapInvoker.invoke();
                    } else {
                        sOAPHandlerContext.setInvoker(soapInvoker);
                        if (systemHandlerDelegate.processRequest(sOAPHandlerContext.getSHDSOAPMessageContext())) {
                            soapInvoker.invoke();
                            sOAPHandlerContext.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
                            systemHandlerDelegate.processResponse(sOAPHandlerContext.getSHDSOAPMessageContext());
                        }
                    }
                }
                finally {
                    bl = soapInvoker.isSent();
                }
                if (!SOAPMessageDispatcher.isOneway(messageInfo)) {
                    this.makeSOAPMessage(messageInfo, sOAPHandlerContext);
                    bl = true;
                    this.sendResponse(messageInfo, sOAPHandlerContext);
                } else if (!bl) {
                    bl = true;
                    this.sendResponseOneway(messageInfo);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.log(Level.SEVERE, exception.getMessage(), exception);
                if (bl) break block21;
                this.sendResponseError(messageInfo, exception);
            }
        }
        assert (bl);
    }

    protected void toMessageInfo(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        Object object;
        Object object2;
        Object object3;
        InternalMessage internalMessage = sOAPHandlerContext.getInternalMessage();
        try {
            object3 = sOAPHandlerContext.getSOAPMessage();
            if (internalMessage == null) {
                object2 = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                object = object2.getSOAPDecoder();
                internalMessage = ((SOAPDecoder)object).toInternalMessage((SOAPMessage)object3, messageInfo);
            } else {
                object2 = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                object = object2.getSOAPDecoder();
                internalMessage = ((SOAPDecoder)object).toInternalMessage((SOAPMessage)object3, internalMessage, messageInfo);
            }
            object2 = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            object = object2.getSOAPEncoder();
            ((SOAPEncoder)object).setAttachmentsMap(messageInfo, internalMessage);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            messageInfo.setResponseType(2);
            messageInfo.setResponse(exception);
        }
        if (!SOAPMessageDispatcher.isFailure(messageInfo)) {
            object3 = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            object3.getInternalEncoder().toMessageInfo(internalMessage, messageInfo);
            object2 = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo().getBinding();
            Object object4 = object = object2 != null ? ((SOAPBindingImpl)object2).getBindingId() : "http://schemas.xmlsoap.org/wsdl/soap/http";
            if (messageInfo.getMethod() == null) {
                messageInfo.setResponseType(2);
                SOAPFaultInfo sOAPFaultInfo = new SOAPFaultInfo("Cannot find dispatch method", SOAPConstants.FAULT_CODE_SERVER, null, null, (String)object);
                messageInfo.setResponse(sOAPFaultInfo);
            }
        }
    }

    private SOAPMessage getSOAPMessage(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        return SOAPConnectionUtil.getSOAPMessage(wSConnection, messageInfo, null);
    }

    private void checkContentType(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        Map<String, List<String>> map = wSConnection.getHeaders();
        List<String> list = map.get("Content-Type");
        if (list != null && list.size() > 0) {
            String string = list.get(0);
            for (String string2 : contentTypes) {
                if (string.indexOf(string2) == -1) continue;
                return;
            }
        }
        throw new ServerRtException("Incorrect Content-Type=" + list, new Object[0]);
    }

    protected void updateWebServiceContext(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo runtimeEndpointInfo = runtimeContext.getRuntimeEndpointInfo();
        WebServiceContext webServiceContext = runtimeEndpointInfo.getWebServiceContext();
        sOAPHandlerContext.getMessageContext().put("com.sun.xml.ws.client.ContentNegotiation", messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation"));
        sOAPHandlerContext.getMessageContext().setScope("com.sun.xml.ws.client.ContentNegotiation", MessageContext.Scope.APPLICATION);
        if (webServiceContext != null) {
            AppMsgContextImpl appMsgContextImpl = new AppMsgContextImpl(sOAPHandlerContext.getMessageContext());
            webServiceContext.setMessageContext(appMsgContextImpl);
        }
    }

    protected void invokeEndpoint(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        TargetFinder targetFinder = messageInfo.getEPTFactory().getTargetFinder(messageInfo);
        Tie tie = targetFinder.findTarget(messageInfo);
        tie._invoke(messageInfo);
    }

    protected void getResponse(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        this.setResponseInContext(messageInfo, sOAPHandlerContext);
        try {
            HandlerChainCaller handlerChainCaller = this.getCallerFromMessageInfo(messageInfo);
            if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
                int n = messageInfo.getResponseType();
                if (n == 1 || n == 2) {
                    this.callHandleFault(handlerChainCaller, sOAPHandlerContext);
                } else {
                    JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
                    boolean bl = false;
                    if (jAXWSAttachmentMarshaller != null && jAXWSAttachmentMarshaller.isXOPPackage()) {
                        bl = jAXWSAttachmentMarshaller.isXOPPackage();
                        jAXWSAttachmentMarshaller.setXOPPackage(false);
                    }
                    this.callHandlersOnResponse(handlerChainCaller, sOAPHandlerContext);
                    if (jAXWSAttachmentMarshaller != null) {
                        jAXWSAttachmentMarshaller.setXOPPackage(bl);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            this.createInternalMessageForException(messageInfo, exception, sOAPHandlerContext);
        }
    }

    private boolean createInternalMessageForException(MessageInfo messageInfo, Exception exception, SOAPHandlerContext sOAPHandlerContext) {
        boolean bl = false;
        RuntimeEndpointInfo runtimeEndpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        String string = ((SOAPBindingImpl)runtimeEndpointInfo.getBinding()).getBindingId();
        InternalMessage internalMessage = null;
        if (string.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            internalMessage = SOAPRuntimeModel.createFaultInBody(exception, null, null, null);
        } else if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            internalMessage = SOAPRuntimeModel.createSOAP12FaultInBody(exception, null, null, null, null);
            bl = true;
        }
        sOAPHandlerContext.setInternalMessage(internalMessage);
        sOAPHandlerContext.setSOAPMessage(null);
        return bl;
    }

    private void makeSOAPMessage(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        InternalMessage internalMessage = sOAPHandlerContext.getInternalMessage();
        if (internalMessage != null) {
            SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            SOAPEncoder sOAPEncoder = sOAPEPTFactory.getSOAPEncoder();
            SOAPMessage sOAPMessage = sOAPEncoder.toSOAPMessage(internalMessage, messageInfo);
            sOAPHandlerContext.setSOAPMessage(sOAPMessage);
            sOAPHandlerContext.setInternalMessage(null);
        }
    }

    protected void setResponseInContext(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
        InternalMessage internalMessage = (InternalMessage)sOAPEPTFactory.getInternalEncoder().toInternalMessage(messageInfo);
        sOAPHandlerContext.setInternalMessage(internalMessage);
        sOAPHandlerContext.setSOAPMessage(null);
    }

    private void sendResponse(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        SOAPMessage sOAPMessage = sOAPHandlerContext.getSOAPMessage();
        WSConnection wSConnection = messageInfo.getConnection();
        Integer n = MessageContextUtil.getHttpStatusCode(sOAPHandlerContext.getMessageContext());
        int n2 = n == null ? 200 : n;
        SOAPConnectionUtil.setStatus(wSConnection, n2);
        SOAPConnectionUtil.sendResponse(wSConnection, sOAPMessage);
    }

    protected void sendResponseOneway(MessageInfo messageInfo) {
        SOAPConnectionUtil.sendResponseOneway(messageInfo);
    }

    private void sendResponseError(MessageInfo messageInfo, Exception exception) {
        exception.printStackTrace();
        WSConnection wSConnection = messageInfo.getConnection();
        Binding binding = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo().getBinding();
        String string = ((SOAPBindingImpl)binding).getBindingId();
        SOAPConnectionUtil.sendResponseError(wSConnection, string);
    }

    private boolean callHandlersOnRequest(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext, boolean bl) {
        boolean bl2 = false;
        HandlerChainCaller handlerChainCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
            try {
                bl2 = !handlerChainCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, sOAPHandlerContext, bl);
            }
            catch (ProtocolException protocolException) {
                bl2 = true;
                if (MessageContextUtil.ignoreFaultInMessage(sOAPHandlerContext.getMessageContext())) {
                    this.createInternalMessageForException(messageInfo, protocolException, sOAPHandlerContext);
                }
            }
            catch (RuntimeException runtimeException) {
                bl2 = true;
                this.createInternalMessageForException(messageInfo, runtimeException, sOAPHandlerContext);
            }
        }
        return bl2;
    }

    private HandlerChainCaller getCallerFromMessageInfo(MessageInfo messageInfo) {
        RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        BindingImpl bindingImpl = (BindingImpl)runtimeContext.getRuntimeEndpointInfo().getBinding();
        if (bindingImpl.hasHandlers()) {
            HandlerChainCaller handlerChainCaller = bindingImpl.getHandlerChainCaller();
            MessageInfoUtil.setHandlerChainCaller(messageInfo, handlerChainCaller);
            return handlerChainCaller;
        }
        return null;
    }

    protected boolean callHandlersOnResponse(HandlerChainCaller handlerChainCaller, SOAPHandlerContext sOAPHandlerContext) {
        return handlerChainCaller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, sOAPHandlerContext, false);
    }

    protected boolean callHandleFault(HandlerChainCaller handlerChainCaller, SOAPHandlerContext sOAPHandlerContext) {
        return handlerChainCaller.callHandleFault(sOAPHandlerContext);
    }

    private void closeHandlers(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
            handlerChainCaller.forceCloseHandlersOnServer(sOAPHandlerContext);
        }
    }

    private static boolean isFailure(MessageInfo messageInfo) {
        return messageInfo.getResponseType() == 2;
    }

    public static boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    private void updateHandlerContext(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        MessageInfoUtil.getRuntimeContext(messageInfo).setHandlerContext(sOAPHandlerContext);
        RuntimeEndpointInfo runtimeEndpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        sOAPHandlerContext.setBindingId(((BindingImpl)runtimeEndpointInfo.getBinding()).getActualBindingId());
        WebServiceContext webServiceContext = runtimeEndpointInfo.getWebServiceContext();
        if (webServiceContext != null) {
            sOAPHandlerContext.setMessageContext(webServiceContext.getMessageContext());
        }
    }

    private SystemHandlerDelegate getSystemHandlerDelegate(MessageInfo messageInfo) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo runtimeEndpointInfo = runtimeContext.getRuntimeEndpointInfo();
        return runtimeEndpointInfo.getBinding().getSystemHandlerDelegate();
    }

    private class SoapInvoker
    implements Invoker {
        MessageInfo messageInfo;
        SOAPMessage soapMessage;
        SOAPHandlerContext context;
        boolean skipEndpoint;
        SystemHandlerDelegate shd;
        boolean sent;

        SoapInvoker(MessageInfo messageInfo, SOAPMessage sOAPMessage, SOAPHandlerContext sOAPHandlerContext, SystemHandlerDelegate systemHandlerDelegate) {
            this.messageInfo = messageInfo;
            this.soapMessage = sOAPMessage;
            this.context = sOAPHandlerContext;
            this.shd = systemHandlerDelegate;
        }

        public void invoke() throws Exception {
            Object object;
            Object object2;
            boolean bl = false;
            if (!this.skipEndpoint) {
                try {
                    object2 = (SOAPEPTFactory)((Object)this.messageInfo.getEPTFactory());
                    object = object2.getSOAPDecoder();
                    SOAPMessageDispatcher.this.getCallerFromMessageInfo(this.messageInfo);
                    bl = ((SOAPDecoder)object).doMustUnderstandProcessing(this.soapMessage, this.messageInfo, this.context, true);
                    this.context.setMethod(this.messageInfo.getMethod());
                }
                catch (SOAPFaultException sOAPFaultException) {
                    this.skipEndpoint = true;
                    boolean bl2 = SOAPMessageDispatcher.this.createInternalMessageForException(this.messageInfo, sOAPFaultException, this.context);
                    SOAPRuntimeModel.addHeaders(this.context.getInternalMessage(), this.messageInfo);
                }
            }
            if (!this.skipEndpoint) {
                this.skipEndpoint = SOAPMessageDispatcher.this.callHandlersOnRequest(this.messageInfo, this.context, !bl);
            }
            if (this.skipEndpoint) {
                this.soapMessage = this.context.getSOAPMessage();
                if (this.soapMessage == null) {
                    object2 = this.context.getInternalMessage();
                    object = (SOAPEPTFactory)((Object)this.messageInfo.getEPTFactory());
                    SOAPEncoder sOAPEncoder = object.getSOAPEncoder();
                    this.soapMessage = sOAPEncoder.toSOAPMessage((InternalMessage)object2, this.messageInfo);
                }
                FastInfosetUtil.ensureCorrectEncoding(this.messageInfo, this.soapMessage);
                this.context.setSOAPMessage(this.soapMessage);
                this.context.setInternalMessage(null);
            } else {
                SOAPMessageDispatcher.this.toMessageInfo(this.messageInfo, this.context);
                if (SOAPMessageDispatcher.isOneway(this.messageInfo)) {
                    this.sent = true;
                    SOAPMessageDispatcher.this.sendResponseOneway(this.messageInfo);
                    if (!bl) {
                        SOAPMessageDispatcher.this.closeHandlers(this.messageInfo, this.context);
                    }
                }
                if (!SOAPMessageDispatcher.isFailure(this.messageInfo)) {
                    if (this.shd != null) {
                        this.shd.preInvokeEndpointHook(this.context.getSHDSOAPMessageContext());
                    }
                    SOAPMessageDispatcher.this.updateWebServiceContext(this.messageInfo, this.context);
                    SOAPMessageDispatcher.this.invokeEndpoint(this.messageInfo, this.context);
                    if (!this.sent && SOAPMessageDispatcher.isOneway(this.messageInfo)) {
                        this.sent = true;
                        SOAPMessageDispatcher.this.sendResponseOneway(this.messageInfo);
                    }
                    this.context.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
                }
                if (SOAPMessageDispatcher.isOneway(this.messageInfo)) {
                    if (SOAPMessageDispatcher.isFailure(this.messageInfo)) {
                        // empty if block
                    }
                } else {
                    SOAPMessageDispatcher.this.getResponse(this.messageInfo, this.context);
                }
            }
        }

        public Method getMethod(QName qName) {
            RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(this.messageInfo);
            return runtimeContext.getDispatchMethod(qName, this.messageInfo);
        }

        public boolean isSent() {
            return this.sent;
        }
    }
}

