/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.spi.runtime.MtomCallback;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSAttachmentMarshaller
extends AttachmentMarshaller {
    private MtomCallback mtomCallback;
    private boolean isXOP;
    private boolean isXopped;
    private Map<String, AttachmentBlock> attachments;
    private HandlerContext hc;
    private int mtomThresholdValue = 1000;

    public JAXWSAttachmentMarshaller(boolean bl) {
        this.isXOP = bl;
    }

    @Override
    public boolean isXOPPackage() {
        return this.isXOP;
    }

    public void setXOPPackage(boolean bl) {
        this.isXOP = bl;
    }

    @Override
    public String addMtomAttachment(DataHandler dataHandler, String string, String string2) {
        if (!this.isXOP) {
            return null;
        }
        String string3 = this.encodeCid(string);
        if (string3 != null) {
            String string4 = '<' + string3 + '>';
            this.attachments.put(string4, AttachmentBlock.fromDataHandler(string4, dataHandler));
            this.addToMessageContext(string4, dataHandler);
            if (this.mtomCallback != null) {
                this.mtomCallback.addedMtomAttachment(string4, dataHandler, string, string2);
            }
            this.isXopped = true;
            string3 = "cid:" + string3;
        }
        return string3;
    }

    @Override
    public String addMtomAttachment(byte[] byArray, int n, int n2, String string, String string2, String string3) {
        if (!this.isXOP) {
            return null;
        }
        if (n2 < this.mtomThresholdValue) {
            return null;
        }
        String string4 = this.encodeCid(string2);
        if (string4 != null) {
            String string5 = '<' + string4 + '>';
            DataHandler dataHandler = new DataHandler(new ByteArrayDataSource(byArray, n, n2, "application/octet-stream"));
            this.attachments.put(string5, AttachmentBlock.fromDataHandler(string5, dataHandler));
            this.addToMessageContext(string5, dataHandler);
            if (this.mtomCallback != null) {
                this.mtomCallback.addedMtomAttachment(string5, dataHandler, string2, string3);
            }
            this.isXopped = true;
            string4 = "cid:" + string4;
        }
        return string4;
    }

    @Override
    public String addSwaRefAttachment(DataHandler dataHandler) {
        String string = this.encodeCid(null);
        if (string != null) {
            String string2 = '<' + string + '>';
            this.attachments.put(string2, AttachmentBlock.fromDataHandler("<" + string + ">", dataHandler));
            this.addToMessageContext(string2, dataHandler);
            this.isXopped = false;
            string = "cid:" + string;
        }
        return string;
    }

    private void addToMessageContext(String string, DataHandler dataHandler) {
        if (this.hc == null) {
            return;
        }
        MessageContext messageContext = this.hc.getMessageContext();
        if (messageContext == null) {
            return;
        }
        MessageContextUtil.addMessageAttachment(messageContext, string, dataHandler);
    }

    private String encodeCid(String string) {
        String string2 = "example.jaxws.sun.com";
        String string3 = UUID.randomUUID() + "@";
        if (string != null && string.length() > 0) {
            try {
                String string4;
                URI uRI = new URI(string);
                string2 = string4 = uRI.toURL().getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    string2 = URLEncoder.encode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new WebServiceException(malformedURLException);
                }
            }
        }
        return string3 + string2;
    }

    public void setAttachments(Map<String, AttachmentBlock> map) {
        this.attachments = map;
        this.isXopped = false;
    }

    public void setHandlerContaxt(HandlerContext handlerContext) {
        this.hc = handlerContext;
    }

    public boolean isXopped() {
        return this.isXopped;
    }

    public void setMtomThresholdValue(Integer n) {
        if (n != null && n >= 0) {
            this.mtomThresholdValue = n;
        }
    }

    public void setMtomCallback(MtomCallback mtomCallback) {
        this.mtomCallback = mtomCallback;
    }
}

