/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class HmacCore
implements Cloneable {
    private final MessageDigest a;
    private final byte[] b;
    private final byte[] c;
    private boolean d;
    private final int e;

    HmacCore(MessageDigest messageDigest, int n) {
        this.a = messageDigest;
        this.e = n;
        this.b = new byte[this.e];
        this.c = new byte[this.e];
        this.d = true;
    }

    HmacCore(String string, int n) throws NoSuchAlgorithmException {
        this(MessageDigest.getInstance(string), n);
    }

    private HmacCore(HmacCore hmacCore) throws CloneNotSupportedException {
        this.a = (MessageDigest)hmacCore.a.clone();
        this.e = hmacCore.e;
        this.b = (byte[])hmacCore.b.clone();
        this.c = (byte[])hmacCore.c.clone();
        this.d = hmacCore.d;
    }

    int a() {
        return this.a.getDigestLength();
    }

    void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        if (byArray.length > this.e) {
            byte[] byArray2 = this.a.digest(byArray);
            Arrays.fill(byArray, (byte)0);
            byArray = byArray2;
        }
        for (int i = 0; i < this.e; ++i) {
            byte by = i < byArray.length ? byArray[i] : (byte)0;
            this.b[i] = (byte)(by ^ 0x36);
            this.c[i] = (byte)(by ^ 0x5C);
        }
        Arrays.fill(byArray, (byte)0);
        byArray = null;
        this.c();
    }

    void a(byte by) {
        if (this.d) {
            this.a.update(this.b);
            this.d = false;
        }
        this.a.update(by);
    }

    void a(byte[] byArray, int n, int n2) {
        if (this.d) {
            this.a.update(this.b);
            this.d = false;
        }
        this.a.update(byArray, n, n2);
    }

    void a(ByteBuffer byteBuffer) {
        if (this.d) {
            this.a.update(this.b);
            this.d = false;
        }
        this.a.update(byteBuffer);
    }

    byte[] b() {
        if (this.d) {
            this.a.update(this.b);
        } else {
            this.d = true;
        }
        try {
            byte[] byArray = this.a.digest();
            this.a.update(this.c);
            this.a.update(byArray);
            this.a.digest(byArray, 0, byArray.length);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    void c() {
        if (!this.d) {
            this.a.reset();
            this.d = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new HmacCore(this);
    }

    public static final class HmacSHA512
    extends MacSpi
    implements Cloneable {
        private final HmacCore a;

        public HmacSHA512() throws NoSuchAlgorithmException {
            SunJCE.a(this.getClass());
            this.a = new HmacCore("SHA-512", 128);
        }

        private HmacSHA512(HmacSHA512 hmacSHA512) throws CloneNotSupportedException {
            this.a = (HmacCore)hmacSHA512.a.clone();
        }

        protected int engineGetMacLength() {
            return this.a.a();
        }

        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.a.a(key, algorithmParameterSpec);
        }

        protected void engineUpdate(byte by) {
            this.a.a(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.a.a(byArray, n, n2);
        }

        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.a.a(byteBuffer);
        }

        protected byte[] engineDoFinal() {
            return this.a.b();
        }

        protected void engineReset() {
            this.a.c();
        }

        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA512(this);
        }
    }

    public static final class HmacSHA384
    extends MacSpi
    implements Cloneable {
        private final HmacCore a;

        public HmacSHA384() throws NoSuchAlgorithmException {
            SunJCE.a(this.getClass());
            this.a = new HmacCore("SHA-384", 128);
        }

        private HmacSHA384(HmacSHA384 hmacSHA384) throws CloneNotSupportedException {
            this.a = (HmacCore)hmacSHA384.a.clone();
        }

        protected int engineGetMacLength() {
            return this.a.a();
        }

        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.a.a(key, algorithmParameterSpec);
        }

        protected void engineUpdate(byte by) {
            this.a.a(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.a.a(byArray, n, n2);
        }

        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.a.a(byteBuffer);
        }

        protected byte[] engineDoFinal() {
            return this.a.b();
        }

        protected void engineReset() {
            this.a.c();
        }

        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA384(this);
        }
    }

    public static final class HmacSHA256
    extends MacSpi
    implements Cloneable {
        private final HmacCore a;

        public HmacSHA256() throws NoSuchAlgorithmException {
            SunJCE.a(this.getClass());
            this.a = new HmacCore("SHA-256", 64);
        }

        private HmacSHA256(HmacSHA256 hmacSHA256) throws CloneNotSupportedException {
            this.a = (HmacCore)hmacSHA256.a.clone();
        }

        protected int engineGetMacLength() {
            return this.a.a();
        }

        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.a.a(key, algorithmParameterSpec);
        }

        protected void engineUpdate(byte by) {
            this.a.a(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.a.a(byArray, n, n2);
        }

        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.a.a(byteBuffer);
        }

        protected byte[] engineDoFinal() {
            return this.a.b();
        }

        protected void engineReset() {
            this.a.c();
        }

        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA256(this);
        }
    }
}

