/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.memory.StringTable;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.utilities.HeapProgressThunk;
import sun.jvm.hotspot.utilities.ReversePtrs;
import sun.jvm.hotspot.utilities.ReversePtrsAnalysis;

public class PermStat
extends Tool {
    boolean verbose = true;

    public static void main(String[] args) {
        PermStat ps = new PermStat();
        ps.start(args);
        ps.stop();
    }

    public void run() {
        this.printInternStringStatistics();
        this.printClassLoaderStatistics();
    }

    private void printInternStringStatistics() {
        class StringStat
        implements StringTable.StringVisitor {
            private int count;
            private long size;
            private OopField stringValueField;

            StringStat() {
                VM vm = VM.getVM();
                SystemDictionary sysDict = vm.getSystemDictionary();
                InstanceKlass strKlass = sysDict.getStringKlass();
                this.stringValueField = (OopField)strKlass.findField("value", "[C");
            }

            private long stringSize(Instance instance) {
                return instance.getObjectSize() + this.stringValueField.getValue(instance).getObjectSize();
            }

            public void visit(Instance str) {
                ++this.count;
                this.size += this.stringSize(str);
            }

            public void print() {
                System.out.println(this.count + " intern Strings occupying " + this.size + " bytes.");
            }
        }
        StringStat stat = new StringStat();
        StringTable strTable = VM.getVM().getStringTable();
        strTable.stringsDo(stat);
        stat.print();
    }

    private void printClassLoaderStatistics() {
        LoaderData bootstrapLoaderData;
        HashMap loaderMap;
        PrintStream out;
        block13: {
            out = System.out;
            final PrintStream err = System.err;
            loaderMap = new HashMap();
            bootstrapLoaderData = new LoaderData();
            if (this.verbose) {
                err.print("finding class loader instances ..");
            }
            VM vm = VM.getVM();
            ObjectHeap heap = vm.getObjectHeap();
            vm.getSystemDictionary();
            InstanceKlass classLoaderKlass = SystemDictionary.getClassLoaderKlass();
            try {
                heap.iterateObjectsOfKlass(new DefaultHeapVisitor(){

                    public boolean doObj(Oop oop) {
                        loaderMap.put(oop, new LoaderData());
                        return false;
                    }
                }, classLoaderKlass);
            }
            catch (Exception se) {
                se.printStackTrace();
            }
            if (this.verbose) {
                err.println("done.");
                err.print("computing per loader stat ..");
            }
            SystemDictionary dict = VM.getVM().getSystemDictionary();
            dict.classesDo(new SystemDictionary.ClassAndLoaderVisitor(){

                public void visit(Klass k, Oop loader) {
                    LoaderData ld;
                    if (!(k instanceof InstanceKlass)) {
                        return;
                    }
                    LoaderData loaderData = ld = loader != null ? (LoaderData)loaderMap.get(loader) : bootstrapLoaderData;
                    if (ld != null) {
                        ++ld.numClasses;
                        long size = PermStat.this.computeSize((InstanceKlass)k);
                        ld.classDetail.add(new ClassData(k, size));
                        ld.classSize += size;
                    }
                }
            });
            if (this.verbose) {
                err.println("done.");
                err.print("please wait.. computing liveness");
            }
            ReversePtrsAnalysis analysis = new ReversePtrsAnalysis();
            if (this.verbose) {
                analysis.setHeapProgressThunk(new HeapProgressThunk(){

                    public void heapIterationFractionUpdate(double fractionOfHeapVisited) {
                        err.print('.');
                    }

                    public void heapIterationComplete() {
                        err.println("done.");
                    }
                });
            }
            try {
                analysis.run();
            }
            catch (Exception e) {
                if (!this.verbose) break block13;
                err.println("liveness analysis may be inaccurate ...");
            }
        }
        ReversePtrs liveness = VM.getVM().getRevPtrs();
        out.println("class_loader\tclasses\tbytes\tparent_loader\talive?\ttype");
        out.println();
        long numClassLoaders = 1L;
        long totalNumClasses = bootstrapLoaderData.numClasses;
        long totalClassSize = bootstrapLoaderData.classSize;
        long numAliveLoaders = 1L;
        long numDeadLoaders = 0L;
        out.print("<bootstrap>");
        out.print('\t');
        out.print(bootstrapLoaderData.numClasses);
        out.print('\t');
        out.print(bootstrapLoaderData.classSize);
        out.print('\t');
        out.print("  null  ");
        out.print('\t');
        out.print("live");
        out.print('\t');
        out.println("<internal>");
        Iterator keyItr = loaderMap.keySet().iterator();
        while (keyItr.hasNext()) {
            Oop loader = (Oop)keyItr.next();
            LoaderData data = (LoaderData)loaderMap.get(loader);
            ++numClassLoaders;
            totalNumClasses += data.numClasses;
            totalClassSize += data.classSize;
            out.print(loader.getHandle());
            out.print('\t');
            out.print(data.numClasses);
            out.print('\t');
            out.print(data.classSize);
            out.print('\t');
            class ParentFinder
            extends DefaultOopVisitor {
                private Oop parent = null;

                ParentFinder() {
                }

                public void doOop(OopField field, boolean isVMField) {
                    if (field.getID().getName().equals("parent")) {
                        this.parent = field.getValue(this.getObj());
                    }
                }

                public Oop getParent() {
                    return this.parent;
                }
            }
            ParentFinder parentFinder = new ParentFinder();
            loader.iterate(parentFinder, false);
            Oop parent = parentFinder.getParent();
            out.print(parent != null ? parent.getHandle().toString() : "  null  ");
            out.print('\t');
            boolean alive = liveness != null ? liveness.get(loader) != null : true;
            out.print(alive ? "live" : "dead");
            if (alive) {
                ++numAliveLoaders;
            } else {
                ++numDeadLoaders;
            }
            out.print('\t');
            Klass loaderKlass = loader.getKlass();
            if (loaderKlass != null) {
                out.print(loaderKlass.getName().asString());
                out.print('@');
                out.print(loader.getKlass().getHandle());
            } else {
                out.print("    null!    ");
            }
            out.println();
        }
        out.println();
        out.print("total = ");
        out.print(numClassLoaders);
        out.print('\t');
        out.print(totalNumClasses);
        out.print('\t');
        out.print(totalClassSize);
        out.print('\t');
        out.print("    N/A    ");
        out.print('\t');
        out.print("alive=");
        out.print(numAliveLoaders);
        out.print(", dead=");
        out.print(numDeadLoaders);
        out.print('\t');
        out.print("    N/A    ");
        out.println();
    }

    private long computeSize(InstanceKlass k) {
        ObjArray interfaces;
        long size = 0L;
        size += k.getObjectSize();
        size += k.getConstants().getObjectSize();
        ConstantPoolCache cpCache = k.getConstants().getCache();
        if (cpCache != null) {
            size += cpCache.getObjectSize();
        }
        size += (interfaces = k.getLocalInterfaces()).getLength() != 0L ? interfaces.getObjectSize() : 0L;
        ObjArray transitiveInterfaces = k.getTransitiveInterfaces();
        size += transitiveInterfaces.getLength() != 0L ? transitiveInterfaces.getObjectSize() : 0L;
        TypeArray innerClasses = k.getInnerClasses();
        size += innerClasses.getObjectSize();
        size += k.getFields().getObjectSize();
        ObjArray methods = k.getMethods();
        size += methods.getLength() != 0L ? methods.getObjectSize() : 0L;
        TypeArray methodOrdering = k.getMethodOrdering();
        size += methodOrdering.getLength() != 0L ? methodOrdering.getObjectSize() : 0L;
        int numMethods = (int)methods.getLength();
        for (int i = 0; i < numMethods; ++i) {
            Method m = (Method)methods.getObjAt(i);
            size += m.getObjectSize();
        }
        return size;
    }

    private static class LoaderData {
        long numClasses;
        long classSize;
        List classDetail = new ArrayList();

        private LoaderData() {
        }
    }

    private static class ClassData {
        Klass klass;
        long size;

        ClassData(Klass klass, long size) {
            this.klass = klass;
            this.size = size;
        }
    }
}

