/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CleanupThread;
import com.sun.deploy.cache.DefaultLocalApplicationProperties;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;

public class Cache {
    private static final int VERSION_INT = 602;
    private static final String VERSION_STRING = "6.0";
    private static final String DASH = "-";
    static final String INDEX_FILE_EXT = ".idx";
    private static final String MUFFIN_FILE_EXT = ".muf";
    private static final int NUM_OF_CACHE_SUBDIR = 64;
    static final char APPLICATION_TYPE = 'A';
    static final char EXTENSION_TYPE = 'E';
    private static SecureRandom random = null;
    private static String cachePath;
    private static File cacheDir;
    private static File sysCacheDir;
    private static File muffinDir;
    private static Hashtable loadedResource;
    protected static ReferenceQueue refQueue;
    private static final int BUF_SIZE = 32768;
    private static HashMap loadedProperties;
    private static CleanupThread ct;
    private static final Object syncObject;
    private static boolean cleanupEnabled;
    private static ArrayList strongRef;
    static final String LAST_ACCESS_FILE = "lastAccessed";
    static final String REMOVED_APPS = "removed.apps";

    public static void setCleanupEnabled(boolean bl) {
        cleanupEnabled = bl;
    }

    private static void createCacheBucketDirectories(String string) {
        for (int i = 0; i < 64; ++i) {
            File file = new File(string + File.separator + i);
            file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = syncObject;
        synchronized (object) {
            loadedResource.clear();
            loadedProperties.clear();
            cachePath = Config.getCacheDirectory() + File.separator + VERSION_STRING;
            String string = cachePath + File.separator + "muffin";
            cacheDir = new File(cachePath);
            muffinDir = new File(string);
            cacheDir.mkdirs();
            Cache.createCacheBucketDirectories(cachePath);
            muffinDir.mkdirs();
            if (Config.getSystemCacheDirectory() != null && Config.getSystemCacheDirectory().length() != 0) {
                String string2 = Config.getSystemCacheDirectory() + File.separator + VERSION_STRING;
                sysCacheDir = new File(string2);
                if (Environment.isSystemCacheMode()) {
                    sysCacheDir.mkdirs();
                    Cache.createCacheBucketDirectories(string2);
                }
            } else {
                sysCacheDir = null;
            }
            long l = Config.getCacheSizeMax();
            if (l > 0L && l < 0x500000L) {
                l = 0x500000L;
            }
        }
    }

    static void addToCleanupThreadLoadedResourceList(String string) {
        if (ct != null && cleanupEnabled) {
            ct.addToLoadedResourceList(string);
        }
    }

    static void cleanup() {
        if (ct != null && cleanupEnabled) {
            ct.startCleanup();
        }
    }

    private Cache() {
    }

    static void markResourceIncomplete(CacheEntry cacheEntry) {
        if (cacheEntry != null) {
            cacheEntry.setIncomplete(1);
            try {
                cacheEntry.writeFileToDisk();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    public static final boolean isSupportedProtocol(URL uRL) {
        String string = uRL.getProtocol();
        return string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"));
    }

    public static boolean isCacheEnabled() {
        return Config.getBooleanProperty("deployment.cache.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoadedProperties(String string) {
        HashMap hashMap = loadedProperties;
        synchronized (hashMap) {
            loadedProperties.remove(string);
        }
    }

    public static LocalApplicationProperties getLocalApplicationProperties(CacheEntry cacheEntry) {
        URL uRL = null;
        try {
            uRL = new URL(cacheEntry.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return Cache.getLocalApplicationProperties(uRL, cacheEntry.getVersion(), true);
    }

    public static LocalApplicationProperties getLocalApplicationProperties(String string) {
        if (!Cache.isCacheEnabled()) {
            return null;
        }
        CacheEntry cacheEntry = Cache.getCacheEntryFromFile(new File(string + INDEX_FILE_EXT));
        if (cacheEntry == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(cacheEntry.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
        return Cache.getLocalApplicationProperties(uRL, cacheEntry.getVersion(), true);
    }

    public static LocalApplicationProperties getLocalApplicationProperties(URL uRL) {
        return Cache.getLocalApplicationProperties(uRL, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalApplicationProperties getLocalApplicationProperties(URL uRL, String string, boolean bl) {
        LocalApplicationProperties localApplicationProperties = null;
        if (Cache.isCacheEnabled() && uRL != null) {
            String string2 = uRL.toString() + "?" + string;
            HashMap hashMap = loadedProperties;
            synchronized (hashMap) {
                localApplicationProperties = (LocalApplicationProperties)loadedProperties.get(string2);
                if (localApplicationProperties == null) {
                    localApplicationProperties = new DefaultLocalApplicationProperties(uRL, string, bl);
                    loadedProperties.put(string2, localApplicationProperties);
                } else {
                    localApplicationProperties.refreshIfNecessary();
                }
            }
        }
        return localApplicationProperties;
    }

    public static String getLapFileName(URL uRL, String string) {
        String string2 = Cache.getKey(uRL);
        return Cache.getBucket(string2) + File.separator + string2 + VERSION_STRING + Cache.getVersionTag(string) + ".lap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putLapData(char c, URL uRL, String string, byte[] byArray) throws IOException {
        File file = Cache.getActiveCacheDir();
        File file2 = new File(file, Cache.getLapFileName(uRL, string));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray2 = new byte[32768];
        try {
            int n = byteArrayInputStream.read(byArray2);
            while (n >= 0) {
                bufferedOutputStream.write(byArray2, 0, n);
                n = byteArrayInputStream.read(byArray2);
            }
        }
        finally {
            bufferedOutputStream.close();
            ((InputStream)byteArrayInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getLapData(char c, URL uRL, String string, boolean bl) throws IOException {
        File file;
        File file2 = file = bl ? sysCacheDir : cacheDir;
        if (file == null) {
            return null;
        }
        File file3 = new File(file, Cache.getLapFileName(uRL, string));
        long l = file3.length();
        if (l > 0L && l < 0x100000L) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file3));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
            byte[] byArray = new byte[32768];
            try {
                int n = bufferedInputStream.read(byArray);
                while (n >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    n = bufferedInputStream.read(byArray);
                }
            }
            finally {
                byteArrayOutputStream.close();
                bufferedInputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public static String getNewExtensionInstallDirectory() throws IOException {
        String string = cacheDir.getAbsolutePath() + File.separator + "ext";
        String string2 = null;
        int n = 0;
        do {
            File file;
            if (!(file = new File(string2 = string + File.separator + "E" + new Date().getTime() + File.separator)).mkdirs()) {
                string2 = null;
            }
            Thread.yield();
        } while (string2 == null && ++n < 50);
        if (string2 == null) {
            throw new IOException("Unable to create temp. dir for extension");
        }
        return string2;
    }

    public static String getCacheEntryVersion(URL uRL, String string) {
        String string2 = null;
        CacheEntry cacheEntry = Cache.getLatestCacheEntry(uRL, string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getVersion();
        }
        return string2;
    }

    public static int getCacheEntryContentLength(URL uRL, String string) {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string);
        if (cacheEntry != null) {
            return cacheEntry.getContentLength();
        }
        return 0;
    }

    public static long getCacheEntryLastModified(URL uRL, String string) {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string);
        if (cacheEntry != null) {
            return cacheEntry.getLastModified();
        }
        return 0L;
    }

    static CacheEntry downloadResourceToCache(final URL uRL, final String string, final URLConnection uRLConnection, final URL uRL2, final boolean bl, final int n, final InputStream inputStream) throws IOException, CanceledDownloadException {
        CacheEntry cacheEntry;
        block3: {
            cacheEntry = null;
            try {
                cacheEntry = (CacheEntry)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, CanceledDownloadException {
                        String string3 = Cache.generateCacheFileName(uRL, string);
                        File file = Cache.getActiveCacheDir();
                        File file2 = new File(file, string3 + Cache.getIndexFileExtension());
                        CacheEntry cacheEntry = new CacheEntry(file2);
                        cacheEntry.writeFileToDisk();
                        DownloadEngine.getHttpDownloadImpl().download(uRLConnection.getContentLength(), uRLConnection.getURL(), inputStream, uRLConnection.getContentEncoding(), cacheEntry.getTempDataFile(), null);
                        if (cacheEntry.processTempDataFile(bl, null, uRL, uRL2, string)) {
                            cacheEntry.setBusy(0);
                            cacheEntry.setIncomplete(0);
                            cacheEntry.setURL(string == null ? uRL2.toString() : uRL.toString());
                            if (bl) {
                                cacheEntry.setContentLength((int)new File(cacheEntry.getResourceFilename()).length());
                            } else {
                                cacheEntry.setContentLength(uRLConnection.getContentLength());
                            }
                            cacheEntry.setLastModified(uRLConnection.getLastModified());
                            cacheEntry.setExpirationDate(uRLConnection.getExpiration());
                            if (string != null) {
                                cacheEntry.setVersion(string);
                            }
                            MessageHeader messageHeader = BasicHttpRequest.initializeHeaderFields(uRLConnection);
                            if (uRLConnection instanceof HttpURLConnection) {
                                ((HttpURLConnection)uRLConnection).disconnect();
                                String string2 = uRLConnection.getRequestProperty("content-type");
                                if (string2 != null && messageHeader != null) {
                                    messageHeader.add("deploy-request-content-type", string2);
                                }
                            }
                            cacheEntry.setHeaders(messageHeader);
                            cacheEntry.writeFileToDisk(n, null);
                            Cache.recordLastAccessed();
                            return cacheEntry;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (!(privilegedActionException.getException() instanceof CanceledDownloadException)) break block3;
                throw (CanceledDownloadException)privilegedActionException.getException();
            }
        }
        return cacheEntry;
    }

    public static CacheEntry downloadResourceToCache(URL uRL, String string, HttpResponse httpResponse, HttpDownloadListener httpDownloadListener, DownloadEngine.DownloadDelegate downloadDelegate, boolean bl, URL uRL2, CacheEntry cacheEntry, boolean bl2, int n) throws IOException, CanceledDownloadException {
        String string2 = Cache.generateCacheFileName(uRL, string);
        File file = Cache.getActiveCacheDir();
        File file2 = new File(file, string2 + Cache.getIndexFileExtension());
        CacheEntry cacheEntry2 = new CacheEntry(file2);
        cacheEntry2.writeFileToDisk();
        DownloadEngine.getHttpDownloadImpl().download(httpResponse.getContentLength(), httpResponse.getRequest(), httpResponse.getInputStream(), httpResponse.getContentEncoding(), cacheEntry2.getTempDataFile(), httpDownloadListener);
        httpResponse.disconnect();
        if (cacheEntry2.processTempDataFile(bl2, downloadDelegate, uRL, uRL2, string)) {
            cacheEntry2.setBusy(0);
            cacheEntry2.setIncomplete(0);
            cacheEntry2.setURL(string == null && !Environment.isImportMode() ? uRL2.toString() : uRL.toString());
            MessageHeader messageHeader = httpResponse.getHeaders();
            if (messageHeader != null && n == 2) {
                messageHeader.add("deploy-request-content-type", "application/x-java-archive");
            }
            cacheEntry2.setHeaders(messageHeader);
            cacheEntry2.setContentLength(httpResponse.getContentLength());
            cacheEntry2.setLastModified(httpResponse.getLastModified());
            cacheEntry2.setExpirationDate(httpResponse.getExpiration());
            if (string != null) {
                cacheEntry2.setVersion(string);
            }
            cacheEntry2.writeFileToDisk(n, downloadDelegate);
            if (bl) {
                if (!Cache.removeCacheEntry(cacheEntry, false)) {
                    cacheEntry.setIncomplete(1);
                    cacheEntry.writeFileToDisk();
                }
                cacheEntry = null;
            }
            Cache.recordLastAccessed();
            return cacheEntry2;
        }
        return null;
    }

    public static int getCacheVersion() {
        return 602;
    }

    public static String getCacheVersionString() {
        return VERSION_STRING;
    }

    public static long getCacheSize(boolean bl) {
        long l = 0L;
        File[] fileArray = Cache.getCacheEntries(bl);
        for (int i = 0; i < fileArray.length; ++i) {
            l += fileArray[i].length();
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile(fileArray[i]);
            if (cacheEntry == null) continue;
            l += (long)cacheEntry.getContentLength();
            l += Cache.getTotalSize(new File(cacheEntry.getNativeLibPath()));
        }
        return l;
    }

    private static long getTotalSize(File file) {
        long l = 0L;
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    l += Cache.getTotalSize(fileArray[i]);
                }
            } else {
                l += file.length();
            }
        }
        return l;
    }

    private static SecureRandom getSecureRandom() {
        if (random == null) {
            random = ServiceManager.getService().getSecureRandom();
            random.nextInt();
        }
        return random;
    }

    public static boolean exists() {
        if (Environment.isSystemCacheMode()) {
            return sysCacheDir != null && sysCacheDir.exists();
        }
        return cacheDir.exists();
    }

    public static boolean canWrite() {
        if (Environment.isSystemCacheMode()) {
            return sysCacheDir != null && sysCacheDir.canWrite();
        }
        return cacheDir.canWrite();
    }

    public static Object addLoadedResource(URL uRL, String string, String string2) {
        if (uRL == null) {
            return null;
        }
        Object v = loadedResource.get(uRL.toString());
        if (v != null) {
            return v;
        }
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string, string2);
        if (cacheEntry != null) {
            return loadedResource.put(uRL.toString(), cacheEntry);
        }
        return null;
    }

    public static Object addLoadedResource(Object object, Object object2) {
        return loadedResource.put(object, object2);
    }

    public static Object getLoadedResource(Object object) {
        Cache.updateLoadedResource();
        return loadedResource.get(object);
    }

    public static Object removeLoadedResource(Object object) {
        return loadedResource.remove(object);
    }

    public static void clearLoadedResources() {
        loadedResource.clear();
        DownloadEngine.clearUpdateCheckDoneList();
        DownloadEngine.clearNoCacheJarFileList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNoHrefCacheEntry(URL uRL, byte[] byArray) throws IOException {
        File file = Cache.getActiveCacheDir();
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, null, file);
        String string = Cache.generateCacheFileName(uRL, null);
        File file2 = new File(file, string + Cache.getIndexFileExtension());
        File file3 = new File(file, string);
        CacheEntry cacheEntry2 = new CacheEntry(file2);
        cacheEntry2.writeFileToDisk();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(cacheEntry2.getTempDataFile()));
        try {
            bufferedOutputStream.write(byArray);
        }
        finally {
            bufferedOutputStream.close();
        }
        if (cacheEntry2.processTempDataFile(false, null, uRL, uRL, null)) {
            cacheEntry2.setBusy(0);
            cacheEntry2.setIncomplete(0);
            cacheEntry2.setURL(uRL.toString());
            cacheEntry2.setNoHref(1);
            cacheEntry2.writeFileToDisk();
            if (cacheEntry != null) {
                Cache.removeCacheEntry(cacheEntry, false);
            }
            Cache.recordLastAccessed();
        }
    }

    private static void updateLoadedResource() {
        JarReference jarReference;
        while ((jarReference = (JarReference)refQueue.poll()) != null) {
            String string = jarReference.getURL();
            Cache.removeLoadedResource(string);
        }
    }

    protected static WeakReference createResourceReference(Object object, String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        JarReference jarReference = new JarReference(object, refQueue, string);
        return jarReference;
    }

    public static String getIndexFileExtension() {
        return INDEX_FILE_EXT;
    }

    private static String getVersionTag(String string) {
        return string == null ? "" : DASH + string + DASH;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    public static void setSystemCacheDir(String string) {
        if (string == null || string.length() == 0) {
            sysCacheDir = null;
        } else {
            String string2 = string + File.separator + VERSION_STRING;
            sysCacheDir = new File(string2);
        }
    }

    public static File getActiveCacheDir() {
        return Environment.isSystemCacheMode() ? sysCacheDir : cacheDir;
    }

    public static File[] getCacheEntries(boolean bl) {
        File file;
        File file2 = file = bl || Environment.isSystemCacheMode() ? sysCacheDir : cacheDir;
        if (file == null) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < 64; ++i) {
            File file3 = new File(file.getPath() + File.separator + i);
            if (!file3.exists()) continue;
            File[] fileArray = file3.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    boolean bl = string.endsWith(Cache.INDEX_FILE_EXT);
                    return bl;
                }
            });
            for (int j = 0; j < fileArray.length; ++j) {
                arrayList.add(fileArray[j]);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static Iterator getJnlpCacheEntries(boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = Cache.getCacheEntries(bl);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = Cache.getURLFromIndexFile(fileArray[i]);
                if (string == null) continue;
                int n = string.lastIndexOf(63);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if (!string.endsWith(".jnlp") && !string.endsWith(".jarjnlp")) continue;
                String string2 = fileArray[i].getPath();
                String string3 = string2.substring(0, string2.length() - 4);
                arrayList.add(new File(string3));
            }
        }
        return arrayList.iterator();
    }

    public static void removeRemovedApp(String string, String string2) {
        Properties properties = Cache.getRemovedApps();
        String string3 = properties.getProperty(string);
        if (string3 != null && string3.equals(string2)) {
            properties.remove(string);
            Cache.setRemovedApps(properties);
        }
    }

    public static void saveRemovedApp(URL uRL, String string) {
        if (Environment.isSystemCacheMode() ? Cache.getCacheEntry(uRL, null, null, cacheDir) != null : Cache.getCacheEntry(uRL, null, null, sysCacheDir) != null) {
            return;
        }
        Properties properties = Cache.getRemovedApps();
        properties.setProperty(uRL.toString(), string);
        Cache.setRemovedApps(properties);
    }

    public static void setRemovedApps(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Cache.getRemovePath());
            properties.store(fileOutputStream, "Removed JNLP Applications");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Properties getRemovedApps() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(Cache.getRemovePath());
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static long getLastAccessed(boolean bl) {
        File file = new File(bl ? sysCacheDir : cacheDir, LAST_ACCESS_FILE);
        return file.lastModified();
    }

    private static void recordLastAccessed() {
        File file = new File(Cache.getActiveCacheDir(), LAST_ACCESS_FILE);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getRemovePath() {
        return cachePath + File.separator + REMOVED_APPS;
    }

    public static boolean removeCacheEntry(URL uRL, String string, String string2) {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string, string2, Cache.getActiveCacheDir());
        return Cache.removeCacheEntry(cacheEntry);
    }

    public static final void touch(final File file) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    file.setLastModified(System.currentTimeMillis());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
        }
    }

    public static boolean removeCacheEntry(final CacheEntry cacheEntry, final boolean bl) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl2 = Cache.removeCacheEntryImpl(cacheEntry, bl);
                return Boolean.valueOf(String.valueOf(bl2));
            }
        });
        return bl2;
    }

    private static boolean removeCacheEntryImpl(CacheEntry cacheEntry, boolean bl) {
        Object object;
        Trace.println(ResourceManager.getString("cache.removeCacheEntry", cacheEntry == null ? "" : cacheEntry.getURL()), TraceLevel.NETWORK);
        if (!cacheEntry.getIndexFile().getParentFile().getParentFile().equals(Cache.getActiveCacheDir())) {
            return true;
        }
        File file = new File(cacheEntry.getResourceFilename());
        String string = cacheEntry.getURL();
        String string2 = cacheEntry.getVersion();
        boolean bl2 = false;
        if (cacheEntry.isReferenceClear()) {
            JarFile jarFile;
            if (string != null && (string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar")) && (jarFile = cacheEntry.getJarFile()) != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
            bl2 = file.delete();
        } else {
            file.deleteOnExit();
        }
        Cache.clobber(new File(cacheEntry.getNativeLibPath()));
        boolean bl3 = cacheEntry.getIndexFile().delete();
        try {
            object = Cache.getLapFileName(new URL(string), string2);
            File file2 = new File(Cache.getActiveCacheDir(), (String)object);
            if (file2.exists() && bl) {
                file2.delete();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object = new File(cacheEntry.getResourceFilename() + ".ico");
        if (((File)object).exists()) {
            ((File)object).delete();
        }
        Cache.recordLastAccessed();
        Cache.removeLoadedResource(cacheEntry.getURL());
        return bl2 && bl3;
    }

    private static void clobber(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    Cache.clobber(fileArray[i]);
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

    public static boolean removeCacheEntry(CacheEntry cacheEntry) {
        return Cache.removeCacheEntry(cacheEntry, true);
    }

    private static File[] getMatchingIndexFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        final File file2 = new File(file.getPath() + File.separator + Cache.getBucket(string));
        File[] fileArray = (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file2.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getName();
                        return string.startsWith(string) && string.endsWith(Cache.INDEX_FILE_EXT);
                    }
                });
                return fileArray;
            }
        });
        return fileArray;
    }

    public static CacheEntry getCacheEntryFromFile(File file) {
        CacheEntry cacheEntry = new CacheEntry(file);
        if (cacheEntry != null && cacheEntry.getIncomplete() == 0) {
            return cacheEntry;
        }
        return null;
    }

    public static String getVersionFromFilename(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DASH);
        if (stringTokenizer.countTokens() != 4) {
            return null;
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    public static CacheEntry getLatestCacheEntry(URL uRL, String string) {
        File file = null;
        Object var3_3 = null;
        File[] fileArray = Cache.getMatchingIndexFiles(cacheDir, uRL);
        for (int i = 0; i < fileArray.length; ++i) {
            if (file == null) {
                file = fileArray[i];
                continue;
            }
            String string2 = Cache.getVersionFromFilename(fileArray[i].getName());
            String string3 = Cache.getVersionFromFilename(file.getName());
            if (string2 == null || string3 != null && string2.compareTo(string3) <= 0) continue;
            file = fileArray[i];
        }
        if (file != null) {
            return Cache.getCacheEntryFromFile(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLFromIndexFile(File file) {
        RandomAccessFile randomAccessFile = null;
        String string = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.read();
            randomAccessFile.read();
            randomAccessFile.readInt();
            randomAccessFile.read();
            randomAccessFile.read();
            randomAccessFile.read();
            randomAccessFile.readInt();
            randomAccessFile.readLong();
            randomAccessFile.readLong();
            randomAccessFile.readUTF();
            string = randomAccessFile.readUTF();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEntryIncomplete(File file) {
        RandomAccessFile randomAccessFile = null;
        boolean bl = true;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(1L);
            int n = randomAccessFile.read();
            randomAccessFile.close();
            if (n == 0) {
                bl = false;
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
        return bl;
    }

    private static CacheEntry getCacheEntryFromIdxFiles(File[] fileArray, URL uRL, String string) {
        CacheEntry cacheEntry = null;
        CacheEntry cacheEntry2 = null;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                cacheEntry = new CacheEntry(fileArray[i]);
                if (cacheEntry.getIncomplete() == 0) {
                    if (cacheEntry.getURL().equals(uRL.toString())) {
                        if (string == null && cacheEntry.getVersion() == null) {
                            cacheEntry2 = cacheEntry;
                            break;
                        }
                        if (string == null || !new VersionString(string).contains(cacheEntry.getVersion())) continue;
                        if (cacheEntry2 == null) {
                            cacheEntry2 = cacheEntry;
                            continue;
                        }
                        if (cacheEntry.getVersion() == null || cacheEntry.getVersion().compareTo(cacheEntry2.getVersion()) <= 0) continue;
                        cacheEntry2 = cacheEntry;
                        continue;
                    }
                    if (cacheEntry.getURL().indexOf(63) == -1) continue;
                    Cache.removeCacheEntry(cacheEntry, false);
                    continue;
                }
                Cache.cleanup();
            }
        }
        return cacheEntry2;
    }

    public static CacheEntry getCacheEntry(URL uRL, String string, String string2) {
        Object object;
        CacheEntry cacheEntry = (CacheEntry)Cache.getLoadedResource(uRL.toString());
        if (cacheEntry != null) {
            object = cacheEntry.getVersion();
            if (string2 == null && object == null || string2 != null && object != null && ((String)object).compareTo(string2) >= 0) {
                return cacheEntry;
            }
        }
        object = Cache.getCacheEntry(uRL, string, string2, cacheDir);
        CacheEntry cacheEntry2 = Cache.getCacheEntry(uRL, string, string2, sysCacheDir);
        if (Environment.isSystemCacheMode()) {
            return cacheEntry2;
        }
        if (cacheEntry2 != null) {
            if (object != null) {
                if (((CacheEntry)object).getLastModified() < cacheEntry2.getLastModified()) {
                    object = cacheEntry2;
                }
            } else {
                object = cacheEntry2;
            }
        }
        if (object == null) {
            Trace.println(ResourceManager.getString("cache.getCacheEntry.return.notfound", uRL == null ? "" : uRL.toString(), string2), TraceLevel.NETWORK);
        } else {
            Trace.println(ResourceManager.getString("cache.getCacheEntry.return.found", uRL == null ? "" : uRL.toString(), string2), TraceLevel.NETWORK);
            Cache.addLoadedResource(uRL.toString(), object);
        }
        return object;
    }

    public static CacheEntry getCacheEntry(URL uRL, String string, String string2, File file) {
        if (file == null) {
            return null;
        }
        File[] fileArray = Cache.getMatchingIndexFiles(file, uRL);
        return Cache.getCacheEntryFromIdxFiles(fileArray, uRL, string2);
    }

    private static File[] getMatchingMuffinFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string2 = file.getName();
                return string2.startsWith(string) && !string2.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        return fileArray;
    }

    private static File[] getMatchingMuffinAttributeFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string2 = file.getName();
                return string2.startsWith(string) && string2.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        return fileArray;
    }

    public static File getMuffinFile(URL uRL) {
        String string = Cache.getKey(uRL);
        File[] fileArray = Cache.getMatchingMuffinFiles(muffinDir, uRL);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    public static File getMuffinAttributeFile(URL uRL) {
        String string = Cache.getKey(uRL);
        File[] fileArray = Cache.getMatchingMuffinAttributeFiles(muffinDir, uRL);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getMuffinAttributes(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        try {
            File file = Cache.getMuffinAttributeFile(uRL);
            if (file == null) {
                throw new FileNotFoundException("Muffin not found for " + uRL);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = bufferedReader.readLine();
            try {
                l = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            string = bufferedReader.readLine();
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return new long[]{l, l2};
    }

    public static void removeMuffinEntry(URL uRL) throws IOException {
        File file = Cache.getMuffinFile(uRL);
        if (file != null) {
            if (!file.delete()) {
                throw new IOException("delete failed: " + file);
            }
            File file2 = new File(file.getPath() + MUFFIN_FILE_EXT);
            if (!file2.delete()) {
                throw new IOException("delete failed: " + file2);
            }
        } else {
            throw new FileNotFoundException("Muffin for " + uRL + " does not exists");
        }
    }

    public static void createMuffinEntry(URL uRL, int n, long l) throws IOException {
        String string = Cache.getKey(uRL);
        File[] fileArray = Cache.getMatchingMuffinAttributeFiles(muffinDir, uRL);
        if (fileArray.length != 0) {
            throw new IOException("insert failed in cache: target already exixts");
        }
        String string2 = string + Integer.toString(Cache.getRandom(), 16);
        File file = new File(muffinDir, string2 + MUFFIN_FILE_EXT);
        File file2 = new File(muffinDir, string2);
        Cache.putMuffinAttributes(file, uRL, n, l);
        file2.createNewFile();
    }

    public static String[] getMuffinNames(URL uRL) {
        Vector<String> vector = new Vector<String>();
        File[] fileArray = muffinDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return string.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        URL uRL2 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                uRL2 = Cache.getCachedMuffinURL(fileArray[i]);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (uRL2 == null) continue;
            URL uRL3 = HttpUtils.removeQueryStringFromURL(uRL2);
            String string = uRL3.getFile().substring(1 + uRL3.getFile().lastIndexOf(47));
            if (!uRL2.toString().equals(uRL.toString() + string)) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }

    public static URL[] getAccessibleMuffins(URL uRL) throws IOException {
        URL[] uRLArray = new URL[255];
        File[] fileArray = muffinDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return string.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL2 = Cache.getCachedMuffinURL(fileArray[i]);
            if (!uRL2.getHost().equals(uRL.getHost())) continue;
            uRLArray[n] = uRL2;
            ++n;
        }
        return uRLArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL getCachedMuffinURL(File file) throws IOException {
        Object object;
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        String string = null;
        try {
            object = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        object = null;
        try {
            object = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return object;
    }

    public static long getMuffinSize(URL uRL) throws IOException {
        long l = 0L;
        File file = Cache.getMuffinFile(uRL);
        if (file != null && file.exists()) {
            l += file.length();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putMuffinAttributes(File file, URL uRL, int n, long l) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        try {
            printStream.println(n);
            printStream.println(l);
            printStream.println(uRL.toString());
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putMuffinAttributes(URL uRL, int n, long l) throws IOException {
        File file = Cache.getMuffinAttributeFile(uRL);
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        try {
            printStream.println(n);
            printStream.println(l);
            printStream.println(uRL.toString());
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public static String generateCacheFileName(final URL uRL, final String string) throws IOException {
        String string2;
        block2: {
            string2 = null;
            try {
                string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File file;
                        String string3;
                        File file2;
                        String string2 = Cache.getKey(uRL);
                        do {
                            string3 = Cache.getBucket(string2) + File.separator + string2 + Integer.toString(Cache.getRandom(), 16) + Cache.getVersionTag(string);
                            file = new File(cacheDir, string3);
                        } while ((file2 = new File(cacheDir, string3 + Cache.INDEX_FILE_EXT)).exists() || file.exists());
                        file2 = null;
                        file = null;
                        return string3;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
        return string2;
    }

    public static int getBucket(String string) {
        return Integer.valueOf(string.substring(0, string.length() - 1), 16) & 0x3F;
    }

    protected static String getKey(URL uRL) {
        int n = Cache.hashCode(HttpUtils.removeQueryStringFromURL(uRL));
        if (n < 0) {
            n -= Integer.MIN_VALUE;
        }
        String string = Integer.toString(n, 16);
        return string + DASH;
    }

    protected static int hashCode(URL uRL) {
        int n = uRL.toString().hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected static final String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        return string2;
    }

    protected static final int getRandom() {
        return 0x10000000 + Cache.getSecureRandom().nextInt(0x6FFFFFFF);
    }

    public static void insertFile(File file, int n, URL uRL, String string, long l, long l2) throws IOException {
        String string2 = Cache.generateCacheFileName(uRL, string);
        File file2 = Cache.getActiveCacheDir();
        File file3 = new File(file2, string2 + Cache.getIndexFileExtension());
        CacheEntry cacheEntry = new CacheEntry(file3);
        cacheEntry.writeFileToDisk();
        try {
            Cache.copyFile(file, new File(file2, string2));
        }
        catch (IOException iOException) {
            Cache.removeCacheEntry(cacheEntry);
            throw iOException;
        }
        cacheEntry.setBusy(0);
        cacheEntry.setIncomplete(0);
        cacheEntry.setURL(uRL.toString());
        cacheEntry.setContentLength((int)file.length());
        cacheEntry.setLastModified(l);
        cacheEntry.setExpirationDate(l2);
        if (string != null) {
            cacheEntry.setVersion(string);
        }
        if (n == 2) {
            MessageHeader messageHeader = new MessageHeader();
            messageHeader.add("deploy-request-content-type", "application/x-java-archive");
            cacheEntry.setHeaders(messageHeader);
        }
        cacheEntry.writeFileToDisk(n, null);
        Cache.recordLastAccessed();
    }

    public static void insertMuffin(URL uRL, File file, int n, long l) throws IOException {
        File[] fileArray = Cache.getMatchingMuffinAttributeFiles(muffinDir, uRL);
        if (fileArray.length != 0) {
            throw new IOException("insert failed in cache: target already exixts");
        }
        String string = Cache.getKey(uRL);
        String string2 = string + Integer.toString(Cache.getRandom(), 16);
        File file2 = new File(muffinDir, string2 + MUFFIN_FILE_EXT);
        Cache.putMuffinAttributes(file2, uRL, n, l);
        Cache.copyFile(file, new File(muffinDir, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[10240];
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n = bufferedInputStream.read(byArray);
            while (n >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void removeAllMuffins() {
        File[] fileArray = muffinDir.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
    }

    static {
        loadedResource = new Hashtable();
        refQueue = new ReferenceQueue();
        loadedProperties = new HashMap();
        syncObject = new Object();
        cleanupEnabled = true;
        Cache.reset();
        if (Cache.isCacheEnabled()) {
            ct = new CleanupThread("CacheCleanUpThread", syncObject);
            ct.start();
        }
        strongRef = new ArrayList();
    }

    protected static class JarReference
    extends WeakReference {
        String url;

        public JarReference(Object object, ReferenceQueue referenceQueue, String string) {
            super(object, referenceQueue);
            this.url = string;
        }

        public String getURL() {
            return this.url;
        }
    }
}

