#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "safecopy.h"
#include "state.h"
extern struct apm_state state;

#include "apm_react.h"

extern char apm_device_file[];
extern char statuscolor[];
extern char greencolor[];
extern char yellowcolor[];
extern char redcolor[];
extern char slidercolor[];
extern char sliderbgcolor[];

char * Trim( char * line )
{
	char * pointer;
	char * tail;

	pointer = line;
	while( (*pointer == ' ') || (*pointer == '\t') )
		++pointer;
	if ( (tail = index(pointer, '\n')) )
		*tail = 0;
	return pointer;
}

char * Strip( char * line )
{
	char * pointer;
	char * tail;

	pointer = Trim( line );
	if ( (tail = index(pointer, ' ')) )
		*tail = 0;
	if ( (tail = index(pointer, '\t')) )
		*tail = 0;
	return pointer;
}

void ReadFile( FILE * fd )
{
	char buffer[256];
	int tmp;

	while ( !feof( fd ) ) {
		if ( fscanf( fd, "%s", buffer ) < 0 )
			break;
		if ( buffer[0] == '#' ) {
			fgets( buffer, 255, fd );
		} else if ( !strcasecmp("Fail", buffer) ) {
			state.fail = 1;
#ifdef DEBUG
			printf("Fail = 1\n");
#endif
		} else if ( !strcasecmp("NoFail", buffer) ) {
			state.fail = 0;
#ifdef DEBUG
			printf("Fail = 0\n");
#endif
		} else if ( !strcasecmp("SysLevels", buffer) ) {
			state.system_levels = 1;
#ifdef DEBUG
			printf("SystemLevels = 1\n");
#endif
		} else if ( !strcasecmp("NoSysLevels", buffer) ) {
			state.system_levels = 0;
#ifdef DEBUG
			printf("SystemLevels = 0\n");
#endif
		} else if ( !strcasecmp("SysTime", buffer) ) {
			state.system_time = 1;
#ifdef DEBUG
			printf("SystemTime = 1\n");
#endif
		} else if ( !strcasecmp("NoSysTime", buffer) ) {
			state.system_time = 0;
#ifdef DEBUG
			printf("SystemTime = 0\n");
#endif
		} else if ( !strcasecmp("ColorDepth", buffer) ) {
			fscanf(fd, "%d", &state.color_depth);
#ifdef DEBUG
			printf("Color depth = %d\n", state.color_depth);
#endif
		} else if ( !strcasecmp("Device", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( apm_device_file, Strip(buffer), 256 );
#ifdef DEBUG
			printf("APM device = %s\n", apm_device_file);
#endif
		} else if ( !strcasecmp("Status", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( statuscolor, Strip(buffer), 50 );
#ifdef DEBUG
			printf("Status = %s\n", statuscolor);
#endif
		} else if ( !strcasecmp("Green", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( greencolor, Strip(buffer), 50 );
#ifdef DEBUG
			printf("Green = %s\n", greencolor);
#endif
		} else if ( !strcasecmp("Yellow", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( yellowcolor, Strip(buffer), 50 );
#ifdef DEBUG
			printf("Yellow = %s\n", yellowcolor);
#endif
		} else if ( !strcasecmp("Red", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( redcolor, Strip(buffer), 50 );
#ifdef DEBUG
			printf("Red = %s\n", redcolor);
#endif
		} else if ( !strcasecmp("Lower", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( slidercolor, Strip(buffer), 50 );
#ifdef DEBUG
			printf("Lower = %s\n", slidercolor);
#endif
		} else if ( !strcasecmp("Upper", buffer) ) {
			fgets( buffer, 256, fd );
			safecopy( sliderbgcolor, Strip(buffer), 50 );
#ifdef DEBUG
			printf("Upper = %s\n", sliderbgcolor);
#endif
		} else if ( !strcasecmp("ACOn", buffer) ) {
			fgets( buffer, 256, fd );
			AddReaction( 0, Trim(buffer) );
		} else if ( !strcasecmp("ACOff", buffer) ) {
			fgets( buffer, 256, fd );
			AddReaction( 1, Trim(buffer) );
		} else if ( !strcasecmp("PowerDown", buffer) ) {
			fgets( buffer, 256, fd );
			AddReaction( 2, Trim(buffer) );
		} else if ( !strcasecmp("PowerUp", buffer) ) {
			fgets( buffer, 256, fd );
			AddReaction( 3, Trim(buffer) );
		} else if ( !strcasecmp("DownTo", buffer) ) {
			fscanf(fd, "%d", &tmp);
			fgets( buffer, 256, fd );
			AddReactionOnPercent( 1, tmp, Trim(buffer) );
		} else if ( !strcasecmp("UpTo", buffer) ) {
			fscanf(fd, "%d", &tmp);
			fgets( buffer, 256, fd );
			AddReactionOnPercent( 0, tmp, Trim(buffer) );
		} else {
			printf("asapm: ignored unknown option [%s]\n", buffer);
		}
	}
}

int ReadConfiguration(char * file_name)
{
	FILE * fd;

#ifdef DEBUG
	printf("Reading configuration file [%s]\n", file_name);
#endif
	fd = fopen(file_name, "r");
	if ( ! fd ) {
#ifdef DEBUG
		printf("Failed to open the rc file : %s [errno = %d].\n", 
			strerror(errno), errno);
#endif
		return -1;
	} else {
		ReadFile( fd );
		fclose( fd );
		return 0;
	}
}

