/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* history.c: history functions for the command line widget */

#include <stdio.h>
#include "support.h"
#include "history.h"
#include "types.h"

static GList *txhistory;
GList *recordhistory;
extern GList *connecthistory;
static guint txitem = 0, updown = 0;
extern GtkWidget *window1;
extern gchar *preferencesdir;

/* Recall history and copy into the appropriate GList */
 
void loadhistory(void)
{
  gchar *historyfile, history[1024], **histsplit = NULL;
  FILE *fp;

  historyfile = g_strconcat(preferencesdir, "/history", NULL);
  fp = fopen(historyfile,"r");
  if (fp == NULL) return;

  while(!feof(fp)) {
    if (fscanf(fp,"%s", history) == EOF) break;
    histsplit = g_strsplit(history, ":", 2);
    if (!g_strcasecmp(histsplit[0], "tx")) {
      if (histsplit[1]) {
      g_strdelimit(histsplit[1], "_", ' '); /* spaces were saved as underscores */
      txhistory = g_list_append(txhistory, g_strdup(histsplit[1]));
      txitem = g_list_length(txhistory);
      }
    } 
    else if (!g_strcasecmp(histsplit[0], "re")) {
      if (histsplit[1]) {
      g_strdelimit(histsplit[1], "_", ' ');
      recordhistory = g_list_append(recordhistory, g_strdup(histsplit[1]));
      }
    }
    else if (!g_strcasecmp(histsplit[0], "co")) {
      if (histsplit[1]) {
      g_strdelimit(histsplit[1], "_", ' ');
      connecthistory = g_list_append(connecthistory, g_strdup(histsplit[1]));
      }
    }
  }

  fclose(fp);
  g_strfreev(histsplit);
}

/* Save history to ~/.xcall/history for tx widget and recording */
 
void savehistory(void) {
  gchar *historyfile, *item;
  FILE *fp = NULL;
  guint i, n;

  historyfile = g_strconcat(preferencesdir, "/history", NULL);
  if ((g_list_length(txhistory) > 0) || (g_list_length(recordhistory) > 0))
    fp = fopen(historyfile, "w");

  if (fp == NULL) return;

  if ((n = g_list_length(txhistory)) > 0) {
    for(i=0; i<n; i++) {
      item = g_list_nth_data(txhistory, i);
      g_strdelimit(item, " ", '_'); /* convert spaces to underscores */
      fprintf(fp, "tx:%s\n", item);
    }
  }

  if ((n = g_list_length(recordhistory)) > 0) {
    for(i=0; i<n; i++) {
      item = g_list_nth_data(recordhistory, i);
      g_strdelimit(item, " ", '_'); /* convert spaces to underscores */
      fprintf(fp, "re:%s\n", item);
    }
  }

  if ((n = g_list_length(connecthistory)) > 0) {
    for(i=0; i<n; i++) {
      item = g_list_nth_data(connecthistory, i);
      g_strdelimit(item, " ", '_'); /* convert spaces to underscores */
      fprintf(fp, "co:%s\n", item);
    }
  }

  fclose(fp);
}


void tx_save(gchar *line) {

  txhistory = g_list_append(txhistory, g_strdup(line));

  if (g_list_length(txhistory) > HISTORY)
    txhistory = g_list_remove(txhistory, g_list_first(txhistory)->data);
  else txitem++; 

  updown = 0;
  return;
}

void tx_previous(void) {
  GtkWidget *mainentry;
  gchar *node;

  if (updown < txitem) updown++;
  
  if (txhistory) {
    node = g_list_nth_data(txhistory, txitem-updown);
    mainentry = lookup_widget (window1, "entry1");
    gtk_entry_set_text(GTK_ENTRY(mainentry), node);
  }
}


void tx_next(void) {
  GtkWidget *mainentry;
  gchar *node;

  mainentry = lookup_widget (window1, "entry1");
  if (updown > 0) updown--;

  if (updown == 0)
    gtk_entry_set_text(GTK_ENTRY(mainentry), "");
    else {
      node = g_list_nth_data(txhistory, txitem-updown);
      gtk_entry_set_text(GTK_ENTRY(mainentry), node);
    }
}