/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Mix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Balls
extends AnimatingControlsSurface {
    private static Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green.darker(), Color.blue, new Color(75, 0, 82), new Color(238, 130, 238)};
    private long now;
    private long deltaT;
    private long lasttime;
    private boolean active;
    protected Ball[] balls = new Ball[colors.length];
    protected boolean clearToggle;
    protected JComboBox combo;

    public Balls() {
        this.setBackground(Color.white);
        for (int i = 0; i < colors.length; ++i) {
            this.balls[i] = new Ball(colors[i], 30);
        }
        this.balls[0].isSelected = true;
        this.balls[3].isSelected = true;
        this.balls[4].isSelected = true;
        this.balls[6].isSelected = true;
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void reset(int n, int n2) {
        if (n > 400 && n2 > 100) {
            this.combo.setSelectedIndex(5);
        }
    }

    public void step(int n, int n2) {
        int n3;
        if (this.lasttime == 0L) {
            this.lasttime = System.currentTimeMillis();
        }
        this.now = System.currentTimeMillis();
        this.deltaT = this.now - this.lasttime;
        this.active = false;
        for (n3 = 0; n3 < this.balls.length; ++n3) {
            if (this.balls[n3] == null) {
                return;
            }
            this.balls[n3].step(this.deltaT, n, n2);
            if (!((double)this.balls[n3].Vy > 0.02) && !((double)(-this.balls[n3].Vy) > 0.02) && !(this.balls[n3].y + (float)this.balls[n3].bsize < (float)n2)) continue;
            this.active = true;
        }
        if (!this.active) {
            for (n3 = 0; n3 < this.balls.length; ++n3) {
                this.balls[n3].Vx = (float)Math.random() / 4.0f - 0.125f;
                this.balls[n3].Vy = -((float)Math.random()) / 4.0f - 0.2f;
            }
            this.clearToggle = true;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        for (int i = 0; i < this.balls.length; ++i) {
            Ball ball = this.balls[i];
            if (ball == null || ball.imgs[ball.index] == null || !ball.isSelected) continue;
            graphics2D.drawImage((Image)ball.imgs[ball.index], (int)ball.x, (int)ball.y, this);
        }
        this.lasttime = this.now;
    }

    public static void main(String[] stringArray) {
        Balls.createDemoFrame(new Balls());
    }

    class DemoControls
    extends CustomControls
    implements ActionListener {
        Balls demo;
        JToolBar toolbar;

        public DemoControls(Balls balls2) {
            super(balls2.name);
            this.demo = balls2;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Clear", true);
            this.addTool("R", balls2.balls[0].isSelected);
            this.addTool("O", balls2.balls[1].isSelected);
            this.addTool("Y", balls2.balls[2].isSelected);
            this.addTool("G", balls2.balls[3].isSelected);
            this.addTool("B", balls2.balls[4].isSelected);
            this.addTool("I", balls2.balls[5].isSelected);
            this.addTool("V", balls2.balls[6].isSelected);
            Balls.this.combo = new JComboBox();
            this.add(Balls.this.combo);
            Balls.this.combo.addItem("10");
            Balls.this.combo.addItem("20");
            Balls.this.combo.addItem("30");
            Balls.this.combo.addItem("40");
            Balls.this.combo.addItem("50");
            Balls.this.combo.addItem("60");
            Balls.this.combo.addItem("70");
            Balls.this.combo.addItem("80");
            Balls.this.combo.setSelectedIndex(2);
            Balls.this.combo.addActionListener(this);
        }

        public void addTool(String string, boolean bl) {
            JToggleButton jToggleButton = (JToggleButton)this.toolbar.add(new JToggleButton(string));
            jToggleButton.setFocusPainted(false);
            jToggleButton.setSelected(bl);
            jToggleButton.addActionListener(this);
            int n = jToggleButton.getPreferredSize().width;
            Dimension dimension = new Dimension(n, 21);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMaximumSize(dimension);
            jToggleButton.setMinimumSize(dimension);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JComboBox) {
                int n = Integer.parseInt((String)Balls.this.combo.getSelectedItem());
                for (int i = 0; i < this.demo.balls.length; ++i) {
                    this.demo.balls[i].makeImages(n);
                }
                return;
            }
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.getText().equals("Clear")) {
                this.demo.clearSurface = jToggleButton.isSelected();
            } else {
                int n = this.toolbar.getComponentIndex(jToggleButton) - 1;
                this.demo.balls[n].isSelected = jToggleButton.isSelected();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        public void run() {
            try {
                Thread.sleep(999L);
            }
            catch (Exception exception) {
                return;
            }
            Thread thread = Thread.currentThread();
            ((AbstractButton)this.toolbar.getComponentAtIndex(2)).doClick();
            while (this.thread == thread) {
                try {
                    Thread.sleep(222L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (!this.demo.clearToggle) continue;
                if (this.demo.clearSurface) {
                    Balls.this.combo.setSelectedIndex((int)(Math.random() * 5.0));
                }
                ((AbstractButton)this.toolbar.getComponentAtIndex(0)).doClick();
                this.demo.clearToggle = false;
            }
            this.thread = null;
        }
    }

    static class Ball {
        public int bsize;
        public float x;
        public float y;
        public float Vx = 0.1f;
        public float Vy = 0.05f;
        public int nImgs = 5;
        public BufferedImage[] imgs;
        public int index = (int)(Math.random() * (double)(this.nImgs - 1));
        private final float inelasticity = 0.96f;
        private final float Ax = 0.0f;
        private final float Ay = 2.0E-4f;
        private final float Ar = 0.9f;
        private final int UP = 0;
        private final int DOWN = 1;
        private int indexDirection = 0;
        private boolean collision_x;
        private boolean collision_y;
        private float jitter;
        private Color color;
        private boolean isSelected;

        public Ball(Color color, int n) {
            this.color = color;
            this.makeImages(n);
        }

        public void makeImages(int n) {
            int n2;
            this.bsize = n * 2;
            int n3 = n;
            byte[] byArray = new byte[n3 * 2 * n3 * 2];
            int n4 = 0;
            int n5 = 2 * n3;
            while (--n5 >= 0) {
                int n6 = (int)(Math.sqrt(n3 * n3 - (n5 - n3) * (n5 - n3)) + 0.5);
                int n7 = n5 * (n3 * 2) + n3 - n6;
                for (int i = -n6; i < n6; ++i) {
                    n2 = i + 15;
                    int n8 = n5 - n3 + 15;
                    int n9 = (int)(Math.sqrt(n2 * n2 + n8 * n8) + 0.5);
                    if (n9 > n4) {
                        n4 = n9;
                    }
                    byArray[n7++] = n9 <= 0 ? (byte)1 : (byte)n9;
                }
            }
            this.imgs = new BufferedImage[this.nImgs];
            n5 = 255;
            byte[] byArray2 = new byte[256];
            byArray2[0] = (byte)n5;
            byte[] byArray3 = new byte[256];
            byArray3[0] = (byte)n5;
            byte[] byArray4 = new byte[256];
            byArray4[0] = (byte)n5;
            for (n2 = 0; n2 < this.imgs.length; ++n2) {
                float f = 0.5f + ((float)n2 + 1.0f) / (float)this.imgs.length / 2.0f;
                for (int i = n4; i >= 1; --i) {
                    float f2 = (float)i / (float)n4;
                    byArray2[i] = (byte)this.blend(this.blend(this.color.getRed(), 255, f2), n5, f);
                    byArray3[i] = (byte)this.blend(this.blend(this.color.getGreen(), 255, f2), n5, f);
                    byArray4[i] = (byte)this.blend(this.blend(this.color.getBlue(), 255, f2), n5, f);
                }
                IndexColorModel indexColorModel = new IndexColorModel(8, n4 + 1, byArray2, byArray3, byArray4, 0);
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                int[] nArray = new int[]{0};
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3 * 2, n3 * 2, n3 * 2, 1, nArray, null);
                this.imgs[n2] = new BufferedImage(indexColorModel, writableRaster, indexColorModel.isAlphaPremultiplied(), null);
            }
        }

        private final int blend(int n, int n2, float f) {
            return (int)((float)n2 + (float)(n - n2) * f);
        }

        public void step(long l, int n, int n2) {
            this.collision_x = false;
            this.collision_y = false;
            this.jitter = (float)Math.random() * 0.01f - 0.005f;
            this.x = (float)((double)this.x + ((double)(this.Vx * (float)l) + 0.0 * (double)l * (double)l));
            this.y = (float)((double)this.y + ((double)(this.Vy * (float)l) + (double)1.0E-4f * (double)l * (double)l));
            if (this.x <= 0.0f) {
                this.x = 0.0f;
                this.Vx = -this.Vx * 0.96f + this.jitter;
                this.collision_x = true;
            }
            if (this.x + (float)this.bsize >= (float)n) {
                this.x = n - this.bsize;
                this.Vx = -this.Vx * 0.96f + this.jitter;
                this.collision_x = true;
            }
            if (this.y <= 0.0f) {
                this.y = 0.0f;
                this.Vy = -this.Vy * 0.96f + this.jitter;
                this.collision_y = true;
            }
            if (this.y + (float)this.bsize >= (float)n2) {
                this.y = n2 - this.bsize;
                this.Vx *= 0.96f;
                this.Vy = -this.Vy * 0.96f + this.jitter;
                this.collision_y = true;
            }
            this.Vy += 2.0E-4f * (float)l;
            this.Vx += 0.0f * (float)l;
            if (this.indexDirection == 0) {
                ++this.index;
            }
            if (this.indexDirection == 1) {
                --this.index;
            }
            if (this.index + 1 == this.nImgs) {
                this.indexDirection = 1;
            }
            if (this.index == 0) {
                this.indexDirection = 0;
            }
        }
    }
}

