/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextField;

public class XTextFieldEditor
extends XTextField
implements TableCellEditor {
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() instanceof JMenuItem || actionEvent.getSource() instanceof JTextField) {
            this.fireEditingStopped();
        }
    }

    protected void dropSuccess() {
        this.fireEditingStopped();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingCanceled(this.changeEvent);
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public boolean stopCellEditing() {
        this.cancelCellEditing();
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public Object getCellEditorValue() {
        Object object = this.getValue();
        if (object instanceof XObject) {
            return ((XObject)object).getObject();
        }
        return object;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        XTable xTable = (XTable)jTable;
        String string = xTable.getClassName(n);
        try {
            this.init(object, Utils.getClass(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

