/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.inspector.XMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMBeanTree
extends JTree
implements TreeSelectionListener,
TreeExpansionListener {
    public static final String SELECTION_CHANGED_EVENT = "jam.xmbean.selection.changed";
    public static final String VALUE_UPDATE_EVENT = "jam.xmbean.value.update";
    private List<NotificationListener> notificationListenersList;
    private boolean expanded;
    protected HashMap<Object, String> expandedPaths;
    private TreePath markedPath = null;

    public XMBeanTree(TreeNode treeNode) {
        super(treeNode);
        this.setRootVisible(true);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.expandedPaths = new HashMap();
        ArrayList arrayList = new ArrayList(1);
        this.notificationListenersList = Collections.synchronizedList(arrayList);
    }

    public String getTitle() {
        return ((DefaultMutableTreeNode)this.getModel().getRoot()).getUserObject().toString();
    }

    public void setTitle(String string) {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).setUserObject(string);
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public synchronized void expandAllNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
            this.expandPath(treePath);
        }
        this.expanded = true;
        this.unselectNode(this.getRoot());
    }

    public synchronized void changeNodeValue(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        defaultMutableTreeNode.setUserObject(object);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.nodeChanged(defaultMutableTreeNode);
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.expandNodePath(treePath);
    }

    public synchronized void removeChildNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    public synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
        boolean bl = false;
        if (this.getRoot().isLeaf()) {
            bl = true;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        if (bl) {
            defaultTreeModel.nodeStructureChanged(this.getRoot());
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.expandNodePath(treePath);
    }

    public synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
    }

    public void addMBeanToView(MBeansTab mBeansTab, ObjectName objectName) throws InstanceNotFoundException {
        XMBean xMBean = new XMBean(objectName, mBeansTab);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(xMBean);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.getRoot(), this.getRoot().getChildCount());
        defaultTreeModel.nodeStructureChanged(this.getRoot());
    }

    public void delMBeanFromView(ObjectName objectName) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        List<DefaultMutableTreeNode> list = this.getAllNodes();
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            XMBean xMBean;
            if (!(defaultMutableTreeNode.getUserObject() instanceof XMBean) || !(xMBean = (XMBean)defaultMutableTreeNode.getUserObject()).getObjectName().equals(objectName)) continue;
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode.getParent());
        }
    }

    public List<XMBean> getSelectedXMBeans() {
        ArrayList<XMBean> arrayList = new ArrayList<XMBean>(5);
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return arrayList;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(treePath);
            if (defaultMutableTreeNode.getUserObject() instanceof XMBean) {
                arrayList.add((XMBean)defaultMutableTreeNode.getUserObject());
                continue;
            }
            if (this.getSelectionModel().getSelectionMode() == 1 || this.isExpanded(treePath)) continue;
            List<XMBean> list = this.getAllXMBeans(defaultMutableTreeNode);
            for (XMBean xMBean : list) {
                arrayList.add(xMBean);
            }
        }
        return arrayList;
    }

    public List<XMBean> getSelectedXMBeans(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        ArrayList<XMBean> arrayList = new ArrayList<XMBean>(5);
        for (TreePath treePath : treePathArray) {
            if (!treeSelectionEvent.isAddedPath(treePath)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(treePath);
            if (defaultMutableTreeNode.getUserObject() instanceof XMBean) {
                arrayList.add((XMBean)defaultMutableTreeNode.getUserObject());
                continue;
            }
            if (this.getSelectionModel().getSelectionMode() != 1 && this.isExpanded(treePath)) continue;
        }
        return arrayList;
    }

    public List<TreePath> getSelectedXMBeanPaths() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(5);
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return arrayList;
        }
        for (TreePath treePath : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(treePath);
            if (defaultMutableTreeNode.getUserObject() instanceof XMBean) {
                arrayList.add(treePath);
                continue;
            }
            if (this.getSelectionModel().getSelectionMode() != 1 && this.isExpanded(treePath)) continue;
        }
        return arrayList;
    }

    public List<TreePath> getSelectedXMBeanPaths(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(5);
        for (TreePath treePath : treePathArray) {
            if (!treeSelectionEvent.isAddedPath(treePath)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(treePath);
            if (defaultMutableTreeNode.getUserObject() instanceof XMBean) {
                arrayList.add(treePath);
                continue;
            }
            if (this.getSelectionModel().getSelectionMode() != 1 && this.isExpanded(treePath)) continue;
        }
        return arrayList;
    }

    public void selectXMBean(XMBean xMBean) {
        List<DefaultMutableTreeNode> list = this.getAllNodes(this.getRoot());
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            XMBean xMBean2 = (XMBean)defaultMutableTreeNode.getUserObject();
            if (!xMBean.equals(xMBean2)) continue;
            this.selectNode(defaultMutableTreeNode);
        }
    }

    public void unSelectXMBean(XMBean xMBean) {
        List<DefaultMutableTreeNode> list = this.getAllNodes(this.getRoot());
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            XMBean xMBean2 = (XMBean)defaultMutableTreeNode.getUserObject();
            if (!xMBean.equals(xMBean2)) continue;
            this.unselectNode(defaultMutableTreeNode);
        }
    }

    public void unSelectMBean(ObjectName objectName) {
        List<DefaultMutableTreeNode> list = this.getAllNodes(this.getRoot());
        Iterator<DefaultMutableTreeNode> iterator = list.iterator();
        if (iterator.hasNext()) {
            DefaultMutableTreeNode defaultMutableTreeNode = iterator.next();
            ObjectName objectName2 = ((XMBean)defaultMutableTreeNode.getUserObject()).getObjectName();
            if (objectName.equals(objectName2)) {
                this.unselectNode(defaultMutableTreeNode);
            }
            return;
        }
    }

    public DefaultMutableTreeNode getNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addSelectionPath(this.getTreePath(defaultMutableTreeNode));
    }

    public void unselectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.removeSelectionPath(this.getTreePath(defaultMutableTreeNode));
    }

    public void markNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.markedPath = new TreePath(defaultMutableTreeNode.getPath());
        ((DefaultTreeModel)this.getModel()).nodeChanged(defaultMutableTreeNode);
    }

    public void unmarkNodes() {
        if (this.markedPath != null) {
            TreeNode treeNode = (TreeNode)this.markedPath.getLastPathComponent();
            ((DefaultTreeModel)this.getModel()).nodeChanged(treeNode);
            this.markedPath = null;
        }
    }

    public boolean isMarkedRow(int n) {
        return n == this.getRowForPath(this.markedPath);
    }

    public List<DefaultMutableTreeNode> getAllNodes() {
        return this.getAllNodes(this.getRoot());
    }

    public List<DefaultMutableTreeNode> getAllNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(defaultMutableTreeNode.getChildCount());
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            arrayList.add(defaultMutableTreeNode);
        }
        return arrayList;
    }

    public List<XMBean> getAllXMBeans() {
        return this.getAllXMBeans(this.getRoot());
    }

    public List<XMBean> getAllXMBeans(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<XMBean> arrayList = new ArrayList<XMBean>(defaultMutableTreeNode.getChildCount());
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof XMBean)) continue;
            arrayList.add((XMBean)defaultMutableTreeNode.getUserObject());
        }
        return arrayList;
    }

    public List<DefaultMutableTreeNode> getAllXMBeanNodes() {
        return this.getAllXMBeanNodes(this.getRoot());
    }

    public List<DefaultMutableTreeNode> getAllXMBeanNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(defaultMutableTreeNode.getChildCount());
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof XMBean)) continue;
            arrayList.add(defaultMutableTreeNode);
        }
        return arrayList;
    }

    @Override
    public void removeAll() {
        this.getRoot().removeAllChildren();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.nodeStructureChanged(this.getRoot());
    }

    public TreePath getTreePath(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new TreePath(defaultMutableTreeNode.getPath());
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getRowCount());
    }

    public void unSelectAll() {
        if (this.getSelectedCount() > 0) {
            super.clearSelection();
        }
    }

    public void invertSelection() {
    }

    public List getSelected() {
        return this.getSelectedXMBeans();
    }

    public int getSelectedCount() {
        return this.getSelected().size();
    }

    public boolean isMultiSelect() {
        return this.getSelectedCount() > 1;
    }

    public void setNodeVisible(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public DefaultMutableTreeNode getXMBean(ObjectName objectName) {
        List<DefaultMutableTreeNode> list = this.getAllXMBeanNodes();
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            ObjectName objectName2 = ((XMBean)defaultMutableTreeNode.getUserObject()).getObjectName();
            if (!objectName.equals(objectName2)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public void addXMBeanListener(NotificationListener notificationListener) {
        this.notificationListenersList.add(notificationListener);
    }

    public void removeXMBeanListener(NotificationListener notificationListener) {
        this.notificationListenersList.remove(notificationListener);
    }

    public void fireChangedNotification(String string, Object object) {
        Notification notification = new Notification(string, this, 0L);
        for (NotificationListener notificationListener : this.notificationListenersList) {
            notificationListener.handleNotification(notification, object);
        }
    }

    public void notifyXMBeanValueUpdate(ObjectName objectName, XMBean xMBean) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getXMBean(objectName);
        if (defaultMutableTreeNode != null) {
            ((DefaultTreeModel)this.getModel()).nodeChanged(defaultMutableTreeNode);
            this.fireChangedNotification(VALUE_UPDATE_EVENT, xMBean);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.unmarkNodes();
        List<TreePath> list = this.getSelectedXMBeanPaths(treeSelectionEvent);
        this.fireChangedNotification(SELECTION_CHANGED_EVENT, list);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        this.deleteExpandedPath(treePath);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        this.saveExpandedPath(treePath);
    }

    private void deleteExpandedPath(TreePath treePath) {
        Object object = this.getExpandedPathKey(treePath);
        this.expandedPaths.remove(object);
    }

    private void saveExpandedPath(TreePath treePath) {
        Object object = this.getExpandedPathKey(treePath);
        this.expandedPaths.put(object, "");
    }

    private boolean isExpandedPath(TreePath treePath) {
        Object object = this.getExpandedPathKey(treePath);
        return this.expandedPaths.containsKey(object);
    }

    protected Object getExpandedPathKey(TreePath treePath) {
        return treePath.toString();
    }

    protected void expandNodePath(TreePath treePath) {
        if (this.isExpandedPath(treePath)) {
            TreePath treePath2 = treePath;
            boolean bl = true;
            while (bl && treePath2.getPathCount() > 2) {
                if (this.isExpandedPath(treePath2 = treePath2.getParentPath())) continue;
                bl = false;
            }
            if (bl) {
                this.expandPath(treePath);
            }
        }
    }
}

