/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedJarFile;
import sun.plugin.cache.DownloadException;
import sun.plugin.cache.FileVersion;
import sun.plugin.cache.JarCache;
import sun.plugin.net.protocol.http.HttpUtils;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.Trace;

public class CachedJarLoader {
    private static final String ACCEPT_ENCODING = "accept-encoding";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final String CONTENT_TYPE = "content-type";
    private static final String PACK200_GZIP_ENCODING = "pack200-gzip";
    private static final String GZIP_ENCODING = "gzip";
    private static final String JAR_MIME_TYPE = "application/x-java-archive";
    private static final int BUFFER_SIZE = 8192;
    private URL url;
    private HttpURLConnection uc = null;
    private long lastModified = 0L;
    private long expiration = 0L;
    private boolean httpCompression = true;
    private boolean upToDate = false;
    private boolean upToDateChecked = false;
    private File dataFile = null;
    private File indexFile = null;
    private boolean cached = false;
    private long size = 0L;
    private FileVersion version = new FileVersion();

    public CachedJarLoader(URL uRL, boolean bl) throws IOException {
        this.url = uRL;
        this.cached = this.getCacheFile();
        if (bl) {
            if (this.cached) {
                this.upToDate = this.isUpToDate();
                this.upToDateChecked = true;
            } else {
                this.size = Cache.getFileSizeFromServer(uRL);
            }
        }
    }

    public long getJarSize() {
        return this.size;
    }

    public URL getURL() {
        return this.url;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public void setIndexFile(File file) {
        this.indexFile = file;
    }

    public void setLastModify(long l) {
        this.lastModified = l;
    }

    public void setExpiration(long l) {
        this.expiration = l;
    }

    public void setVersion(FileVersion fileVersion) {
        this.version = fileVersion;
    }

    public CachedJarFile load() throws IOException {
        CachedJarFile cachedJarFile = this.loadFromCache();
        if (cachedJarFile == null) {
            try {
                Trace.msgPrintln("httpCompression = " + this.httpCompression);
                cachedJarFile = this.download();
            }
            catch (IOException iOException) {
                int n;
                if (this.uc != null && ((n = this.uc.getResponseCode()) < 200 || n >= 300)) {
                    throw new DownloadException(iOException, this.uc);
                }
                if (this.httpCompression) {
                    this.httpCompression = false;
                    HttpUtils.cleanupConnection(this.uc);
                    this.uc = null;
                    cachedJarFile = this.download();
                }
                throw iOException;
            }
            if (cachedJarFile != null && Cache.cleanupThread != null) {
                try {
                    AccessController.doPrivileged(new Cache.CacheIOAction(){

                        public Object run() throws IOException {
                            Cache.cleanupThread.addedJar(CachedJarLoader.this.dataFile.length() + CachedJarLoader.this.indexFile.length());
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new IOException(privilegedActionException.getMessage());
                }
            }
        }
        return cachedJarFile;
    }

    private CachedJarFile loadFromCache() {
        CachedJarFile cachedJarFile;
        block9: {
            cachedJarFile = null;
            try {
                if (!this.cached) break block9;
                if (!this.upToDateChecked) {
                    this.upToDate = this.isUpToDate();
                }
                if (this.upToDate) {
                    Cache.msgPrintln("cache.loading", new Object[]{this.url});
                    boolean bl = ProgressMonitor.getDefault().shouldMeterInput(this.url, "GET");
                    if (bl) {
                        ProgressSource progressSource = new ProgressSource(this.url, "GET", 10000);
                        progressSource.beginTracking();
                        progressSource.updateProgress(10000, 10000);
                        progressSource.finishTracking();
                        progressSource.close();
                    }
                    try {
                        cachedJarFile = (CachedJarFile)AccessController.doPrivileged(new Cache.CacheIOAction(){

                            public Object run() throws IOException {
                                CachedJarLoader.this.indexFile.setLastModified(System.currentTimeMillis());
                                return CachedJarLoader.this.authenticateFromCache();
                            }
                        });
                        break block9;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new IOException(privilegedActionException.getMessage());
                    }
                }
                try {
                    AccessController.doPrivileged(new Cache.CacheIOAction(){

                        public Object run() throws IOException {
                            Cache.removeFromTable(CachedJarLoader.this.indexFile, JarCache.filesInCache);
                            if (!CachedJarLoader.this.dataFile.delete()) {
                                CachedJarLoader.this.dataFile.deleteOnExit();
                            }
                            if (!CachedJarLoader.this.indexFile.delete()) {
                                FileOutputStream fileOutputStream = new FileOutputStream(CachedJarLoader.this.indexFile);
                                fileOutputStream.write(1);
                                fileOutputStream.close();
                                CachedJarLoader.this.indexFile.deleteOnExit();
                            }
                            CachedJarLoader.this.dataFile = null;
                            CachedJarLoader.this.indexFile = null;
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new IOException(privilegedActionException.getMessage());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Cache.msgPrintln("cache.load_warning", new Object[]{this.url});
            }
        }
        return cachedJarFile;
    }

    private boolean getCacheFile() throws IOException {
        final CachedJarLoader cachedJarLoader = this;
        try {
            return (Boolean)AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    boolean bl = false;
                    bl = JarCache.getMatchingFile(cachedJarLoader);
                    return bl;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
    }

    public boolean isVersionUpToDate(FileVersion fileVersion) {
        boolean bl = false;
        this.upToDate = bl = this.version.isUpToDate(fileVersion);
        this.upToDateChecked = true;
        return bl;
    }

    private boolean isUpToDate() throws IOException {
        boolean bl = false;
        if (this.expiration != 0L && new Date().before(new Date(this.expiration))) {
            bl = true;
        }
        if (!bl && this.lastModified != 0L) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc.setIfModifiedSince(this.lastModified);
            if (this.httpCompression) {
                this.uc.setRequestProperty(ACCEPT_ENCODING, "pack200-gzip,gzip");
                this.uc.setRequestProperty(CONTENT_TYPE, JAR_MIME_TYPE);
            }
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 304) {
                bl = true;
            } else if (n >= 200 && n <= 299) {
                long l = this.lastModified;
                long l2 = this.expiration;
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == l) {
                    HttpUtils.cleanupConnection(this.uc);
                    bl = true;
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(l));
                    String string2 = dateFormat.format(new Date(this.lastModified));
                    Cache.msgPrintln("cache.out_of_date", new Object[]{this.url, string, string2});
                    this.size = this.uc.getContentLength();
                }
            } else {
                Cache.msgPrintln("cache.response_warning", new Object[]{String.valueOf(n), this.url});
            }
        }
        return bl;
    }

    private CachedJarFile download() throws IOException {
        if (this.uc == null) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            if (this.httpCompression) {
                this.uc.setRequestProperty(ACCEPT_ENCODING, "pack200-gzip,gzip");
                this.uc.setRequestProperty(CONTENT_TYPE, JAR_MIME_TYPE);
            }
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n < 200 || n >= 300) {
                HttpUtils.cleanupConnection(this.uc);
                throw new IOException("Could not connect to " + this.url + " with response code " + n);
            }
            this.lastModified = this.uc.getLastModified();
            this.expiration = this.uc.getExpiration();
        }
        if (this.lastModified == 0L && this.expiration == 0L) {
            Trace.msgPrintln("cache.header_fields_missing");
            return null;
        }
        Cache.msgPrintln("cache.downloading", new Object[]{this.url});
        try {
            return (CachedJarFile)AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    String string = JarCache.generateCacheFileName(CachedJarLoader.this.url);
                    CachedJarLoader.this.dataFile = new File(JarCache.directory, string + ".zip");
                    CachedJarLoader.this.indexFile = new File(JarCache.directory, string + ".idx");
                    CachedJarLoader.this.markAsIncomplete();
                    CachedJarLoader.this.decompress();
                    CachedJarFile cachedJarFile = CachedJarLoader.this.authenticate();
                    Cache.msgPrintln("cache.cached_name", new Object[]{CachedJarLoader.this.dataFile.getName()});
                    return cachedJarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress() throws IOException {
        boolean bl = false;
        ZipInputStream zipInputStream = null;
        ZipInputStream zipInputStream2 = null;
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile)));
            jarOutputStream.setLevel(JarCache.compression);
            String string = this.uc.getContentEncoding();
            Trace.msgPrintln("encoding = " + string + " for " + this.url);
            if (string != null && string.compareTo(PACK200_GZIP_ENCODING) == 0) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(this.uc.getInputStream()));
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.unpack((InputStream)gZIPInputStream, jarOutputStream);
                bl = true;
            } else if (string != null && string.indexOf(GZIP_ENCODING) >= 0) {
                zipInputStream2 = new ZipInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(this.uc.getInputStream()), 8192));
                this.decompressWrite(zipInputStream2, jarOutputStream);
                bl = true;
            } else {
                ZipEntry zipEntry;
                this.httpCompression = false;
                zipInputStream2 = new ZipInputStream(new BufferedInputStream(this.uc.getInputStream()));
                if (this.url.toString().toLowerCase().endsWith(".jarjar")) {
                    zipEntry = zipInputStream2.getNextEntry();
                    while (zipEntry != null) {
                        if (zipEntry.toString().toLowerCase().startsWith("meta-inf/")) {
                            zipEntry = zipInputStream2.getNextEntry();
                            continue;
                        }
                        if (zipEntry.toString().toLowerCase().endsWith(".jar")) break;
                        throw new IOException(ResourceHandler.getMessage("cache.jarjar.invalid_file"));
                    }
                    zipInputStream = zipInputStream2;
                    zipInputStream2 = new ZipInputStream(zipInputStream2);
                }
                this.decompressWrite(zipInputStream2, jarOutputStream);
                if (zipInputStream != null && (zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string2 = null;
                    string2 = !zipEntry.toString().toLowerCase().endsWith(".jar") ? ResourceHandler.getMessage("cache.jarjar.invalid_file") : ResourceHandler.getMessage("cache.jarjar.multiple_jar");
                    throw new IOException(string2);
                }
                bl = true;
            }
        }
        finally {
            if (this.uc != null) {
                HttpUtils.cleanupConnection(this.uc);
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (zipInputStream2 != null) {
                zipInputStream2.close();
            }
            if (jarOutputStream != null) {
                jarOutputStream.close();
            }
            if (!bl) {
                this.dataFile.delete();
                this.indexFile.delete();
            }
        }
    }

    private void decompressWrite(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[8192];
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            ZipEntry zipEntry2 = (ZipEntry)zipEntry.clone();
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            int n = 0;
            while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsIncomplete() throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            randomAccessFile.writeByte(0);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedJarFile authenticate() throws IOException {
        CodeSigner[] codeSignerArray;
        boolean bl = false;
        JarFile jarFile = new JarFile(this.dataFile);
        ObjectOutputStream objectOutputStream = null;
        RandomAccessFile randomAccessFile = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, int[]> hashMap2 = new HashMap<Object, int[]>();
        Manifest manifest = null;
        try {
            randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            randomAccessFile.writeByte(0);
            randomAccessFile.writeUTF(this.url.toString());
            randomAccessFile.writeLong(this.lastModified);
            randomAccessFile.writeLong(this.expiration);
            randomAccessFile.writeInt(1);
            randomAccessFile.writeUTF(this.version.getVersionAsString());
            codeSignerArray = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream((OutputStream)codeSignerArray);
            manifest = jarFile.getManifest();
            if (manifest != null) {
                Object object;
                Object object2;
                Closeable closeable;
                Object object3;
                Object object4;
                byte[] byArray = new byte[2048];
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n;
                    object4 = enumeration.nextElement();
                    object3 = ((ZipEntry)object4).getName();
                    if (((String)object3).toLowerCase().startsWith("meta-inf/") && !((String)object3).equals("META-INF/INDEX.LIST")) continue;
                    closeable = null;
                    try {
                        closeable = jarFile.getInputStream((ZipEntry)object4);
                        while (((InputStream)closeable).read(byArray, 0, byArray.length) != -1) {
                        }
                    }
                    finally {
                        if (closeable != null) {
                            ((InputStream)closeable).close();
                        }
                    }
                    object2 = ((JarEntry)object4).getCertificates();
                    if (object2 != null && ((Certificate[])object2).length > 0) {
                        object = new int[((Certificate[])object2).length];
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            n = arrayList.indexOf(object2[i]);
                            if (n == -1) {
                                n = arrayList.size();
                                arrayList.add(object2[i]);
                            }
                            object[i] = n;
                        }
                        hashMap.put(object3, object);
                    }
                    if ((object = ((JarEntry)object4).getCodeSigners()) != null && ((CodeSigner[])object).length > 0) {
                        int[] nArray = new int[((CodeSigner[])object).length];
                        for (n = 0; n < ((CodeSigner[])object).length; ++n) {
                            int n2 = arrayList2.indexOf(object[n]);
                            if (n2 == -1) {
                                n2 = arrayList2.size();
                                arrayList2.add(object[n]);
                            }
                            nArray[n] = n2;
                        }
                        hashMap2.put(object3, nArray);
                    }
                    this.removeSignature(manifest, (String)object3);
                }
                object4 = new ByteArrayOutputStream();
                manifest.write((OutputStream)object4);
                ((ByteArrayOutputStream)object4).close();
                object3 = ((ByteArrayOutputStream)object4).toByteArray();
                objectOutputStream.writeInt(((Object)object3).length);
                objectOutputStream.write((byte[])object3);
                closeable = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
                if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
                    Object object5;
                    objectOutputStream.writeInt(arrayList.size());
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        objectOutputStream.writeObject(object2.next());
                    }
                    object = hashMap.keySet().iterator();
                    String string = null;
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        int[] nArray = (int[])hashMap.get(string2);
                        if (string2.indexOf("/") != -1) {
                            object5 = string2.substring(0, string2.lastIndexOf("/"));
                            if (string != null && ((String)object5).equals(string)) {
                                string2 = string2.substring(((String)object5).length());
                            }
                            string = object5;
                        }
                        ((Writer)closeable).write(string2);
                        ((BufferedWriter)closeable).newLine();
                        object5 = String.valueOf(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            object5 = (String)object5 + " " + nArray[i];
                        }
                        ((BufferedWriter)closeable).write((String)object5, 0, ((String)object5).length());
                        ((BufferedWriter)closeable).newLine();
                    }
                    ((BufferedWriter)closeable).newLine();
                    Integer n = new Integer(arrayList2.size());
                    ((Writer)closeable).write(n.toString());
                    ((BufferedWriter)closeable).newLine();
                    ((BufferedWriter)closeable).flush();
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        objectOutputStream.writeObject(iterator.next());
                    }
                    object5 = hashMap2.keySet().iterator();
                    String string3 = null;
                    while (object5.hasNext()) {
                        String string4;
                        String string5 = (String)object5.next();
                        int[] nArray = (int[])hashMap2.get(string5);
                        if (string5.indexOf("/") != -1) {
                            string4 = string5.substring(0, string5.lastIndexOf("/"));
                            if (string3 != null && string4.equals(string3)) {
                                string5 = string5.substring(string4.length());
                            }
                            string3 = string4;
                        }
                        ((Writer)closeable).write(string5);
                        ((BufferedWriter)closeable).newLine();
                        string4 = String.valueOf(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            string4 = string4 + " " + nArray[i];
                        }
                        ((BufferedWriter)closeable).write(string4, 0, string4.length());
                        ((BufferedWriter)closeable).newLine();
                    }
                    ((BufferedWriter)closeable).flush();
                } else {
                    objectOutputStream.writeInt(0);
                }
            } else {
                objectOutputStream.writeInt(0);
            }
            objectOutputStream.flush();
            randomAccessFile.write(codeSignerArray.toByteArray());
            randomAccessFile.seek(0L);
            randomAccessFile.writeByte(16);
            bl = true;
        }
        finally {
            jarFile.close();
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (!bl) {
                this.dataFile.delete();
                this.indexFile.delete();
            }
        }
        codeSignerArray = new CodeSigner[arrayList2.size()];
        codeSignerArray = arrayList2.toArray(codeSignerArray);
        return new CachedJarFile(this.dataFile, codeSignerArray, hashMap2, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedJarFile authenticateFromCache() throws IOException {
        Manifest manifest;
        CodeSigner[] codeSignerArray;
        HashMap<Object, Object> hashMap;
        block30: {
            HashMap<String, int[]> hashMap2 = new HashMap<String, int[]>();
            hashMap = new HashMap<Object, Object>();
            Certificate[] certificateArray = null;
            codeSignerArray = null;
            manifest = null;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "r");
            ObjectInputStream objectInputStream = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                randomAccessFile.readByte();
                randomAccessFile.readUTF();
                randomAccessFile.readLong();
                randomAccessFile.readLong();
                randomAccessFile.readInt();
                randomAccessFile.readUTF();
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(randomAccessFile.getFD())));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(objectInputStream));
                int n = objectInputStream.readInt();
                if (n <= 0) break block30;
                byte[] byArray = new byte[n];
                objectInputStream.readFully(byArray, 0, n);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                manifest = new Manifest();
                manifest.read(byteArrayInputStream);
                int n2 = objectInputStream.readInt();
                if (n2 > 0) {
                    int n3;
                    Object object;
                    int n4;
                    Object object2;
                    String string;
                    certificateArray = new Certificate[n2];
                    try {
                        for (int i = 0; i < n2; ++i) {
                            certificateArray[i] = (Certificate)objectInputStream.readObject();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading signer certificates");
                    }
                    String string2 = bufferedReader.readLine();
                    String string3 = null;
                    while (string2 != null && !string2.equals("")) {
                        string = string2;
                        if (string.startsWith("/")) {
                            string = string3 + string;
                        } else {
                            int n5 = string.lastIndexOf("/");
                            if (n5 != -1) {
                                string3 = string.substring(0, n5);
                            }
                        }
                        string2 = bufferedReader.readLine();
                        object2 = new StringTokenizer(string2, " ", false);
                        n4 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        object = new int[n4];
                        for (n3 = 0; n3 < n4; ++n3) {
                            object[n3] = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        }
                        arrayList.add(string);
                        hashMap2.put(string, (int[])object);
                        string2 = bufferedReader.readLine();
                    }
                    string = bufferedReader.readLine();
                    if (string == null) {
                        Trace.msgPrintln("Reading cached JAR file from JRE 1.4 and early release");
                        try {
                            int n6;
                            Object object3;
                            object2 = CertificateFactory.getInstance("X.509");
                            ArrayList<CertPath> arrayList2 = new ArrayList<CertPath>();
                            int n7 = 0;
                            n3 = 0;
                            int n8 = 0;
                            while (n8 < certificateArray.length) {
                                Serializable serializable;
                                object3 = new ArrayList();
                                n6 = n3;
                                for (n6 = n3; n6 < certificateArray.length; ++n6) {
                                    serializable = null;
                                    Serializable serializable2 = null;
                                    if (certificateArray[n6] instanceof X509Certificate) {
                                        serializable = (X509Certificate)certificateArray[n6];
                                    }
                                    serializable2 = n6 + 1 < certificateArray.length && certificateArray[n6 + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n6 + 1] : serializable;
                                    ((ArrayList)object3).add(serializable);
                                    if (!CachedJarLoader.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                                }
                                n8 = n6 < certificateArray.length ? n6 + 1 : n6;
                                serializable = ((CertificateFactory)object2).generateCertPath((List<? extends Certificate>)object3);
                                ((ArrayList)object3).clear();
                                arrayList2.add((CertPath)serializable);
                                n3 = n8;
                                ++n7;
                            }
                            codeSignerArray = new CodeSigner[n7];
                            object3 = new int[n7];
                            for (n6 = 0; n6 < n7; ++n6) {
                                codeSignerArray[n6] = new CodeSigner((CertPath)arrayList2.get(n6), null);
                                object3[n6] = n6;
                            }
                            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                                hashMap.put(arrayList.get(n6), object3);
                            }
                        }
                        catch (CertificateException certificateException) {
                            throw new IOException("Error process signer certificates");
                        }
                    }
                    Trace.msgPrintln("Reading cached JAR file from JRE 1.5 release");
                    int n9 = Integer.parseInt(string);
                    if (n9 > 0) {
                        codeSignerArray = new CodeSigner[n9];
                        try {
                            for (n4 = 0; n4 < n9; ++n4) {
                                codeSignerArray[n4] = (CodeSigner)objectInputStream.readObject();
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new IOException("Error reading code signer");
                        }
                        String string4 = bufferedReader.readLine();
                        object = null;
                        while (string4 != null && !string4.equals("")) {
                            String string5 = string4;
                            if (string5.startsWith("/")) {
                                string5 = (String)object + string5;
                            } else {
                                int n10 = string5.lastIndexOf("/");
                                if (n10 != -1) {
                                    object = string5.substring(0, n10);
                                }
                            }
                            string4 = bufferedReader.readLine();
                            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ", false);
                            int n11 = Integer.parseInt(stringTokenizer.nextToken());
                            int[] nArray = new int[n11];
                            for (int i = 0; i < n11; ++i) {
                                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                            }
                            hashMap.put(string5, nArray);
                            string4 = bufferedReader.readLine();
                        }
                    }
                    Cache.msgPrintln("cache.cert_load", new Object[]{this.url});
                    break block30;
                }
                Trace.msgPrintln("No certificate info, this is unsigned JAR file.");
            }
            finally {
                randomAccessFile.close();
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
        }
        return new CachedJarFile(this.dataFile, codeSignerArray, hashMap, manifest);
    }

    private void removeSignature(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes != null) {
            Set<Object> set = ((Attributes)attributes.clone()).keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Attributes.Name name = (Attributes.Name)iterator.next();
                String string2 = name.toString();
                if (string2.endsWith("-Digest") || string2.indexOf("-Digest-") != -1) {
                    attributes.remove(name);
                }
                if (!string2.equals("Magic:")) continue;
                attributes.remove(name);
            }
            if (attributes.isEmpty()) {
                manifest.getEntries().remove(string);
            }
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }
}

