/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.BitSet;
import sun.nio.cs.ThreadLocalCoders;

public class ParseUtil {
    static BitSet encodedInPath = new BitSet(256);
    private static final char[] hexDigits;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private static final long L_HEX;
    private static final long H_HEX;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA;
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA;
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA;
    private static final long L_ALPHANUM;
    private static final long H_ALPHANUM;
    private static final long L_MARK;
    private static final long H_MARK;
    private static final long L_UNRESERVED;
    private static final long H_UNRESERVED;
    private static final long L_RESERVED;
    private static final long H_RESERVED;
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_DASH;
    private static final long H_DASH;
    private static final long L_URIC;
    private static final long H_URIC;
    private static final long L_PCHAR;
    private static final long H_PCHAR;
    private static final long L_PATH;
    private static final long H_PATH;
    private static final long L_USERINFO;
    private static final long H_USERINFO;
    private static final long L_REG_NAME;
    private static final long H_REG_NAME;
    private static final long L_SERVER;
    private static final long H_SERVER;

    public static String encodePath(String string) {
        return ParseUtil.encodePath(string, true);
    }

    public static String encodePath(String string, boolean bl) {
        char[] cArray = new char[string.length() * 2 + 16];
        int n = 0;
        char[] cArray2 = string.toCharArray();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = cArray2[i];
            if (!bl && c == '/' || bl && c == File.separatorChar) {
                cArray[n++] = 47;
            } else if (c <= '\u007f') {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                    cArray[n++] = c;
                } else if (encodedInPath.get(c)) {
                    n = ParseUtil.escape(cArray, c, n);
                } else {
                    cArray[n++] = c;
                }
            } else if (c > '\u07ff') {
                n = ParseUtil.escape(cArray, (char)(0xE0 | c >> 12 & 0xF), n);
                n = ParseUtil.escape(cArray, (char)(0x80 | c >> 6 & 0x3F), n);
                n = ParseUtil.escape(cArray, (char)(0x80 | c >> 0 & 0x3F), n);
            } else {
                n = ParseUtil.escape(cArray, (char)(0xC0 | c >> 6 & 0x1F), n);
                n = ParseUtil.escape(cArray, (char)(0x80 | c >> 0 & 0x3F), n);
            }
            if (n + 9 <= cArray.length) continue;
            int n3 = cArray.length * 2 + 16;
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            char[] cArray3 = new char[n3];
            System.arraycopy(cArray, 0, cArray3, 0, n);
            cArray = cArray3;
        }
        return new String(cArray, 0, n);
    }

    private static int escape(char[] cArray, char c, int n) {
        cArray[n++] = 37;
        cArray[n++] = Character.forDigit(c >> 4 & 0xF, 16);
        cArray[n++] = Character.forDigit(c & 0xF, 16);
        return n;
    }

    private static char unescape(String string, int n) {
        return (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
    }

    public static String decode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '%') {
                ++n;
            } else {
                try {
                    c = ParseUtil.unescape(string, n);
                    n += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = ParseUtil.unescape(string, n);
                                n += 3;
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = ParseUtil.unescape(string, n);
                                char c3 = ParseUtil.unescape(string, n += 3);
                                n += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String canonizeString(String string) {
        int n = 0;
        int n2 = string.length();
        while ((n = string.indexOf("/../")) >= 0) {
            n2 = string.lastIndexOf(47, n - 1);
            if (n2 >= 0) {
                string = string.substring(0, n2) + string.substring(n + 3);
                continue;
            }
            string = string.substring(n + 3);
        }
        while ((n = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while (string.endsWith("/..")) {
            n = string.indexOf("/..");
            n2 = string.lastIndexOf(47, n - 1);
            if (n2 >= 0) {
                string = string.substring(0, n2 + 1);
                continue;
            }
            string = string.substring(0, n);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (!(string = ParseUtil.encodePath(string)).startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public static URI toURI(URL uRL) {
        URI uRI;
        String string = uRL.getProtocol();
        String string2 = uRL.getAuthority();
        String string3 = uRL.getPath();
        String string4 = uRL.getQuery();
        String string5 = uRL.getRef();
        if (string3 != null && !string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        try {
            uRI = ParseUtil.createURI(string, string2, string3, string4, string5);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        return uRI;
    }

    private static URI createURI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        String string6 = ParseUtil.toString(string, null, string2, null, null, -1, string3, string4, string5);
        ParseUtil.checkPath(string6, string, string3);
        return new URI(string6);
    }

    private static String toString(String string, String string2, String string3, String string4, String string5, int n, String string6, String string7, String string8) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        ParseUtil.appendSchemeSpecificPart(stringBuffer, string2, string3, string4, string5, n, string6, string7);
        ParseUtil.appendFragment(stringBuffer, string8);
        return stringBuffer.toString();
    }

    private static void appendSchemeSpecificPart(StringBuffer stringBuffer, String string, String string2, String string3, String string4, int n, String string5, String string6) {
        if (string != null) {
            if (string.startsWith("//[")) {
                int n2 = string.indexOf("]");
                if (n2 != -1 && string.indexOf(":") != -1) {
                    String string7;
                    String string8;
                    if (n2 == string.length()) {
                        string8 = string;
                        string7 = "";
                    } else {
                        string8 = string.substring(0, n2 + 1);
                        string7 = string.substring(n2 + 1);
                    }
                    stringBuffer.append(string8);
                    stringBuffer.append(ParseUtil.quote(string7, L_URIC, H_URIC));
                }
            } else {
                stringBuffer.append(ParseUtil.quote(string, L_URIC, H_URIC));
            }
        } else {
            ParseUtil.appendAuthority(stringBuffer, string2, string3, string4, n);
            if (string5 != null) {
                stringBuffer.append(ParseUtil.quote(string5, L_PATH, H_PATH));
            }
            if (string6 != null) {
                stringBuffer.append('?');
                stringBuffer.append(ParseUtil.quote(string6, L_URIC, H_URIC));
            }
        }
    }

    private static void appendAuthority(StringBuffer stringBuffer, String string, String string2, String string3, int n) {
        if (string3 != null) {
            boolean bl;
            stringBuffer.append("//");
            if (string2 != null) {
                stringBuffer.append(ParseUtil.quote(string2, L_USERINFO, H_USERINFO));
                stringBuffer.append('@');
            }
            boolean bl2 = bl = string3.indexOf(58) >= 0 && !string3.startsWith("[") && !string3.endsWith("]");
            if (bl) {
                stringBuffer.append('[');
            }
            stringBuffer.append(string3);
            if (bl) {
                stringBuffer.append(']');
            }
            if (n != -1) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
        } else if (string != null) {
            stringBuffer.append("//");
            if (string.startsWith("[")) {
                int n2 = string.indexOf("]");
                if (n2 != -1 && string.indexOf(":") != -1) {
                    String string4;
                    String string5;
                    if (n2 == string.length()) {
                        string5 = string;
                        string4 = "";
                    } else {
                        string5 = string.substring(0, n2 + 1);
                        string4 = string.substring(n2 + 1);
                    }
                    stringBuffer.append(string5);
                    stringBuffer.append(ParseUtil.quote(string4, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
                }
            } else {
                stringBuffer.append(ParseUtil.quote(string, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
            }
        }
    }

    private static void appendFragment(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(ParseUtil.quote(string, L_URIC, H_URIC));
        }
    }

    private static String quote(String string, long l, long l2) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        boolean bl = (l & 1L) != 0L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                if (!ParseUtil.match(c, l, l2) && !ParseUtil.isEscaped(string, i)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, i));
                    }
                    ParseUtil.appendEscape(stringBuffer, (byte)c);
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
                continue;
            }
            if (bl && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, i));
                }
                ParseUtil.appendEncoded(stringBuffer, c);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static boolean isEscaped(String string, int n) {
        if (string == null || string.length() < n + 2) {
            return false;
        }
        return string.charAt(n) == '%' && ParseUtil.match(string.charAt(n + 1), L_HEX, H_HEX) && ParseUtil.match(string.charAt(n + 2), L_HEX, H_HEX);
    }

    private static void appendEncoded(StringBuffer stringBuffer, char c) {
        Buffer buffer;
        block4: {
            buffer = null;
            try {
                buffer = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap("" + c));
            }
            catch (CharacterCodingException characterCodingException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        while (buffer.hasRemaining()) {
            int n = ((ByteBuffer)buffer).get() & 0xFF;
            if (n >= 128) {
                ParseUtil.appendEscape(stringBuffer, (byte)n);
                continue;
            }
            stringBuffer.append((char)n);
        }
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append('%');
        stringBuffer.append(hexDigits[by >> 4 & 0xF]);
        stringBuffer.append(hexDigits[by >> 0 & 0xF]);
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private static void checkPath(String string, String string2, String string3) throws URISyntaxException {
        if (string2 != null && string3 != null && string3.length() > 0 && string3.charAt(0) != '/') {
            throw new URISyntaxException(string, "Relative path in absolute URI");
        }
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '@') continue;
            l |= 1L << c;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            l |= 1L << c - 64;
        }
        return l;
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        L_HEX = L_DIGIT = ParseUtil.lowMask('0', '9');
        H_HEX = ParseUtil.highMask('A', 'F') | ParseUtil.highMask('a', 'f');
        H_UPALPHA = ParseUtil.highMask('A', 'Z');
        H_LOWALPHA = ParseUtil.highMask('a', 'z');
        H_ALPHA = H_LOWALPHA | H_UPALPHA;
        L_ALPHANUM = L_DIGIT | 0L;
        H_ALPHANUM = 0L | H_ALPHA;
        L_MARK = ParseUtil.lowMask("-_.!~*'()");
        H_MARK = ParseUtil.highMask("-_.!~*'()");
        L_UNRESERVED = L_ALPHANUM | L_MARK;
        H_UNRESERVED = H_ALPHANUM | H_MARK;
        L_RESERVED = ParseUtil.lowMask(";/?:@&=+$,[]");
        H_RESERVED = ParseUtil.highMask(";/?:@&=+$,[]");
        L_DASH = ParseUtil.lowMask("-");
        H_DASH = ParseUtil.highMask("-");
        L_URIC = L_RESERVED | L_UNRESERVED | 1L;
        H_URIC = H_RESERVED | H_UNRESERVED | 0L;
        L_PCHAR = L_UNRESERVED | 1L | ParseUtil.lowMask(":@&=+$,");
        H_PCHAR = H_UNRESERVED | 0L | ParseUtil.highMask(":@&=+$,");
        L_PATH = L_PCHAR | ParseUtil.lowMask(";/");
        H_PATH = H_PCHAR | ParseUtil.highMask(";/");
        L_USERINFO = L_UNRESERVED | 1L | ParseUtil.lowMask(";:&=+$,");
        H_USERINFO = H_UNRESERVED | 0L | ParseUtil.highMask(";:&=+$,");
        L_REG_NAME = L_UNRESERVED | 1L | ParseUtil.lowMask("$,;:@&=+");
        H_REG_NAME = H_UNRESERVED | 0L | ParseUtil.highMask("$,;:@&=+");
        L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | ParseUtil.lowMask(".:@[]");
        H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | ParseUtil.highMask(".:@[]");
    }
}

