/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import sun.awt.image.Manageable;
import sun.awt.image.OffScreenImageSource;
import sun.awt.image.SurfaceManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceManagerFactory;

public class OffScreenImage
extends BufferedImage
implements Manageable {
    protected Component c;
    protected SurfaceManager surfaceManager;
    private OffScreenImageSource osis;
    private Font defaultFont;

    public OffScreenImage(Component component, int n, int n2) {
        this(component, n, n2, 6);
    }

    public OffScreenImage(Component component, int n, int n2, int n3) {
        super(n, n2, n3);
        this.c = component;
        this.initSurfaceManager(n, n2);
    }

    public OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl) {
        super(colorModel, writableRaster, bl, null);
        this.c = component;
        this.initSurfaceManager(writableRaster.getWidth(), writableRaster.getHeight());
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        Font font;
        Color color;
        if (this.c == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return graphicsEnvironment.createGraphics(this);
        }
        Color color2 = this.c.getBackground();
        if (color2 == null) {
            color2 = SystemColor.window;
        }
        if ((color = this.c.getForeground()) == null) {
            color = SystemColor.windowText;
        }
        if ((font = this.c.getFont()) == null) {
            if (this.defaultFont == null) {
                this.defaultFont = new Font("Dialog", 0, 12);
            }
            font = this.defaultFont;
        }
        return new SunGraphics2D(this.surfaceManager.getDestSurfaceData(), color, color2, font);
    }

    public SurfaceManager getSurfaceManager() {
        return this.surfaceManager;
    }

    protected SurfaceManager createSurfaceManager() {
        return SurfaceManagerFactory.createCachingManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSurfaceManager(int n, int n2) {
        this.surfaceManager = this.createSurfaceManager();
        if (this.c == null) {
            return;
        }
        Graphics2D graphics2D = this.createGraphics();
        try {
            graphics2D.clearRect(0, 0, n, n2);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public ImageProducer getSource() {
        if (this.osis == null) {
            this.osis = new OffScreenImageSource(this);
        }
        return this.osis;
    }
}

