/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Toolkit;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XMSelection;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.awt.XSettings;

class XAWTXSettings
extends XSettings
implements XMSelectionListener {
    private final XAtom xSettingsPropertyAtom = XAtom.get("_XSETTINGS_SETTINGS");
    private static Logger log = Logger.getLogger("sun.awt.X11.XAWTXSettings");
    public static final long MAX_LENGTH = 1000000L;
    XMSelection settings;

    public XAWTXSettings() {
        this.initXSettings();
    }

    void initXSettings() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initializing XAWT XSettings");
        }
        this.settings = new XMSelection("_XSETTINGS");
        this.settings.addSelectionListener(this);
        this.updatePerScreenXSettings();
    }

    public void ownerDeath(int n, XMSelection xMSelection, long l) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Owner " + l + " died for selection " + xMSelection + " screen " + n);
        }
    }

    public void ownerChanged(int n, XMSelection xMSelection, long l, long l2, long l3) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("New Owner " + l + " for selection = " + xMSelection + " screen " + n);
        }
    }

    public void selectionChanged(int n, XMSelection xMSelection, long l, XPropertyEvent xPropertyEvent) {
        log.fine("Selection changed on sel " + xMSelection + " screen = " + n + " owner = " + l + " event = " + xPropertyEvent);
        this.updateXSettings(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePerScreenXSettings() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Updating Per XSettings changes");
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l = XToolkit.getDisplay();
            int n = (int)XlibWrapper.DefaultScreen(l);
            this.updateXSettings(n);
        }
    }

    void updateXSettings(int n) {
        long l = this.settings.getOwner(n);
        this.updateXSettings(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateXSettings(int n, long l) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("updateXSettings owner =" + l);
        }
        if (l != 0L) {
            try {
                WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, this.xSettingsPropertyAtom, 0L, 1000000L, false, this.xSettingsPropertyAtom.getAtom());
                try {
                    byte[] byArray;
                    int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                    if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("OH OH : getter failed  status = " + n2);
                        }
                        return;
                    }
                    long l2 = windowPropertyGetter.getData();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("noItems = " + windowPropertyGetter.getNumberOfItems());
                    }
                    if ((byArray = Native.toBytes(l2, windowPropertyGetter.getNumberOfItems())) != null) {
                        Map map = this.update(byArray);
                        ((XToolkit)Toolkit.getDefaultToolkit()).parseXSettings(0, map);
                    }
                }
                finally {
                    windowPropertyGetter.dispose();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

