/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.serializer.ToStream;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToTextStream
extends ToStream {
    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending();
        try {
            this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException, SAXException {
        Writer writer = this.m_writer;
        int n3 = n + n2;
        int n4 = this.m_maxCharacter;
        if (bl) {
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if ('\n' == c && bl2) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    continue;
                }
                if (c > n4) {
                    if (i != 0) {
                        this.closeCDATA();
                    }
                    if (ToTextStream.isUTF16Surrogate(c)) {
                        this.writeUTF16Surrogate(c, cArray, i, n3);
                        ++i;
                    } else {
                        writer.write(c);
                    }
                    if (i == 0 || i >= n3 - 1) continue;
                    writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                    continue;
                }
                if (i < n3 - 2 && ']' == c && ']' == cArray[i + 1] && '>' == cArray[i + 2]) {
                    writer.write("]]]]><![CDATA[>");
                    i += 2;
                    continue;
                }
                if (c <= n4) {
                    writer.write(c);
                    continue;
                }
                if (ToTextStream.isUTF16Surrogate(c)) {
                    this.writeUTF16Surrogate(c, cArray, i, n3);
                    ++i;
                    continue;
                }
                String string = this.getEncoding();
                if (string != null) {
                    String string2 = Integer.toString(c);
                    throw new SAXException(XMLMessages.createXMLMessage("ER_ILLEGAL_CHARACTER", new Object[]{string2, string}));
                }
                writer.write(c);
            }
        } else {
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if ('\n' == c && bl2) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    continue;
                }
                if (c <= n4) {
                    writer.write(c);
                    continue;
                }
                if (ToTextStream.isUTF16Surrogate(c)) {
                    this.writeUTF16Surrogate(c, cArray, i, n3);
                    ++i;
                    continue;
                }
                String string = this.getEncoding();
                if (string != null) {
                    String string3 = Integer.toString(c);
                    throw new SAXException(XMLMessages.createXMLMessage("ER_ILLEGAL_CHARACTER", new Object[]{string3, string}));
                }
                writer.write(c);
            }
        }
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void comment(String string) throws SAXException {
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n, n2);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
    }

    public void endCDATA() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string);
        }
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void characters(String string) throws SAXException {
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, n);
    }

    public void addAttribute(String string, String string2) {
    }

    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        return false;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    public void flushPending() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
    }
}

