/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class WindowsInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Color selectedTitleGradientColor;
    private Color notSelectedTitleGradientColor;
    private JPopupMenu systemPopupMenu;
    private JLabel systemLabel;
    private Font titleFont;
    private int titlePaneHeight;
    private int buttonWidth;
    private int buttonHeight;

    public WindowsInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void addSubComponents() {
        this.add(this.systemLabel);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.titlePaneHeight = UIManager.getInt("InternalFrame.titlePaneHeight");
        this.buttonWidth = UIManager.getInt("InternalFrame.titleButtonWidth") - 4;
        this.buttonHeight = UIManager.getInt("InternalFrame.titleButtonHeight") - 4;
        if (XPStyle.getXP() != null) {
            this.buttonWidth = this.buttonHeight;
        } else {
            this.buttonWidth += 2;
            this.selectedTitleGradientColor = UIManager.getColor("InternalFrame.activeTitleGradient");
            this.notSelectedTitleGradientColor = UIManager.getColor("InternalFrame.inactiveTitleGradient");
            Color color = UIManager.getColor("InternalFrame.activeBorderColor");
            this.setBorder(BorderFactory.createLineBorder(color, 1));
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    protected void createButtons() {
        super.createButtons();
        if (XPStyle.getXP() != null) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    public void paintComponent(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        this.paintTitleBackground(graphics);
        String string = this.frame.getTitle();
        if (string != null) {
            int n;
            boolean bl = this.frame.isSelected();
            Font font = graphics.getFont();
            Font font2 = this.titleFont != null ? this.titleFont : this.getFont();
            graphics.setFont(font2);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.frame, graphics, font2);
            int n2 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (WindowsGraphicsUtils.isLeftToRight(this.frame)) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                n = this.systemLabel.getX() + this.systemLabel.getWidth() + 2;
                if (xPStyle != null) {
                    n += 2;
                }
                int n3 = rectangle.x - n - 3;
                string = this.getTitle(this.frame.getTitle(), fontMetrics, n3);
            } else {
                n = this.systemLabel.getX() - 2 - SwingUtilities2.stringWidth(this.frame, fontMetrics, string);
            }
            if (xPStyle != null) {
                String string2 = null;
                if (bl) {
                    string2 = xPStyle.getString(this, "window.caption", "active", "textshadowtype");
                }
                if ("single".equalsIgnoreCase(string2)) {
                    Point point = xPStyle.getPoint(this, "window", "active", "textshadowoffset");
                    Color color = xPStyle.getColor(this, "window", "active", "textshadowcolor", null);
                    if (point != null && color != null) {
                        graphics.setColor(color);
                        SwingUtilities2.drawString((JComponent)this.frame, graphics, string, n + point.x, n2 + point.y);
                    }
                }
            }
            graphics.setColor(bl ? this.selectedTextColor : this.notSelectedTextColor);
            SwingUtilities2.drawString((JComponent)this.frame, graphics, string, n, n2);
            graphics.setFont(font);
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(super.getMinimumSize());
        dimension.height = this.titlePaneHeight + 2;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            dimension.height = this.frame.isMaximum() ? --dimension.height : (dimension.height += 3);
        }
        return dimension;
    }

    protected void paintTitleBackground(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(this, this.frame.isIcon() ? "window.mincaption" : (this.frame.isMaximum() ? "window.maxcaption" : "window.caption"));
            skin.paintSkin(graphics, 0, 0, this.getWidth(), this.getHeight(), this.frame.isSelected() ? 0 : 1);
        } else {
            Boolean bl = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", false);
            if (bl.booleanValue() && graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                boolean bl2 = this.frame.isSelected();
                int n = this.getWidth();
                if (bl2) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.selectedTitleColor, (int)((double)n * 0.75), 0.0f, this.selectedTitleGradientColor);
                    graphics2D.setPaint(gradientPaint);
                } else {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.notSelectedTitleColor, (int)((double)n * 0.75), 0.0f, this.notSelectedTitleGradientColor);
                    graphics2D.setPaint(gradientPaint);
                }
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setPaint(paint);
            } else {
                super.paintTitleBackground(graphics);
            }
        }
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.systemLabel = new JLabel(this.frame.getFrameIcon()){

            protected void paintComponent(Graphics graphics) {
                int n = 0;
                int n2 = 0;
                int n3 = this.getWidth();
                int n4 = this.getHeight();
                graphics = graphics.create();
                if (this.isOpaque()) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, n3, n4);
                }
                Icon icon = this.getIcon();
                int n5 = 0;
                int n6 = 0;
                if (icon != null && (n5 = icon.getIconWidth()) > 0 && (n6 = icon.getIconHeight()) > 0) {
                    double d;
                    if (n5 > n6) {
                        n2 = (n4 - n3 * n6 / n5) / 2;
                        d = (double)n3 / (double)n5;
                    } else {
                        n = (n3 - n4 * n5 / n6) / 2;
                        d = (double)n4 / (double)n6;
                    }
                    ((Graphics2D)graphics).translate(n, n2);
                    ((Graphics2D)graphics).scale(d, d);
                    icon.paintIcon(this, graphics, 0, 0);
                }
                graphics.dispose();
            }
        };
        this.systemLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                WindowsInternalFrameTitlePane.this.showSystemPopupMenu(mouseEvent.getComponent());
            }
        });
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        this.systemPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected void showSystemMenu() {
        this.showSystemPopupMenu(this.systemLabel);
    }

    private void showSystemPopupMenu(Component component) {
        Dimension dimension = new Dimension();
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.width += border.getBorderInsets((Component)this.frame).left + border.getBorderInsets((Component)this.frame).right;
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(component, this.getX() - dimension.width, this.getY() + this.getHeight() - dimension.height);
        } else {
            this.systemPopupMenu.show(component, this.getX() - dimension.width, this.getY() - this.systemPopupMenu.getPreferredSize().height - dimension.height);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new WindowsPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new WindowsTitlePaneLayout();
    }

    public static class ScalableIconUIResource
    implements Icon,
    UIResource {
        private static final int SIZE = 16;
        private Icon[] icons;

        public ScalableIconUIResource(Object[] objectArray) {
            this.icons = new Icon[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.icons[i] = objectArray[i] instanceof UIDefaults.LazyValue ? (Icon)((UIDefaults.LazyValue)objectArray[i]).createValue(null) : (Icon)objectArray[i];
            }
        }

        protected Icon getBestIcon(int n) {
            if (this.icons != null && this.icons.length > 0) {
                int n2 = 0;
                int n3 = Integer.MAX_VALUE;
                for (int i = 0; i < this.icons.length; ++i) {
                    int n4;
                    int n5;
                    Icon icon = this.icons[i];
                    if (icon == null || (n5 = icon.getIconWidth()) <= 0 || (n4 = Math.abs(n5 - n)) >= n3) continue;
                    n3 = n4;
                    n2 = i;
                }
                return this.icons[n2];
            }
            return null;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            double d;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            int n4 = this.getIconWidth();
            Icon icon = this.getBestIcon((int)((double)n4 * (d = graphics2D.getTransform().getScaleX())));
            if (icon != null && (n3 = icon.getIconWidth()) > 0) {
                double d2 = (double)n4 / (double)n3;
                graphics2D.translate(n, n2);
                graphics2D.scale(d2, d2);
                icon.paintIcon(component, graphics2D, 0, 0);
            }
            graphics2D.dispose();
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    public class WindowsPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        public WindowsPropertyChangeHandler() {
            super(WindowsInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("frameIcon".equals(string) && WindowsInternalFrameTitlePane.this.systemLabel != null) {
                WindowsInternalFrameTitlePane.this.systemLabel.setIcon(WindowsInternalFrameTitlePane.this.frame.getFrameIcon());
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public class WindowsTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        private Insets captionMargin;
        private Insets contentMargin;
        private XPStyle xp;

        WindowsTitlePaneLayout() {
            super(WindowsInternalFrameTitlePane.this);
            this.captionMargin = null;
            this.contentMargin = null;
            this.xp = XPStyle.getXP();
            if (this.xp != null) {
                WindowsInternalFrameTitlePane windowsInternalFrameTitlePane2 = WindowsInternalFrameTitlePane.this;
                this.captionMargin = this.xp.getMargin(windowsInternalFrameTitlePane2, "window.caption", null, "captionmargins");
                this.contentMargin = this.xp.getMargin(windowsInternalFrameTitlePane2, "window.caption", null, "contentmargins");
            }
            if (this.captionMargin == null) {
                this.captionMargin = new Insets(0, 2, 0, 2);
            }
            if (this.contentMargin == null) {
                this.contentMargin = new Insets(0, 0, 0, 0);
            }
        }

        private int layoutButton(JComponent jComponent, String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (!bl) {
                n -= n3;
            }
            jComponent.setBounds(n, n2, n3, n4);
            n = bl ? (n += n3 + 2) : (n -= 2);
            return n;
        }

        public void layoutContainer(Container container) {
            int n;
            boolean bl = WindowsGraphicsUtils.isLeftToRight(WindowsInternalFrameTitlePane.this.frame);
            int n2 = WindowsInternalFrameTitlePane.this.getWidth();
            int n3 = WindowsInternalFrameTitlePane.this.getHeight();
            int n4 = n = this.xp != null ? (n3 - 2) * 6 / 10 : n3 - 4;
            int n5 = this.xp != null ? (bl ? this.captionMargin.left + 2 : n2 - this.captionMargin.right - 2) : (bl ? this.captionMargin.left : n2 - this.captionMargin.right);
            int n6 = (n3 - n) / 2;
            this.layoutButton(WindowsInternalFrameTitlePane.this.systemLabel, "window.sysbutton", n5, n6, n, n, 0, bl);
            if (this.xp != null) {
                n5 = bl ? n2 - this.captionMargin.right - 2 : this.captionMargin.left + 2;
                n6 = 1;
                n6 = WindowsInternalFrameTitlePane.this.frame.isMaximum() ? ++n6 : (n6 += 5);
            } else {
                n5 = bl ? n2 - this.captionMargin.right : this.captionMargin.left;
                n6 = (n3 - WindowsInternalFrameTitlePane.this.buttonHeight) / 2;
            }
            if (WindowsInternalFrameTitlePane.this.frame.isClosable()) {
                n5 = this.layoutButton(WindowsInternalFrameTitlePane.this.closeButton, "window.closebutton", n5, n6, WindowsInternalFrameTitlePane.this.buttonWidth, WindowsInternalFrameTitlePane.this.buttonHeight, 2, !bl);
            }
            if (WindowsInternalFrameTitlePane.this.frame.isMaximizable()) {
                n5 = this.layoutButton(WindowsInternalFrameTitlePane.this.maxButton, "window.maxbutton", n5, n6, WindowsInternalFrameTitlePane.this.buttonWidth, WindowsInternalFrameTitlePane.this.buttonHeight, this.xp != null ? 2 : 0, !bl);
            }
            if (WindowsInternalFrameTitlePane.this.frame.isIconifiable()) {
                this.layoutButton(WindowsInternalFrameTitlePane.this.iconButton, "window.minbutton", n5, n6, WindowsInternalFrameTitlePane.this.buttonWidth, WindowsInternalFrameTitlePane.this.buttonHeight, 0, !bl);
            }
        }
    }
}

