/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

class GTKScanner {
    public static final String CHARS_a_2_z = "abcdefghijklmnopqrstuvwxyz";
    public static final String CHARS_A_2_Z = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String CHARS_DIGITS = "0123456789";
    public static final int TOKEN_EOF = -1;
    public static final int TOKEN_LEFT_PAREN = 40;
    public static final int TOKEN_RIGHT_PAREN = 41;
    public static final int TOKEN_LEFT_CURLY = 123;
    public static final int TOKEN_RIGHT_CURLY = 125;
    public static final int TOKEN_LEFT_BRACE = 91;
    public static final int TOKEN_RIGHT_BRACE = 93;
    public static final int TOKEN_EQUAL_SIGN = 61;
    public static final int TOKEN_COMMA = 44;
    public static final int TOKEN_NONE = 256;
    public static final int TOKEN_ERROR = 257;
    public static final int TOKEN_CHAR = 258;
    public static final int TOKEN_BINARY = 259;
    public static final int TOKEN_OCTAL = 260;
    public static final int TOKEN_INT = 261;
    public static final int TOKEN_HEX = 262;
    public static final int TOKEN_FLOAT = 263;
    public static final int TOKEN_STRING = 264;
    public static final int TOKEN_SYMBOL = 265;
    public static final int TOKEN_IDENTIFIER = 266;
    public static final int TOKEN_IDENTIFIER_NULL = 267;
    public static final int TOKEN_LAST = 268;
    public static final int ERR_UNKNOWN = 0;
    public static final int ERR_UNEXP_EOF = 1;
    public static final int ERR_UNEXP_EOF_IN_STRING = 2;
    public static final int ERR_UNEXP_EOF_IN_COMMENT = 3;
    public static final int ERR_NON_DIGIT_IN_CONST = 4;
    public static final int ERR_DIGIT_RADIX = 5;
    public static final int ERR_FLOAT_RADIX = 6;
    public static final int ERR_FLOAT_MALFORMED = 7;
    String whiteSpaceChars = " \t\r\n";
    String identifierFirst = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
    String identifierNth = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789";
    String commentSingle = "#\n";
    boolean caseSensitive = false;
    boolean scanCommentMulti = true;
    boolean scanIdentifier = true;
    boolean scanIdentifier1Char = false;
    boolean scanIdentifierNULL = false;
    boolean scanSymbols = true;
    boolean scanBinary = false;
    boolean scanOctal = true;
    boolean scanFloat = true;
    boolean scanHex = true;
    boolean scanHexDollar = false;
    boolean scanStringSq = true;
    boolean scanStringDq = true;
    boolean numbers2Int = true;
    boolean int2Float = false;
    boolean identifier2String = false;
    boolean char2Token = true;
    boolean symbol2Token = false;
    private String inputName;
    private HashMap symbolTable = new HashMap();
    private Reader reader;
    int currToken;
    TokenValue currValue = new TokenValue();
    int currLine;
    int currPosition;
    int nextToken;
    TokenValue nextValue = new TokenValue();
    int nextLine;
    int nextPosition;
    int currScope = 0;
    private static int nextUniqueScope = 1;
    private static final int CHAR_EOF = -1;
    private static final int CHAR_NONE = -2;
    private int peekedChar = -2;
    private ScannerKey lookupKey = new ScannerKey(0, null);
    private StringBuffer sb;
    private TokenValue value = new TokenValue();
    private int token;
    private int ch;

    public GTKScanner() {
        this.clearScanner();
    }

    public void clearScanner() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        this.inputName = null;
        this.currToken = 256;
        this.currValue.clear();
        this.currLine = 1;
        this.currPosition = 0;
        this.nextToken = 256;
        this.nextValue.clear();
        this.nextLine = 1;
        this.nextPosition = 0;
        this.currScope = 0;
        this.peekedChar = -2;
    }

    public void scanReader(Reader reader, String string) {
        if (reader == null) {
            return;
        }
        if (this.reader != null) {
            this.clearScanner();
        }
        this.reader = reader;
        this.inputName = string;
    }

    public static int getUniqueScopeID() {
        return nextUniqueScope++;
    }

    public int setScope(int n) {
        int n2 = this.currScope;
        this.currScope = n;
        return n2;
    }

    public void addSymbol(String string, int n) {
        if (string == null) {
            return;
        }
        ScannerKey scannerKey = this.lookupSymbol(string);
        if (scannerKey == null) {
            scannerKey = new ScannerKey(this.currScope, this.caseSensitive ? string : string.toLowerCase());
            this.symbolTable.put(scannerKey, scannerKey);
        }
        scannerKey.value = n;
    }

    public boolean containsSymbol(String string) {
        return this.lookupSymbol(string) != null;
    }

    private ScannerKey lookupSymbol(String string) {
        this.lookupKey.scope = this.currScope;
        this.lookupKey.symbol = this.caseSensitive ? string : string.toLowerCase();
        return (ScannerKey)this.symbolTable.get(this.lookupKey);
    }

    public void clearSymbolTable() {
        this.symbolTable.clear();
    }

    public int peekNextToken() throws IOException {
        if (this.nextToken == 256) {
            this.readAToken();
            switch (this.nextToken) {
                case 265: {
                    if (!this.symbol2Token) break;
                    this.nextToken = (int)this.nextValue.longVal;
                    break;
                }
                case 266: {
                    if (!this.identifier2String) break;
                    this.nextToken = 264;
                    break;
                }
                case 259: 
                case 260: 
                case 262: {
                    if (!this.numbers2Int) break;
                    this.nextToken = 261;
                }
            }
            if (this.nextToken == 261 && this.int2Float) {
                this.nextToken = 263;
                this.nextValue.doubleVal = this.nextValue.longVal;
            }
        }
        return this.nextToken;
    }

    public int getToken() throws IOException {
        this.currToken = this.peekNextToken();
        this.currValue.copyFrom(this.nextValue);
        this.currLine = this.nextLine;
        this.currPosition = this.nextPosition;
        if (this.currToken != -1) {
            this.nextToken = 256;
        }
        return this.currToken;
    }

    private int peekNextChar() throws IOException {
        if (this.peekedChar == -2) {
            this.peekedChar = this.reader.read();
        }
        return this.peekedChar;
    }

    private int getChar() throws IOException {
        int n = this.peekNextChar();
        if (n != -1) {
            this.peekedChar = -2;
            if (n == 10) {
                this.nextPosition = 0;
                ++this.nextLine;
            } else {
                ++this.nextPosition;
            }
        }
        return n;
    }

    private boolean skipSpaceAndComments() throws IOException {
        while (this.ch != -1) {
            if (this.whiteSpaceChars.indexOf(this.ch) == -1) {
                if (this.scanCommentMulti && this.ch == 47 && this.peekNextChar() == 42) {
                    this.getChar();
                    while ((this.ch = this.getChar()) != -1) {
                        if (this.ch != 42 || this.peekNextChar() != 47) continue;
                        this.getChar();
                        break;
                    }
                    if (this.ch == -1) {
                        return false;
                    }
                } else {
                    if (this.commentSingle.length() != 2 || this.ch != this.commentSingle.charAt(0)) break;
                    while ((this.ch = this.getChar()) != -1 && this.ch != this.commentSingle.charAt(1)) {
                    }
                    if (this.ch == -1) {
                        return false;
                    }
                }
            }
            this.ch = this.getChar();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void readAToken() throws IOException {
        var1_1 = false;
        this.nextValue.clear();
        this.sb = null;
        do {
            this.value.clear();
            this.token = 256;
            this.ch = this.getChar();
            if (!this.skipSpaceAndComments()) {
                this.token = 257;
                this.value.longVal = 3L;
                continue;
            }
            if (this.scanIdentifier && this.ch != -1 && this.identifierFirst.indexOf(this.ch) != -1) {
                this.checkForIdentifier();
                this.handleOrdinaryChar();
                continue;
            }
            switch (this.ch) {
                case -1: {
                    this.token = -1;
                    break;
                }
                case 34: {
                    if (!this.scanStringDq) {
                        this.handleOrdinaryChar();
                        break;
                    }
                    this.token = 264;
                    var1_1 = true;
                    this.sb = new StringBuffer();
                    block20: while ((this.ch = this.getChar()) != -1) {
                        if (this.ch == 34) {
                            var1_1 = false;
                            break;
                        }
                        if (this.ch == 92) {
                            this.ch = this.getChar();
                            switch (this.ch) {
                                case -1: {
                                    continue block20;
                                }
                                case 92: {
                                    this.sb.append('\\');
                                    continue block20;
                                }
                                case 110: {
                                    this.sb.append('\n');
                                    continue block20;
                                }
                                case 114: {
                                    this.sb.append('\r');
                                    continue block20;
                                }
                                case 116: {
                                    this.sb.append('\t');
                                    continue block20;
                                }
                                case 102: {
                                    this.sb.append('\f');
                                    continue block20;
                                }
                                case 98: {
                                    this.sb.append('\b');
                                    continue block20;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    var2_2 = this.ch - 48;
                                    var3_3 = this.peekNextChar();
                                    if (var3_3 >= 48 && var3_3 <= 55) {
                                        this.ch = this.getChar();
                                        var2_2 = var2_2 * 8 + this.ch - 48;
                                        var3_3 = this.peekNextChar();
                                        if (var3_3 >= 48 && var3_3 <= 55) {
                                            this.ch = this.getChar();
                                            var2_2 = var2_2 * 8 + this.ch - 48;
                                        }
                                    }
                                    this.sb.append((char)var2_2);
                                    continue block20;
                                }
                            }
                            this.sb.append((char)this.ch);
                            continue;
                        }
                        this.sb.append((char)this.ch);
                    }
                    this.ch = -1;
                    break;
                }
                case 39: {
                    if (!this.scanStringSq) {
                        this.handleOrdinaryChar();
                        break;
                    }
                    this.token = 264;
                    var1_1 = true;
                    this.sb = new StringBuffer();
                    while ((this.ch = this.getChar()) != -1) {
                        if (this.ch == 39) {
                            var1_1 = false;
                            break;
                        }
                        this.sb.append((char)this.ch);
                    }
                    this.ch = -1;
                    break;
                }
                case 36: {
                    if (!this.scanHexDollar) {
                        this.handleOrdinaryChar();
                        break;
                    }
                    this.token = 262;
                    this.ch = this.getChar();
                    this.scanNumber(false);
                    break;
                }
                case 46: {
                    if (!this.scanFloat) {
                        this.handleOrdinaryChar();
                        break;
                    }
                    this.token = 263;
                    this.ch = this.getChar();
                    this.scanNumber(true);
                    break;
                }
                case 48: {
                    this.token = this.scanOctal != false ? 260 : 261;
                    this.ch = this.peekNextChar();
                    if (!this.scanHex || this.ch != 120 && this.ch != 88) ** GOTO lbl131
                    this.token = 262;
                    this.getChar();
                    this.ch = this.getChar();
                    if (this.ch == -1) {
                        this.token = 257;
                        this.value.longVal = 1L;
                        break;
                    }
                    if (GTKScanner.char2int(this.ch, 16) < 0) {
                        this.token = 257;
                        this.value.longVal = 5L;
                        this.ch = -1;
                        break;
                    }
                    ** GOTO lbl147
lbl131:
                    // 1 sources

                    if (this.scanBinary && (this.ch == 98 || this.ch == 66)) {
                        this.token = 259;
                        this.getChar();
                        this.ch = this.getChar();
                        if (this.ch == -1) {
                            this.token = 257;
                            this.value.longVal = 1L;
                            break;
                        }
                        if (GTKScanner.char2int(this.ch, 2) < 0) {
                            this.token = 257;
                            this.value.longVal = 4L;
                            this.ch = -1;
                            break;
                        }
                    } else {
                        this.ch = 48;
                    }
                }
lbl147:
                // 4 sources

                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.scanNumber(false);
                    break;
                }
                default: {
                    this.handleOrdinaryChar();
                }
            }
        } while (this.ch != -1);
        if (var1_1) {
            this.token = 257;
            this.value.longVal = 2L;
            this.sb = null;
        }
        if (this.sb != null) {
            this.value.stringVal = this.sb.toString();
            this.sb = null;
        }
        if (this.token == 266) {
            if (this.scanSymbols) {
                var2_2 = this.currScope;
                var3_4 = this.lookupSymbol(this.value.stringVal);
                if (var3_4 != null) {
                    this.value.stringVal = null;
                    this.token = 265;
                    this.value.longVal = var3_4.value;
                }
            }
            if (this.token == 266 && this.scanIdentifierNULL & this.value.stringVal.length() == 4 && "NULL".equals(this.caseSensitive != false ? this.value.stringVal : this.value.stringVal.toUpperCase())) {
                this.token = 267;
            }
        }
        this.nextToken = this.token;
        this.nextValue.copyFrom(this.value);
    }

    private void handleOrdinaryChar() throws IOException {
        if (this.ch != -1) {
            if (this.char2Token) {
                this.token = this.ch;
            } else {
                this.token = 258;
                this.value.charVal = (char)this.ch;
            }
            this.ch = -1;
        }
    }

    private void checkForIdentifier() throws IOException {
        if (this.ch != -1 && this.identifierNth.indexOf(this.peekNextChar()) != -1) {
            this.token = 266;
            this.sb = new StringBuffer();
            this.sb.append((char)this.ch);
            do {
                this.ch = this.getChar();
                this.sb.append((char)this.ch);
                this.ch = this.peekNextChar();
            } while (this.ch != -1 && this.identifierNth.indexOf(this.ch) != -1);
            this.ch = -1;
        } else if (this.scanIdentifier1Char) {
            this.token = 266;
            this.value.stringVal = String.valueOf((char)this.ch);
            this.ch = -1;
        }
    }

    private static int char2int(int n, int n2) {
        if (n >= 48 && n <= 57) {
            n -= 48;
        } else if (n >= 65 && n <= 90) {
            n -= 55;
        } else if (n >= 97 && n <= 122) {
            n -= 87;
        } else {
            return -1;
        }
        return n < n2 ? n : -1;
    }

    private void scanNumber(boolean bl) throws IOException {
        boolean bl2 = true;
        if (this.token == 256) {
            this.token = 261;
        }
        this.sb = new StringBuffer(bl ? "0." : "");
        this.sb.append((char)this.ch);
        do {
            boolean bl3 = this.token == 263 && (this.ch == 101 || this.ch == 69);
            this.ch = this.peekNextChar();
            if (GTKScanner.char2int(this.ch, 36) >= 0 || this.scanFloat && this.ch == 46 || bl3 && (this.ch == 43 || this.ch == 45)) {
                this.ch = this.getChar();
                switch (this.ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.sb.append((char)this.ch);
                        break;
                    }
                    case 46: {
                        if (this.token != 261 && this.token != 260) {
                            this.value.longVal = this.token == 263 ? 7 : 6;
                            this.token = 257;
                            bl2 = false;
                            break;
                        }
                        this.token = 263;
                        this.sb.append((char)this.ch);
                        break;
                    }
                    case 43: 
                    case 45: {
                        if (this.token != 263) {
                            this.token = 257;
                            this.value.longVal = 4L;
                            bl2 = false;
                            break;
                        }
                        this.sb.append((char)this.ch);
                        break;
                    }
                    case 69: 
                    case 101: {
                        if (this.token != 262 && !this.scanFloat || this.token != 262 && this.token != 260 && this.token != 263 && this.token != 261) {
                            this.token = 257;
                            this.value.longVal = 4L;
                            bl2 = false;
                            break;
                        }
                        if (this.token != 262) {
                            this.token = 263;
                        }
                        this.sb.append((char)this.ch);
                        break;
                    }
                    default: {
                        if (this.token != 262) {
                            this.token = 257;
                            this.value.longVal = 4L;
                            break;
                        }
                        this.sb.append((char)this.ch);
                        break;
                    }
                }
                continue;
            }
            bl2 = false;
        } while (bl2);
        try {
            switch (this.token) {
                case 261: {
                    this.value.longVal = Long.parseLong(this.sb.toString(), 10);
                    break;
                }
                case 263: {
                    this.value.doubleVal = Double.parseDouble(this.sb.toString());
                    break;
                }
                case 262: {
                    this.value.longVal = Long.parseLong(this.sb.toString(), 16);
                    break;
                }
                case 260: {
                    this.value.longVal = Long.parseLong(this.sb.toString(), 8);
                    break;
                }
                case 259: {
                    this.value.longVal = Long.parseLong(this.sb.toString(), 2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.token = 257;
            this.value.longVal = 4L;
        }
        this.sb = null;
        this.ch = -1;
    }

    public void printMessage(String string, boolean bl) {
        System.err.print(this.inputName + ":" + this.currLine + ": ");
        if (bl) {
            System.err.print("error: ");
        }
        System.err.println(string);
    }

    public void unexpectedToken(int n, String string, String string2, boolean bl) {
        String string3 = "lexical error or unexpected token, expected valid token";
        if (string2 != null) {
            string3 = string3 + " - " + string2;
        }
        this.printMessage(string3, bl);
    }

    private static class ScannerKey {
        private int scope;
        private String symbol;
        public int value = -1;

        ScannerKey(int n, String string) {
            this.scope = n;
            this.symbol = string;
        }

        public boolean equals(Object object) {
            if (object instanceof ScannerKey) {
                ScannerKey scannerKey = (ScannerKey)object;
                return this.scope == scannerKey.scope && this.symbol.equals(scannerKey.symbol);
            }
            return false;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.scope;
            n = 37 * n + this.symbol.hashCode();
            return n;
        }
    }

    static class TokenValue {
        long longVal;
        double doubleVal;
        char charVal;
        String stringVal;

        TokenValue() {
            this.clear();
        }

        void copyFrom(TokenValue tokenValue) {
            this.longVal = tokenValue.longVal;
            this.doubleVal = tokenValue.doubleVal;
            this.charVal = tokenValue.charVal;
            this.stringVal = tokenValue.stringVal;
        }

        void clear() {
            this.longVal = 0L;
            this.doubleVal = 0.0;
            this.charVal = '\u0000';
            this.stringVal = null;
        }
    }
}

