/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import sun.jvm.hotspot.tools.PStack;
import sun.jvm.hotspot.tools.StackTrace;
import sun.jvm.hotspot.tools.Tool;

public class JStack
extends Tool {
    private boolean mixedMode;

    public JStack(boolean mixedMode) {
        this.mixedMode = mixedMode;
    }

    public JStack() {
        this(true);
    }

    protected boolean needsJavaPrefix() {
        return false;
    }

    public String getName() {
        return "jstack";
    }

    protected void printFlagsUsage() {
        System.out.println("    -m\tto print both java and native frames (mixed mode)");
        super.printFlagsUsage();
    }

    public void run() {
        Tool tool = null;
        tool = this.mixedMode ? new PStack(false) : new StackTrace(false);
        tool.setAgent(this.getAgent());
        tool.setDebugeeType(this.getDebugeeType());
        tool.run();
    }

    public static void main(String[] args) {
        boolean mixedMode = false;
        if (args.length != 0 && args[0].equals("-m")) {
            mixedMode = true;
            String[] newArgs = new String[args.length - 1];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = args[i + 1];
            }
            args = newArgs;
        }
        JStack jstack = new JStack(mixedMode);
        jstack.start(args);
        jstack.stop();
    }
}

