/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class CompoundStatement
extends Statement {
    Statement[] args;

    public CompoundStatement(long l, Statement[] statementArray) {
        super(105, l);
        this.args = statementArray;
        for (int i = 0; i < statementArray.length; ++i) {
            if (statementArray[i] != null) continue;
            statementArray[i] = new CompoundStatement(l, new Statement[0]);
        }
    }

    public void insertStatement(Statement statement) {
        Statement[] statementArray = new Statement[1 + this.args.length];
        statementArray[0] = statement;
        for (int i = 0; i < this.args.length; ++i) {
            statementArray[i + 1] = this.args[i];
        }
        this.args = statementArray;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        this.checkLabel(environment, context);
        if (this.args.length > 0) {
            vset = this.reach(environment, vset);
            CheckContext checkContext = new CheckContext(context, this);
            Environment environment2 = Context.newEnvironment(environment, checkContext);
            for (int i = 0; i < this.args.length; ++i) {
                vset = this.args[i].checkBlockStatement(environment2, checkContext, vset, hashtable);
            }
            vset = vset.join(checkContext.vsBreak);
        }
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        int n;
        context = new Context(context, this);
        boolean bl = false;
        int n2 = 0;
        for (n = 0; n < this.args.length; ++n) {
            Statement statement = this.args[n];
            if (statement == null) continue;
            if ((statement = statement.inline(environment, context)) != null) {
                n2 = statement.op == 105 && statement.labels == null ? (n2 += ((CompoundStatement)statement).args.length) : ++n2;
                bl = true;
            }
            this.args[n] = statement;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                n = this.args.length;
                while (n-- > 0) {
                    if (this.args[n] == null) continue;
                    return this.eliminate(environment, this.args[n]);
                }
                break;
            }
        }
        if (bl || n2 != this.args.length) {
            Statement[] statementArray = new Statement[n2];
            int n3 = this.args.length;
            while (n3-- > 0) {
                Statement statement = this.args[n3];
                if (statement == null) continue;
                if (statement.op == 105 && statement.labels == null) {
                    Statement[] statementArray2 = ((CompoundStatement)statement).args;
                    int n4 = statementArray2.length;
                    while (n4-- > 0) {
                        statementArray[--n2] = statementArray2[n4];
                    }
                    continue;
                }
                statementArray[--n2] = statement;
            }
            this.args = statementArray;
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        CompoundStatement compoundStatement = (CompoundStatement)this.clone();
        compoundStatement.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            compoundStatement.args[i] = this.args[i].copyInline(context, bl);
        }
        return compoundStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = 0;
        for (int i = 0; i < this.args.length && n2 < n; n2 += this.args[i].costInline(n, environment, context), ++i) {
        }
        return n2;
    }

    public void code(Environment environment, Context context, Assembler assembler) {
        CodeContext codeContext = new CodeContext(context, this);
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].code(environment, codeContext, assembler);
        }
        assembler.add(codeContext.breakLabel);
    }

    public Expression firstConstructor() {
        return this.args.length > 0 ? this.args[0].firstConstructor() : null;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("{\n");
        for (int i = 0; i < this.args.length; ++i) {
            this.printIndent(printStream, n + 1);
            if (this.args[i] != null) {
                this.args[i].print(printStream, n + 1);
            } else {
                printStream.print("<empty>");
            }
            printStream.print("\n");
        }
        this.printIndent(printStream, n);
        printStream.print("}");
    }
}

