/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class FrameOutputWriter
extends HtmlDocletWriter {
    int noOfPackages;

    public FrameOutputWriter(ConfigurationImpl configurationImpl, String string) throws IOException {
        super(configurationImpl, string);
        this.noOfPackages = configurationImpl.packages.length;
    }

    public static void generate(ConfigurationImpl configurationImpl) {
        String string = "";
        try {
            string = "index.html";
            FrameOutputWriter frameOutputWriter = new FrameOutputWriter(configurationImpl, string);
            frameOutputWriter.generateFrameFile();
            frameOutputWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateFrameFile() {
        if (this.configuration.windowtitle.length() > 0) {
            this.printFramesetHeader(this.configuration.windowtitle, this.configuration.notimestamp);
        } else {
            this.printFramesetHeader(this.configuration.getText("doclet.Generated_Docs_Untitled"), this.configuration.notimestamp);
        }
        this.printFrameDetails();
        this.printFrameFooter();
    }

    protected void printFrameWarning() {
        this.noFrames();
        this.h2();
        this.printText("doclet.Frame_Alert");
        this.h2End();
        this.p();
        this.printText("doclet.Frame_Warning_Message");
        this.br();
        this.printText("doclet.Link_To");
        this.printHyperLink(this.configuration.topFile, this.configuration.getText("doclet.Non_Frame_Version"));
        this.println("");
        this.noFramesEnd();
    }

    protected void printFrameDetails() {
        this.frameSet("cols=\"20%,80%\" title=\"\" onLoad=\"top.loadFrames()\"");
        if (this.noOfPackages <= 1) {
            this.printAllClassesFrameTag();
        } else if (this.noOfPackages > 1) {
            this.frameSet("rows=\"30%,70%\" title=\"\" onLoad=\"top.loadFrames()\"");
            this.printAllPackagesFrameTag();
            this.printAllClassesFrameTag();
            this.frameSetEnd();
        }
        this.printClassFrameTag();
        this.printFrameWarning();
        this.frameSetEnd();
    }

    private void printAllPackagesFrameTag() {
        this.frame("src=\"overview-frame.html\" name=\"packageListFrame\" title=\"" + this.configuration.getText("doclet.All_Packages") + "\"");
    }

    private void printAllClassesFrameTag() {
        this.frame("src=\"allclasses-frame.html\" name=\"packageFrame\" title=\"" + this.configuration.getText("doclet.All_classes_and_interfaces") + "\"");
    }

    private void printClassFrameTag() {
        this.frame("src=\"" + this.configuration.topFile + "\"" + " name=\"classFrame\"" + " title=\"" + this.configuration.getText("doclet.Package_class_and_interface_descriptions") + "\" scrolling=\"yes\"");
    }
}

