/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Wed Jul 30 2003
 */

// own header
#include "javacodegenerationpolicypage.h"
// qt/kde includes
#include <qlabel.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <kdebug.h>
#include <klocale.h>
// app includes
#include "javacodegenerationformbase.h"
#include "javacodegenerator.h"
#include "../uml.h"

JavaCodeGenerationPolicyPage::JavaCodeGenerationPolicyPage( QWidget *parent, const char *name, JavaCodeGenerationPolicy * policy )
	:CodeGenerationPolicyPage(parent,name,(CodeGenerationPolicy*)policy) 
{
	form = new JavaCodeGenerationFormBase(this);
	form->m_SelectCommentStyle->setCurrentItem(commentTypeToInteger(policy->getCommentStyle()));
	form->m_generateConstructors->setChecked(policy->getAutoGenerateConstructors());
	form->m_generateAttribAccessors->setChecked(policy->getAutoGenerateAttribAccessors());
	form->m_generateAssocAccessors->setChecked(policy->getAutoGenerateAssocAccessors());
	form->m_accessorScopeCB->setCurrentItem((policy->getAttributeAccessorScope() - 200));
	form->m_assocFieldScopeCB->setCurrentItem((policy->getAssociationFieldScope() - 200));

	CodeGenerator *codegen = UMLApp::app()->getGenerator();
	JavaCodeGenerator *javacodegen = dynamic_cast<JavaCodeGenerator*>(codegen);
	if (javacodegen)
    		form->m_makeANTDocumentCheckBox->setChecked(javacodegen->getCreateANTBuildFile());
}

JavaCodeGenerationPolicyPage::~JavaCodeGenerationPolicyPage()
{
}

int JavaCodeGenerationPolicyPage::commentTypeToInteger(JavaCodeGenerationPolicy::JavaCommentStyle type) {
      switch (type) {
                case JavaCodeGenerationPolicy::DoubleSlash:
                        return 1;
                default:
                case JavaCodeGenerationPolicy::SlashStar:
                        return 0;
        }
}

void JavaCodeGenerationPolicyPage::apply()
{

	// now do our java-specific configs
	JavaCodeGenerationPolicy * parent = (JavaCodeGenerationPolicy*) m_parentPolicy;

	// block signals so we dont cause too many update content calls to code documents
        parent->blockSignals(true);

	parent->setCommentStyle((JavaCodeGenerationPolicy::JavaCommentStyle ) form->m_SelectCommentStyle->currentItem());
	parent->setAttributeAccessorScope((JavaCodeGenerationPolicy::ScopePolicy) (form->m_accessorScopeCB->currentItem()+200));
	parent->setAssociationFieldScope((JavaCodeGenerationPolicy::ScopePolicy) (form->m_assocFieldScopeCB->currentItem()+200));
	parent->setAutoGenerateConstructors(form->m_generateConstructors->isChecked());
	parent->setAutoGenerateAttribAccessors(form->m_generateAttribAccessors->isChecked());
	parent->setAutoGenerateAssocAccessors(form->m_generateAssocAccessors->isChecked());

	CodeGenerator *codegen = UMLApp::app()->getGenerator();
	JavaCodeGenerator *javacodegen = dynamic_cast<JavaCodeGenerator*>(codegen);
	if (javacodegen)
    		javacodegen->setCreateANTBuildFile(form->m_makeANTDocumentCheckBox->isChecked());

        parent->blockSignals(false);

	// now send out modified code content signal
        parent->emitModifiedCodeContentSig();

}


#include "javacodegenerationpolicypage.moc"
