.\" $XConsortium: wsm.man /main/4 1995/07/17 10:49:19 drk $
...\" @OPENGROUP_COPYRIGHT@
...\" COPYRIGHT NOTICE
...\" Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
...\" Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
...\" ALL RIGHTS RESERVED (MOTIF).  See the file named COPYRIGHT.MOTIF for
...\" the full copyright text.
...\" 
...\" This software is subject to an open license. It may only be
...\" used on, with or for operating systems which are themselves open
...\" source systems. You must contact The Open Group for a license
...\" allowing distribution and sublicensing of this software on, with,
...\" or for operating systems which are not Open Source programs.
...\" 
...\" See http://www.opengroup.org/openmotif/license for full
...\" details of the license agreement. Any use, reproduction, or
...\" distribution of the program constitutes recipient's acceptance of
...\" this agreement.
...\" 
...\" EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
...\" PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
...\" KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
...\" WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
...\" OR FITNESS FOR A PARTICULAR PURPOSE
...\" 
...\" EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
...\" NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
...\" INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
...\" DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
...\" AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
...\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
...\" ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
...\" EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
...\" POSSIBILITY OF SUCH DAMAGES.
...\" 
...\" 
...\" HISTORY
.TH wsm 1X MOTIF "Demonstration programs"
.SH NAME
\fBwsm\fR\(emMotif Workspace Manager demo
.SH SYNOPSIS
.sS
\fBwsm\fR
[\*Voptions\fR]
.sE
.SH DESCRIPTION
The Motif Workspace Manager (Wsm) uses the new Workspace Manager protocol
supported in the Motif Window Manager (Mwm) 2.0.  This application
will only work with Mwm Version 2.0.
.PP
Wsm provides a way for users to group windows and applications into
workspaces or rooms.  Only one room or workspace is visible at one
time.  By only viewing windows in one workspace at a time, your
desktop can be greatly reduced of clutter.
.PP
With Wsm, it is possible to have one window duplicated in multiple
workspaces. These duplicates can be either references to each other,
where the width, height, stacking order and other attributes are
kept the same in each workspace, or they can be copies, where each
instance can have a different position, size, or other attribute
from its counterparts in the other workspaces.  The term \fBLink\fR is
used to refer to duplicates that each reference the same set of
attributes. The term \fBCopy\fR is used to refer to duplicates that
contain their own attribute sets independent from each other.
.P
There are two methods of accessing all the functionality of the
workspace manager. The first is through commands added by Wsm to Mwm
menus. The second is through the interface provided through the
initial Wsm dialog.
.SS Options
Wsm supports the following command-line options:
.PP
\fB-fileName, -file, -f\fR      Specifies the name of the workspace 
.br
                        manager configuration file.
.PP
\fB-workspaceList, -wL\fR       Specifies the list of workspaces 
.br
                        to use.
.PP
\fB-backgroundList, -bL\fR      Specifies the background color 
.br
                        to apply to each of the workspaces.
.PP
\fB-labelPixmapList, -labelPL\fR
.br
                        Specifies the label image to 
.br
                        use for each of the workspace 
.br
                        buttons.
.PP
\fB
-currentWorkspace, -cW\fR       Specifies the default workspace 
.br
                        from the list of workspaces.
.PP
\fB-showWSDialog, -s\fR If True, a \fBmenuBar\fR is displayed 
.br
                        in the Wsm main dialog window.
.br
                        The default is True.
.PP
.SS "The Mwm Menu Interface"
Wsm will add menu entries to Mwm's menus that provide you with the
needed tools to use the capabilities of Wsm.  Each window menu will be
modified by adding the following items:
.PP
\fBOccupy...\fR         This will display a dialog window 
.br
                        allowing you to select which
.br
                        workspaces the associated window 
.br
                        should be duplicated into.  
.br
                        The dialog also allows either 
.br
                        \fBLink\fR or \fBCopy\fR the window 
.br
                        to each of the selected workspaces.
.PP
\fBCopy To All\fR               This will cause the window to be 
.br
                        copied to each of the workspaces.
.PP
\fBLink To All\fR               This will cause the window to be 
.br
                        linked to each of the workspaces.
.PP
\fBRemove From Workspace\fR     This will remove the window from 
.br
                        this workspace. If the window is 
.br
                        only in one workspace, then this
.br
                        command will be inactive.  It is 
.br
                        not possible to remove a window 
.br
                        from all workspaces using this
.br
                        command.
.PP
Wsm will modify the root menu (specified by Mwm's resource \fBrootMenu\fR)
by adding the following commands:
.PP
\fBSwitch Workspace\fR  This is a cascade menu which 
.br
                        will cascade to a menu containing 
.br
                        an entry for each workspace.  Selecting 
.br
                        an item will cause Wsm to swith 
.br
                        to the corresponding workspace.
.PP
\fBHide Workspace Manager\fR
.br
\fB(Show Workspace Manager)\fR
.br
                        This will cause the workspace to be 
.br
                        unmapped (mapped) and the menu item 
.br
                        label to be switched to 
.br
                        \fBShow Workspace Manager\fR
.br
                        (Hide Workspace Manager).
.PP
.SS "Wsm Dialog Interface"
The Wsm dialog window contains a menu bar and a rowcolumn contining a
toggle button associated with each workspace.  A popup menu can also
be displayed by pressing Button3 in the rowcolumn area.
.PP
The menu bar contains the following:
.PP
\fBFile
.br
----\fR
.PP
\fBSave\fR                      Saves the state of the workspace 
.br
                        manager and the information it 
.br
                        holds for each window.
.br
                        The data is stored in the workspace
.br
                        manager configuration file which, by
.br
                        default, is $HOME/.wsmdb.
.PP
\fBSave As...\fR                Prompts for the name of the file 
.br
                        to save the workspace manager
.br
                        data into.
.PP
\fBQuit\fR                      Terminates the workspace.  
.br
                        Note that there may be
.br
                        a slight delay before the 
.br
                        workspace manager fully
.br
                        terminates since it does some 
.br
                        cleaning-up of Mwm's menus 
.br
                        and removes the items it added.
.PP
.PP
\fBWorkspace
.br
---------\fR
.PP
\fBNew Workspace\fR             Creates a new workspace and 
.br
                        adds to associated toggle
.br
                        button to the rowcolumn.
.PP
\fBRename Workspaces...\fR       Displays a dialog window 
.br
                        you to rename each of the
.br
                        workspaces.  It also allows 
.br
                        you to enter a fully qualified
.br
                        bitmap to use as the label 
.br
                        instead of the name.
.PP
\fBSet Background...\fR This displays a dialog that 
.br
                        allows you to specify the
.br
                        background color of the workspace.
.PP
\fBConfigure Workspaces...\fR       This displays a dialog that 
.br
                        allows you to move windows
.br
                        from one workspace to another.
.br
                        In the dialog, two lists are 
.br
                        displayed.  On top of each list
.br
                        is an option menu that allows 
.br
                        you to select the corresponding 
.br
                        workspace for the windows 
.br
                        in the list.  By selecting a
.br
                        window or windows in the left 
.br
                        list, you can copy or move the to
.br
                        the workspace specified in the 
.br
                        list on the right.  By selecting 
.br
                        \fBRemove\fR, you can, instead, 
.br
                        remove them from the workspace 
.br
                        on the left.  The buttons at the 
.br
                        bottom, \fBClient\fR and 
.br
                        \fBWindow\fR, will cause either 
.br
                        all windows for a client to 
.br
                        automatically be selected, 
.br
                        or individual windows.
.PP
\fBDelete Workspaces...\fR       This displays a dialog prompting 
.br
                        you to select the workspace(s) 
.br
                        you with to delete.
.PP
.PP
\fBView
.br
----\fR
.PP
\fBHide Workspace Manager\fR    This will cause the workspace 
.br
                        manager to unmap.  Make sure that 
.br
                        Wsm has inserted the command
.br
                        \fBHide Workspace Manager\fR
.br
                        into your root menu.  If not, then
.br
                        you will not be able to restore
.br
                        the workspace manager.
.PP
The popup menu, displayed by pressing Button3 in the workspace
rowcolumn contains the following items and matches the descriptions
above:
.PP
        \fBNew Workspace
.br
        Rename Workspaces...
.br
        Set Background...
.br
        Configure Workspaces...
.br
        Delete Workspaces...
.br
        -------------------
.br
        Hide Workspace Manager
.br
        -------------------
.br
        Save
.br
        Save As...
.br
        -------------------
.br
        Exit\fR
.PP
Note, by default the workspace manager does not occupy all workspaces.
You should select 'Copy To All' or 'Link To All' the first time Wsm is
used.  After you have saved your configuration, this is no longer
necessary.
.PP
Wsm supports the following resources:
.PP
\fBfileName\fR          Specifies the name of the workspace 
.br
                        manager configuration file.
.PP
\fBworkspaceList\fR             Specifies the list of workspaces 
.br
                        to use.
.PP
\fBbackgroundList\fR            Specifies the background color 
.br
                        to apply to each of the workspaces.
.PP
\fBlabelPixmapList\fR           Specifies the label image to 
.br
                        use for each of the workspace 
.br
                        buttons.
.PP
\fBcurrentWorkspace\fR  Specifies the default workspace 
.br
                        from the list of workspaces.
.PP
\fBuseMenuBar\fR                If True, a \fBmenuBar\fR is 
.br
                        displayed in the Wsm main dialog
.br
                        window.  The default is True.


