/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.css;

import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;
import sun.plugin.dom.css.CSSStyleDeclaration;
import sun.plugin.dom.css.CSSValue;
import sun.plugin.dom.css.RGBColor;
import sun.plugin.dom.css.Rect;
import sun.plugin.dom.exception.InvalidAccessException;
import sun.plugin.dom.exception.InvalidStateException;
import sun.plugin.dom.exception.NoModificationAllowedException;

public final class CSSPrimitiveValue
extends CSSValue
implements org.w3c.dom.css.CSSPrimitiveValue {
    private static final String RGB = "rgb";
    private static final String RECT = "rect";
    private static final String COLOR = "#";
    private short primitiveType = 0;
    private Object value = null;
    private static HashMap unit2Type = null;
    private static HashMap type2Unit = null;

    protected CSSPrimitiveValue(CSSStyleDeclaration cSSStyleDeclaration, String string) {
        super(cSSStyleDeclaration, string);
    }

    protected CSSPrimitiveValue(CSSValue cSSValue) {
        super(cSSValue);
    }

    public short getCssValueType() {
        return 1;
    }

    public short getPrimitiveType() {
        return this.primitiveType;
    }

    public void setFloatValue(short s, float f) throws DOMException {
        if (s != this.primitiveType || !this.isFloatType(s)) {
            throw new NoModificationAllowedException("Can not set: " + f);
        }
        this.value = new Float(f);
        this.updateProperty();
    }

    public float getFloatValue(short s) throws DOMException {
        if (this.isFloatType(this.primitiveType)) {
            return ((Float)this.value).floatValue();
        }
        throw new InvalidAccessException("Not a Float value");
    }

    private boolean isFloatType(short s) {
        return s == 1 || s == 2 || s == 3 || s == 4 || s == 5 || s == 6 || s == 7 || s == 8 || s == 9 || s == 10 || s == 11 || s == 12 || s == 13 || s == 14 || s == 15 || s == 16 || s == 17 || s == 18;
    }

    public void setStringValue(short s, String string) throws DOMException {
        if (this.primitiveType != s || !this.isStringType(s)) {
            throw new NoModificationAllowedException("Can not set: " + string);
        }
        this.value = string;
        this.updateProperty();
    }

    public String getStringValue() throws DOMException {
        if (this.isStringType(this.primitiveType)) {
            return (String)this.value;
        }
        throw new InvalidAccessException("Not a String value");
    }

    private boolean isStringType(short s) {
        return 19 == s || 20 == s || 21 == s || 22 == s;
    }

    public Counter getCounterValue() throws DOMException {
        if (23 == this.primitiveType) {
            return (Counter)this.value;
        }
        throw new InvalidAccessException("Not a Counter value");
    }

    public org.w3c.dom.css.Rect getRectValue() throws DOMException {
        if (24 == this.primitiveType) {
            return (org.w3c.dom.css.Rect)this.value;
        }
        throw new InvalidAccessException("Not a Rect value");
    }

    public org.w3c.dom.css.RGBColor getRGBColorValue() throws DOMException {
        if (25 == this.primitiveType) {
            return (org.w3c.dom.css.RGBColor)this.value;
        }
        throw new InvalidAccessException("Not a RGBColor value");
    }

    public String toString() {
        if (this.isStringType(this.primitiveType)) {
            return (String)this.value;
        }
        if (this.isFloatType(this.primitiveType)) {
            String string = (String)CSSPrimitiveValue.getType2UnitMap().get(new Short(this.primitiveType));
            if (string == null) {
                return ((Float)this.value).toString();
            }
            return ((Float)this.value).toString() + string;
        }
        if (this.primitiveType == 24 || this.primitiveType == 25) {
            return this.value.toString();
        }
        if (this.primitiveType == 23) {
            // empty if block
        }
        return null;
    }

    protected boolean isSameType(CSSValue cSSValue) {
        return this.getCssValueType() == cSSValue.getCssValueType() && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == this.getPrimitiveType();
    }

    protected void copy(CSSValue cSSValue) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        this.value = cSSPrimitiveValue.value;
    }

    public static CSSPrimitiveValue newCSSPrimitiveValue(CSSStyleDeclaration cSSStyleDeclaration, String string, String string2) throws DOMException {
        CSSPrimitiveValue cSSPrimitiveValue = new CSSPrimitiveValue(cSSStyleDeclaration, string);
        return CSSPrimitiveValue.newCSSPrimitiveValue(cSSPrimitiveValue, string2);
    }

    public static CSSPrimitiveValue newCSSPrimitiveValue(CSSValue cSSValue, String string) throws DOMException {
        CSSPrimitiveValue cSSPrimitiveValue = new CSSPrimitiveValue(cSSValue);
        return CSSPrimitiveValue.newCSSPrimitiveValue(cSSPrimitiveValue, string);
    }

    private static CSSPrimitiveValue newCSSPrimitiveValue(CSSPrimitiveValue cSSPrimitiveValue, String string) throws DOMException {
        if (string.startsWith(COLOR) || string.startsWith(RGB)) {
            RGBColor rGBColor = RGBColor.newRGBColor(cSSPrimitiveValue, string);
            cSSPrimitiveValue.value = rGBColor;
            cSSPrimitiveValue.primitiveType = (short)25;
            return cSSPrimitiveValue;
        }
        if (string.startsWith(RECT)) {
            Rect rect = Rect.newRect(cSSPrimitiveValue, string);
            cSSPrimitiveValue.value = rect;
            cSSPrimitiveValue.primitiveType = (short)24;
            return cSSPrimitiveValue;
        }
        int n = CSSPrimitiveValue.splitCssText(string);
        if (n == -1) {
            throw new InvalidStateException("Invalid cssText: " + string);
        }
        if (n == 0) {
            cSSPrimitiveValue.value = string;
            cSSPrimitiveValue.primitiveType = (short)19;
            return cSSPrimitiveValue;
        }
        if (n == string.length()) {
            cSSPrimitiveValue.value = new Float(string);
            cSSPrimitiveValue.primitiveType = 1;
            return cSSPrimitiveValue;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        cSSPrimitiveValue.value = new Float(string2);
        Short s = (Short)CSSPrimitiveValue.getUnit2TypeMap().get(string3.toLowerCase());
        cSSPrimitiveValue.primitiveType = s == null ? (short)0 : s;
        return cSSPrimitiveValue;
    }

    private static int splitCssText(String string) {
        int n;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) continue;
            if (c != '.') break;
            if (bl) {
                return -1;
            }
            bl = true;
        }
        return n;
    }

    private static synchronized HashMap getUnit2TypeMap() {
        if (unit2Type == null) {
            unit2Type = new HashMap();
            unit2Type.put("%", new Short(2));
            unit2Type.put("ems", new Short(3));
            unit2Type.put("exs", new Short(4));
            unit2Type.put("px", new Short(5));
            unit2Type.put("cm", new Short(6));
            unit2Type.put("mm", new Short(7));
            unit2Type.put("in", new Short(8));
            unit2Type.put("pt", new Short(9));
            unit2Type.put("pc", new Short(10));
            unit2Type.put("deg", new Short(11));
            unit2Type.put("rad", new Short(12));
            unit2Type.put("grad", new Short(13));
            unit2Type.put("ms", new Short(14));
            unit2Type.put("s", new Short(15));
            unit2Type.put("hz", new Short(16));
            unit2Type.put("khz", new Short(17));
        }
        return unit2Type;
    }

    private static synchronized HashMap getType2UnitMap() {
        if (type2Unit == null) {
            type2Unit = new HashMap();
            type2Unit.put(new Short(2), "%");
            type2Unit.put(new Short(3), "ems");
            type2Unit.put(new Short(4), "exs");
            type2Unit.put(new Short(5), "px");
            type2Unit.put(new Short(6), "cm");
            type2Unit.put(new Short(7), "mm");
            type2Unit.put(new Short(8), "in");
            type2Unit.put(new Short(9), "pt");
            type2Unit.put(new Short(10), "pc");
            type2Unit.put(new Short(11), "deg");
            type2Unit.put(new Short(12), "rad");
            type2Unit.put(new Short(13), "grad");
            type2Unit.put(new Short(14), "ms");
            type2Unit.put(new Short(15), "s");
            type2Unit.put(new Short(16), "hz");
            type2Unit.put(new Short(17), "khz");
        }
        return type2Unit;
    }
}

