/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.jcore;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.tools.jcore.ClassFilter;
import sun.jvm.hotspot.tools.jcore.ClassWriter;

public class ClassDump
extends Tool {
    private ClassFilter classFilter;
    private String outputDirectory;

    public void run() {
        try {
            String filterClassName = System.getProperty("sun.jvm.hotspot.tools.jcore.filter");
            if (filterClassName != null) {
                try {
                    Class<?> filterClass = Class.forName(filterClassName);
                    this.classFilter = (ClassFilter)filterClass.newInstance();
                }
                catch (Exception exp) {
                    System.err.println("Warning: Can not create class filter!");
                }
            }
            this.outputDirectory = System.getProperty("sun.jvm.hotspot.tools.jcore.outputDir");
            if (this.outputDirectory == null) {
                this.outputDirectory = ".";
            }
            SystemDictionary dict = VM.getVM().getSystemDictionary();
            dict.classesDo(new SystemDictionary.ClassVisitor(){

                public void visit(Klass k) {
                    if (k instanceof InstanceKlass) {
                        ClassDump.this.dumpKlass((InstanceKlass)k);
                    }
                }
            });
        }
        catch (AddressException e) {
            System.err.println("Error accessing address 0x" + Long.toHexString(e.getAddress()));
            e.printStackTrace();
        }
    }

    public String getName() {
        return "jcore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpKlass(InstanceKlass kls) {
        if (this.classFilter != null && !this.classFilter.canInclude(kls)) {
            return;
        }
        String klassName = kls.getName().asString();
        klassName = klassName.replace('/', File.separatorChar);
        int index = klassName.lastIndexOf(File.separatorChar);
        File dir = null;
        if (index != -1) {
            String dirName = klassName.substring(0, index);
            dir = new File(this.outputDirectory, dirName);
        } else {
            dir = new File(this.outputDirectory);
        }
        dir.mkdirs();
        File f = new File(dir, klassName.substring(klassName.lastIndexOf(File.separatorChar) + 1) + ".class");
        try {
            f.createNewFile();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            try {
                ClassWriter cw = new ClassWriter(kls, os);
                cw.write();
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ClassDump cd = new ClassDump();
        cd.start(args);
        cd.stop();
    }
}

