/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import java.io.InputStream;

class SAJDIClassLoader
extends ClassLoader {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.jdi.SAJDIClassLoader.DEBUG") != null;
    private ClassLoader parent;

    SAJDIClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                if (name.startsWith("sun.jvm.hotspot.") && !name.startsWith("sun.jvm.hotspot.debugger.")) {
                    return this.loadSAJDIClass(name);
                }
                c = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name);
            }
        }
        return c;
    }

    private Class loadSAJDIClass(String name) throws ClassNotFoundException {
        if (DEBUG) {
            System.out.println("SA/JDI loader: about to load " + name);
        }
        byte[] b = null;
        try {
            byte[] tmp;
            InputStream in = this.getResourceAsStream(name.replace('.', '/') + ".class");
            b = new byte[1024];
            int total = 0;
            int len = 0;
            while ((len = in.read(b, total, b.length - total)) != -1) {
                if ((total += len) < b.length) continue;
                tmp = new byte[total * 2];
                System.arraycopy(b, 0, tmp, 0, total);
                b = tmp;
            }
            if (total != b.length) {
                tmp = new byte[total];
                System.arraycopy(b, 0, tmp, 0, total);
                b = tmp;
            }
        }
        catch (Exception exp) {
            throw (ClassNotFoundException)new ClassNotFoundException().initCause(exp);
        }
        return this.defineClass(name, b, 0, b.length);
    }
}

