/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.VMDeathRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.MirrorImpl;
import sun.jvm.hotspot.jdi.ThreadReferenceImpl;

class EventRequestManagerImpl
extends MirrorImpl
implements EventRequestManager {
    List[] requestLists;

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    EventRequestManagerImpl(VirtualMachine vm) {
        super(vm);
        int i;
        Field[] ekinds = EventKind.class.getDeclaredFields();
        int highest = 0;
        for (i = 0; i < ekinds.length; ++i) {
            int val;
            try {
                val = ekinds[i].getInt(null);
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc);
            }
            if (val <= highest) continue;
            highest = val;
        }
        this.requestLists = new List[highest + 1];
        for (i = 0; i <= highest; ++i) {
            this.requestLists[i] = new ArrayList();
        }
    }

    public ClassPrepareRequest createClassPrepareRequest() {
        return new ClassPrepareRequestImpl();
    }

    public ClassUnloadRequest createClassUnloadRequest() {
        return new ClassUnloadRequestImpl();
    }

    public ExceptionRequest createExceptionRequest(ReferenceType refType, boolean notifyCaught, boolean notifyUncaught) {
        return new ExceptionRequestImpl(refType, notifyCaught, notifyUncaught);
    }

    public StepRequest createStepRequest(ThreadReference thread, int size, int depth) {
        return new StepRequestImpl(thread, size, depth);
    }

    public ThreadDeathRequest createThreadDeathRequest() {
        return new ThreadDeathRequestImpl();
    }

    public ThreadStartRequest createThreadStartRequest() {
        return new ThreadStartRequestImpl();
    }

    public MethodEntryRequest createMethodEntryRequest() {
        return new MethodEntryRequestImpl();
    }

    public MethodExitRequest createMethodExitRequest() {
        return new MethodExitRequestImpl();
    }

    public BreakpointRequest createBreakpointRequest(Location location) {
        if (location.codeIndex() == -1L) {
            throw new NativeMethodException("Cannot set breakpoints on native methods");
        }
        return new BreakpointRequestImpl(location);
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(com.sun.jdi.Field field) {
        if (!this.vm.canWatchFieldAccess()) {
            throw new UnsupportedOperationException("target VM does not support access watchpoints");
        }
        return new AccessWatchpointRequestImpl(field);
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(com.sun.jdi.Field field) {
        if (!this.vm.canWatchFieldModification()) {
            throw new UnsupportedOperationException("target VM does not support modification watchpoints");
        }
        return new ModificationWatchpointRequestImpl(field);
    }

    public VMDeathRequest createVMDeathRequest() {
        if (!this.vm.canRequestVMDeathEvent()) {
            throw new UnsupportedOperationException("target VM does not support requesting VM death events");
        }
        return new VMDeathRequestImpl();
    }

    public void deleteEventRequest(EventRequest eventRequest) {
        ((EventRequestImpl)eventRequest).delete();
    }

    public void deleteEventRequests(List eventRequests) {
        Iterator iter = new ArrayList(eventRequests).iterator();
        while (iter.hasNext()) {
            ((EventRequestImpl)iter.next()).delete();
        }
    }

    public void deleteAllBreakpoints() {
        this.requestList(2).clear();
    }

    public List stepRequests() {
        return this.unmodifiableRequestList(1);
    }

    public List classPrepareRequests() {
        return this.unmodifiableRequestList(8);
    }

    public List classUnloadRequests() {
        return this.unmodifiableRequestList(9);
    }

    public List threadStartRequests() {
        return this.unmodifiableRequestList(6);
    }

    public List threadDeathRequests() {
        return this.unmodifiableRequestList(7);
    }

    public List exceptionRequests() {
        return this.unmodifiableRequestList(4);
    }

    public List breakpointRequests() {
        return this.unmodifiableRequestList(2);
    }

    public List accessWatchpointRequests() {
        return this.unmodifiableRequestList(20);
    }

    public List modificationWatchpointRequests() {
        return this.unmodifiableRequestList(21);
    }

    public List methodEntryRequests() {
        return this.unmodifiableRequestList(40);
    }

    public List methodExitRequests() {
        return this.unmodifiableRequestList(41);
    }

    public List vmDeathRequests() {
        return this.unmodifiableRequestList(99);
    }

    List unmodifiableRequestList(int eventCmd) {
        return Collections.unmodifiableList(this.requestList(eventCmd));
    }

    EventRequest request(int eventCmd, int requestId) {
        List rl = this.requestList(eventCmd);
        for (int i = rl.size() - 1; i >= 0; --i) {
            EventRequestImpl er = (EventRequestImpl)rl.get(i);
            if (er.id != requestId) continue;
            return er;
        }
        return null;
    }

    List requestList(int eventCmd) {
        return this.requestLists[eventCmd];
    }

    class VMDeathRequestImpl
    extends EventRequestImpl
    implements VMDeathRequest {
        VMDeathRequestImpl() {
        }

        int eventCmd() {
            return 99;
        }

        public String toString() {
            return "VM death request " + this.state();
        }
    }

    class ModificationWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements ModificationWatchpointRequest {
        ModificationWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
        }

        int eventCmd() {
            return 21;
        }

        public String toString() {
            return "modification watchpoint request " + this.field + this.state();
        }
    }

    class AccessWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements AccessWatchpointRequest {
        AccessWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
        }

        int eventCmd() {
            return 20;
        }

        public String toString() {
            return "access watchpoint request " + this.field + this.state();
        }
    }

    abstract class WatchpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements WatchpointRequest {
        final com.sun.jdi.Field field;

        WatchpointRequestImpl(com.sun.jdi.Field field) {
            this.field = field;
        }

        public com.sun.jdi.Field field() {
            return this.field;
        }
    }

    class ThreadStartRequestImpl
    extends ThreadVisibleEventRequestImpl
    implements ThreadStartRequest {
        ThreadStartRequestImpl() {
        }

        int eventCmd() {
            return 6;
        }

        public String toString() {
            return "thread start request " + this.state();
        }
    }

    class ThreadDeathRequestImpl
    extends ThreadVisibleEventRequestImpl
    implements ThreadDeathRequest {
        ThreadDeathRequestImpl() {
        }

        int eventCmd() {
            return 7;
        }

        public String toString() {
            return "thread death request " + this.state();
        }
    }

    class StepRequestImpl
    extends ClassVisibleEventRequestImpl
    implements StepRequest {
        ThreadReferenceImpl thread;
        int size;
        int depth;

        StepRequestImpl(ThreadReference thread, int size, int depth) {
            this.thread = (ThreadReferenceImpl)thread;
            this.size = size;
            this.depth = depth;
            List requests = EventRequestManagerImpl.this.stepRequests();
            Iterator iter = requests.iterator();
            while (iter.hasNext()) {
                StepRequest request = (StepRequest)iter.next();
                if (request == this || !request.isEnabled() || !request.thread().equals(thread)) continue;
                throw new DuplicateRequestException("Only one step request allowed per thread");
            }
        }

        public int depth() {
            return this.depth;
        }

        public int size() {
            return this.size;
        }

        public ThreadReference thread() {
            return this.thread;
        }

        int eventCmd() {
            return 1;
        }

        public String toString() {
            return "step request " + this.thread() + this.state();
        }
    }

    class MethodExitRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodExitRequest {
        MethodExitRequestImpl() {
        }

        int eventCmd() {
            return 41;
        }

        public String toString() {
            return "method exit request " + this.state();
        }
    }

    class MethodEntryRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodEntryRequest {
        MethodEntryRequestImpl() {
        }

        int eventCmd() {
            return 40;
        }

        public String toString() {
            return "method entry request " + this.state();
        }
    }

    class ExceptionRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ExceptionRequest {
        ReferenceType exception;
        boolean caught;
        boolean uncaught;

        ExceptionRequestImpl(ReferenceType refType, boolean notifyCaught, boolean notifyUncaught) {
            this.exception = null;
            this.caught = true;
            this.uncaught = true;
            this.exception = refType;
            this.caught = notifyCaught;
            this.uncaught = notifyUncaught;
        }

        public ReferenceType exception() {
            return this.exception;
        }

        public boolean notifyCaught() {
            return this.caught;
        }

        public boolean notifyUncaught() {
            return this.uncaught;
        }

        int eventCmd() {
            return 4;
        }

        public String toString() {
            return "exception request " + this.exception() + this.state();
        }
    }

    class ClassUnloadRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassUnloadRequest {
        ClassUnloadRequestImpl() {
        }

        int eventCmd() {
            return 9;
        }

        public String toString() {
            return "class unload request " + this.state();
        }
    }

    class ClassPrepareRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassPrepareRequest {
        ClassPrepareRequestImpl() {
        }

        int eventCmd() {
            return 8;
        }

        public String toString() {
            return "class prepare request " + this.state();
        }
    }

    class BreakpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements BreakpointRequest {
        private final Location location;

        BreakpointRequestImpl(Location location) {
            this.location = location;
        }

        public Location location() {
            return this.location;
        }

        int eventCmd() {
            return 2;
        }

        public String toString() {
            return "breakpoint request " + this.location() + this.state();
        }
    }

    abstract class ClassVisibleEventRequestImpl
    extends ThreadVisibleEventRequestImpl {
        ClassVisibleEventRequestImpl() {
        }

        public synchronized void addClassFilter(ReferenceType clazz) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
        }

        public synchronized void addClassFilter(String classPattern) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (classPattern == null) {
                throw new NullPointerException();
            }
        }

        public synchronized void addClassExclusionFilter(String classPattern) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (classPattern == null) {
                throw new NullPointerException();
            }
        }

        public synchronized void addInstanceFilter(ObjectReference instance) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (!this.vm.canUseInstanceFilters()) {
                throw new UnsupportedOperationException("target does not support instance filters");
            }
        }
    }

    abstract class ThreadVisibleEventRequestImpl
    extends EventRequestImpl {
        ThreadVisibleEventRequestImpl() {
        }

        public synchronized void addThreadFilter(ThreadReference thread) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
        }
    }

    abstract class EventRequestImpl
    extends MirrorImpl
    implements EventRequest {
        int id;
        List filters;
        boolean isEnabled;
        boolean deleted;
        int suspendPolicy;
        private Map clientProperties;

        EventRequestImpl() {
            super(EventRequestManagerImpl.this.vm);
            this.filters = new ArrayList();
            this.isEnabled = false;
            this.deleted = false;
            this.suspendPolicy = 0;
            this.clientProperties = null;
            this.requestList().add(this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        abstract int eventCmd();

        InvalidRequestStateException invalidState() {
            return new InvalidRequestStateException(this.toString());
        }

        String state() {
            return this.deleted ? " (deleted)" : (this.isEnabled() ? " (enabled)" : " (disabled)");
        }

        List requestList() {
            return EventRequestManagerImpl.this.requestList(this.eventCmd());
        }

        void delete() {
            if (!this.deleted) {
                this.requestList().remove(this);
                this.disable();
                this.deleted = true;
            }
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void enable() {
            this.setEnabled(true);
        }

        public void disable() {
            this.setEnabled(false);
        }

        public synchronized void setEnabled(boolean val) {
            if (this.deleted) {
                throw this.invalidState();
            }
            if (val != this.isEnabled) {
                if (this.isEnabled) {
                    this.clear();
                } else {
                    this.set();
                }
            }
        }

        public synchronized void addCountFilter(int count) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (count < 1) {
                throw new IllegalArgumentException("count is less than one");
            }
        }

        public void setSuspendPolicy(int policy) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.suspendPolicy = policy;
        }

        public int suspendPolicy() {
            return this.suspendPolicy;
        }

        synchronized void set() {
            this.isEnabled = true;
        }

        synchronized void clear() {
            this.isEnabled = false;
        }

        private Map getProperties() {
            if (this.clientProperties == null) {
                this.clientProperties = new HashMap(2);
            }
            return this.clientProperties;
        }

        public final Object getProperty(Object key) {
            if (this.clientProperties == null) {
                return null;
            }
            return this.getProperties().get(key);
        }

        public final void putProperty(Object key, Object value) {
            if (value != null) {
                this.getProperties().put(key, value);
            } else {
                this.getProperties().remove(key);
            }
        }
    }

    static class EventKind {
        static final int VM_DISCONNECTED = 100;
        static final int VM_START = 90;
        static final int THREAD_DEATH = 7;
        static final int SINGLE_STEP = 1;
        static final int BREAKPOINT = 2;
        static final int FRAME_POP = 3;
        static final int EXCEPTION = 4;
        static final int USER_DEFINED = 5;
        static final int THREAD_START = 6;
        static final int THREAD_END = 7;
        static final int CLASS_PREPARE = 8;
        static final int CLASS_UNLOAD = 9;
        static final int CLASS_LOAD = 10;
        static final int FIELD_ACCESS = 20;
        static final int FIELD_MODIFICATION = 21;
        static final int EXCEPTION_CATCH = 30;
        static final int METHOD_ENTRY = 40;
        static final int METHOD_EXIT = 41;
        static final int VM_INIT = 90;
        static final int VM_DEATH = 99;

        EventKind() {
        }
    }
}

