/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.Bits;

public class Bytecodes {
    public static final int _illegal = -1;
    public static final int _nop = 0;
    public static final int _aconst_null = 1;
    public static final int _iconst_m1 = 2;
    public static final int _iconst_0 = 3;
    public static final int _iconst_1 = 4;
    public static final int _iconst_2 = 5;
    public static final int _iconst_3 = 6;
    public static final int _iconst_4 = 7;
    public static final int _iconst_5 = 8;
    public static final int _lconst_0 = 9;
    public static final int _lconst_1 = 10;
    public static final int _fconst_0 = 11;
    public static final int _fconst_1 = 12;
    public static final int _fconst_2 = 13;
    public static final int _dconst_0 = 14;
    public static final int _dconst_1 = 15;
    public static final int _bipush = 16;
    public static final int _sipush = 17;
    public static final int _ldc = 18;
    public static final int _ldc_w = 19;
    public static final int _ldc2_w = 20;
    public static final int _iload = 21;
    public static final int _lload = 22;
    public static final int _fload = 23;
    public static final int _dload = 24;
    public static final int _aload = 25;
    public static final int _iload_0 = 26;
    public static final int _iload_1 = 27;
    public static final int _iload_2 = 28;
    public static final int _iload_3 = 29;
    public static final int _lload_0 = 30;
    public static final int _lload_1 = 31;
    public static final int _lload_2 = 32;
    public static final int _lload_3 = 33;
    public static final int _fload_0 = 34;
    public static final int _fload_1 = 35;
    public static final int _fload_2 = 36;
    public static final int _fload_3 = 37;
    public static final int _dload_0 = 38;
    public static final int _dload_1 = 39;
    public static final int _dload_2 = 40;
    public static final int _dload_3 = 41;
    public static final int _aload_0 = 42;
    public static final int _aload_1 = 43;
    public static final int _aload_2 = 44;
    public static final int _aload_3 = 45;
    public static final int _iaload = 46;
    public static final int _laload = 47;
    public static final int _faload = 48;
    public static final int _daload = 49;
    public static final int _aaload = 50;
    public static final int _baload = 51;
    public static final int _caload = 52;
    public static final int _saload = 53;
    public static final int _istore = 54;
    public static final int _lstore = 55;
    public static final int _fstore = 56;
    public static final int _dstore = 57;
    public static final int _astore = 58;
    public static final int _istore_0 = 59;
    public static final int _istore_1 = 60;
    public static final int _istore_2 = 61;
    public static final int _istore_3 = 62;
    public static final int _lstore_0 = 63;
    public static final int _lstore_1 = 64;
    public static final int _lstore_2 = 65;
    public static final int _lstore_3 = 66;
    public static final int _fstore_0 = 67;
    public static final int _fstore_1 = 68;
    public static final int _fstore_2 = 69;
    public static final int _fstore_3 = 70;
    public static final int _dstore_0 = 71;
    public static final int _dstore_1 = 72;
    public static final int _dstore_2 = 73;
    public static final int _dstore_3 = 74;
    public static final int _astore_0 = 75;
    public static final int _astore_1 = 76;
    public static final int _astore_2 = 77;
    public static final int _astore_3 = 78;
    public static final int _iastore = 79;
    public static final int _lastore = 80;
    public static final int _fastore = 81;
    public static final int _dastore = 82;
    public static final int _aastore = 83;
    public static final int _bastore = 84;
    public static final int _castore = 85;
    public static final int _sastore = 86;
    public static final int _pop = 87;
    public static final int _pop2 = 88;
    public static final int _dup = 89;
    public static final int _dup_x1 = 90;
    public static final int _dup_x2 = 91;
    public static final int _dup2 = 92;
    public static final int _dup2_x1 = 93;
    public static final int _dup2_x2 = 94;
    public static final int _swap = 95;
    public static final int _iadd = 96;
    public static final int _ladd = 97;
    public static final int _fadd = 98;
    public static final int _dadd = 99;
    public static final int _isub = 100;
    public static final int _lsub = 101;
    public static final int _fsub = 102;
    public static final int _dsub = 103;
    public static final int _imul = 104;
    public static final int _lmul = 105;
    public static final int _fmul = 106;
    public static final int _dmul = 107;
    public static final int _idiv = 108;
    public static final int _ldiv = 109;
    public static final int _fdiv = 110;
    public static final int _ddiv = 111;
    public static final int _irem = 112;
    public static final int _lrem = 113;
    public static final int _frem = 114;
    public static final int _drem = 115;
    public static final int _ineg = 116;
    public static final int _lneg = 117;
    public static final int _fneg = 118;
    public static final int _dneg = 119;
    public static final int _ishl = 120;
    public static final int _lshl = 121;
    public static final int _ishr = 122;
    public static final int _lshr = 123;
    public static final int _iushr = 124;
    public static final int _lushr = 125;
    public static final int _iand = 126;
    public static final int _land = 127;
    public static final int _ior = 128;
    public static final int _lor = 129;
    public static final int _ixor = 130;
    public static final int _lxor = 131;
    public static final int _iinc = 132;
    public static final int _i2l = 133;
    public static final int _i2f = 134;
    public static final int _i2d = 135;
    public static final int _l2i = 136;
    public static final int _l2f = 137;
    public static final int _l2d = 138;
    public static final int _f2i = 139;
    public static final int _f2l = 140;
    public static final int _f2d = 141;
    public static final int _d2i = 142;
    public static final int _d2l = 143;
    public static final int _d2f = 144;
    public static final int _i2b = 145;
    public static final int _i2c = 146;
    public static final int _i2s = 147;
    public static final int _lcmp = 148;
    public static final int _fcmpl = 149;
    public static final int _fcmpg = 150;
    public static final int _dcmpl = 151;
    public static final int _dcmpg = 152;
    public static final int _ifeq = 153;
    public static final int _ifne = 154;
    public static final int _iflt = 155;
    public static final int _ifge = 156;
    public static final int _ifgt = 157;
    public static final int _ifle = 158;
    public static final int _if_icmpeq = 159;
    public static final int _if_icmpne = 160;
    public static final int _if_icmplt = 161;
    public static final int _if_icmpge = 162;
    public static final int _if_icmpgt = 163;
    public static final int _if_icmple = 164;
    public static final int _if_acmpeq = 165;
    public static final int _if_acmpne = 166;
    public static final int _goto = 167;
    public static final int _jsr = 168;
    public static final int _ret = 169;
    public static final int _tableswitch = 170;
    public static final int _lookupswitch = 171;
    public static final int _ireturn = 172;
    public static final int _lreturn = 173;
    public static final int _freturn = 174;
    public static final int _dreturn = 175;
    public static final int _areturn = 176;
    public static final int _return = 177;
    public static final int _getstatic = 178;
    public static final int _putstatic = 179;
    public static final int _getfield = 180;
    public static final int _putfield = 181;
    public static final int _invokevirtual = 182;
    public static final int _invokespecial = 183;
    public static final int _invokestatic = 184;
    public static final int _invokeinterface = 185;
    public static final int _xxxunusedxxx = 186;
    public static final int _new = 187;
    public static final int _newarray = 188;
    public static final int _anewarray = 189;
    public static final int _arraylength = 190;
    public static final int _athrow = 191;
    public static final int _checkcast = 192;
    public static final int _instanceof = 193;
    public static final int _monitorenter = 194;
    public static final int _monitorexit = 195;
    public static final int _wide = 196;
    public static final int _multianewarray = 197;
    public static final int _ifnull = 198;
    public static final int _ifnonnull = 199;
    public static final int _goto_w = 200;
    public static final int _jsr_w = 201;
    public static final int _breakpoint = 202;
    public static final int number_of_java_codes = 203;
    public static final int _fast_agetfield = 203;
    public static final int _fast_bgetfield = 204;
    public static final int _fast_cgetfield = 205;
    public static final int _fast_dgetfield = 206;
    public static final int _fast_fgetfield = 207;
    public static final int _fast_igetfield = 208;
    public static final int _fast_lgetfield = 209;
    public static final int _fast_sgetfield = 210;
    public static final int _fast_aputfield = 211;
    public static final int _fast_bputfield = 212;
    public static final int _fast_cputfield = 213;
    public static final int _fast_dputfield = 214;
    public static final int _fast_fputfield = 215;
    public static final int _fast_iputfield = 216;
    public static final int _fast_lputfield = 217;
    public static final int _fast_sputfield = 218;
    public static final int _fast_aload_0 = 219;
    public static final int _fast_iaccess_0 = 220;
    public static final int _fast_aaccess_0 = 221;
    public static final int _fast_faccess_0 = 222;
    public static final int _fast_iload = 223;
    public static final int _fast_iload2 = 224;
    public static final int _fast_icaload = 225;
    public static final int _fast_invokevfinal = 226;
    public static final int _fast_linearswitch = 227;
    public static final int _fast_binaryswitch = 228;
    public static final int _shouldnotreachhere = 229;
    public static final int number_of_codes = 230;
    private static String[] _name = new String[230];
    private static String[] _format = new String[230];
    private static String[] _wide_format = new String[230];
    private static int[] _result_type = new int[230];
    private static byte[] _depth = new byte[230];
    private static byte[] _length = new byte[230];
    private static boolean[] _can_trap = new boolean[230];
    private static boolean[] _safepoint_safe = new boolean[230];
    private static int[] _java_code = new int[230];
    private static boolean[] _can_rewrite = new boolean[230];
    private static final int jintSize = 4;

    public static int specialLengthAt(Method method, int bci) {
        int code = Bytecodes.codeAt(method, bci);
        switch (code) {
            case 196: {
                return Bytecodes.wideLengthFor(method.getBytecodeOrBPAt(bci + 1));
            }
            case 170: {
                int alignedBCI = Bits.roundTo(bci + 1, 4);
                int lo = method.getBytecodeIntArg(alignedBCI + 4);
                int hi = method.getBytecodeIntArg(alignedBCI + 8);
                return alignedBCI - bci + (3 + hi - lo + 1) * 4;
            }
            case 171: 
            case 227: 
            case 228: {
                int alignedBCI = Bits.roundTo(bci + 1, 4);
                int npairs = method.getBytecodeIntArg(alignedBCI + 4);
                return alignedBCI - bci + (2 + 2 * npairs) * 4;
            }
        }
        throw new RuntimeException("should not reach here");
    }

    public static void check(int code) {
        Assert.that(Bytecodes.isDefined(code), "illegal code " + code);
    }

    public static void wideCheck(int code) {
        Assert.that(Bytecodes.wideIsDefined(code), "illegal code " + code);
    }

    public static int codeAt(Method method, int bci) {
        int res = Bytecodes.codeOrBPAt(method, bci);
        if (res == 202) {
            res = method.getOrigBytecodeAt(bci);
        }
        return res;
    }

    public static int codeOrBPAt(Method method, int bci) {
        return method.getBytecodeOrBPAt(bci);
    }

    public static boolean isActiveBreakpointAt(Method method, int bci) {
        return Bytecodes.codeOrBPAt(method, bci) == 202;
    }

    public static boolean isDefined(int code) {
        return 0 <= code && code < 230 && _format[code] != null;
    }

    public static boolean wideIsDefined(int code) {
        return Bytecodes.isDefined(code) && _wide_format[code] != null;
    }

    public static String name(int code) {
        Bytecodes.check(code);
        return _name[code];
    }

    public static String format(int code) {
        Bytecodes.check(code);
        return _format[code];
    }

    public static String wideFormat(int code) {
        Bytecodes.wideCheck(code);
        return _wide_format[code];
    }

    public static int resultType(int code) {
        Bytecodes.check(code);
        return _result_type[code];
    }

    public static int depth(int code) {
        Bytecodes.check(code);
        return _depth[code];
    }

    public static int lengthFor(int code) {
        Bytecodes.check(code);
        return _length[code];
    }

    public static boolean canTrap(int code) {
        Bytecodes.check(code);
        return _can_trap[code];
    }

    public static boolean safepointSafe(int code) {
        Bytecodes.check(code);
        return _safepoint_safe[code];
    }

    public static int javaCode(int code) {
        Bytecodes.check(code);
        return _java_code[code];
    }

    public static boolean canRewrite(int code) {
        Bytecodes.check(code);
        return _can_rewrite[code];
    }

    public static int wideLengthFor(int code) {
        Bytecodes.wideCheck(code);
        return Bytecodes.wideFormat(code).length();
    }

    public static int lengthAt(Method method, int bci) {
        int l = Bytecodes.lengthFor(Bytecodes.codeAt(method, bci));
        return l > 0 ? l : Bytecodes.specialLengthAt(method, bci);
    }

    public static int javaLengthAt(Method method, int bci) {
        int l = Bytecodes.lengthFor(Bytecodes.javaCode(Bytecodes.codeAt(method, bci)));
        return l > 0 ? l : Bytecodes.specialLengthAt(method, bci);
    }

    public static boolean isJavaCode(int code) {
        return 0 <= code && code < 203;
    }

    public static boolean isFastCode(int code) {
        return 203 <= code && code < 230;
    }

    public static boolean isAload(int code) {
        return code == 25 || code == 42 || code == 43 || code == 44 || code == 45;
    }

    public static boolean isAstore(int code) {
        return code == 58 || code == 75 || code == 76 || code == 77 || code == 78;
    }

    public static boolean isZeroConst(int code) {
        return code == 1 || code == 3 || code == 11 || code == 14;
    }

    private static void initialize() {
        Assert.that(true, "too many bytecodes");
        Bytecodes.def(0, "nop", "b", null, BasicType.getTVoid(), 0, false);
        Bytecodes.def(1, "aconst_null", "b", null, BasicType.getTObject(), 1, false);
        Bytecodes.def(2, "iconst_m1", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(3, "iconst_0", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(4, "iconst_1", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(5, "iconst_2", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(6, "iconst_3", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(7, "iconst_4", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(8, "iconst_5", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(9, "lconst_0", "b", null, BasicType.getTLong(), 2, false);
        Bytecodes.def(10, "lconst_1", "b", null, BasicType.getTLong(), 2, false);
        Bytecodes.def(11, "fconst_0", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(12, "fconst_1", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(13, "fconst_2", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(14, "dconst_0", "b", null, BasicType.getTDouble(), 2, false);
        Bytecodes.def(15, "dconst_1", "b", null, BasicType.getTDouble(), 2, false);
        Bytecodes.def(16, "bipush", "bc", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(17, "sipush", "bcc", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(18, "ldc", "bi", null, BasicType.getTIllegal(), 1, true);
        Bytecodes.def(19, "ldc_w", "bii", null, BasicType.getTIllegal(), 1, true);
        Bytecodes.def(20, "ldc2_w", "bii", null, BasicType.getTIllegal(), 2, true);
        Bytecodes.def(21, "iload", "bi", "wbii", BasicType.getTInt(), 1, false);
        Bytecodes.def(22, "lload", "bi", "wbii", BasicType.getTLong(), 2, false);
        Bytecodes.def(23, "fload", "bi", "wbii", BasicType.getTFloat(), 1, false);
        Bytecodes.def(24, "dload", "bi", "wbii", BasicType.getTDouble(), 2, false);
        Bytecodes.def(25, "aload", "bi", "wbii", BasicType.getTObject(), 1, false);
        Bytecodes.def(26, "iload_0", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(27, "iload_1", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(28, "iload_2", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(29, "iload_3", "b", null, BasicType.getTInt(), 1, false);
        Bytecodes.def(30, "lload_0", "b", null, BasicType.getTLong(), 2, false);
        Bytecodes.def(31, "lload_1", "b", null, BasicType.getTLong(), 2, false);
        Bytecodes.def(32, "lload_2", "b", null, BasicType.getTLong(), 2, false);
        Bytecodes.def(33, "lload_3", "b", null, BasicType.getTLong(), 2, false);
        Bytecodes.def(34, "fload_0", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(35, "fload_1", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(36, "fload_2", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(37, "fload_3", "b", null, BasicType.getTFloat(), 1, false);
        Bytecodes.def(38, "dload_0", "b", null, BasicType.getTDouble(), 2, false);
        Bytecodes.def(39, "dload_1", "b", null, BasicType.getTDouble(), 2, false);
        Bytecodes.def(40, "dload_2", "b", null, BasicType.getTDouble(), 2, false);
        Bytecodes.def(41, "dload_3", "b", null, BasicType.getTDouble(), 2, false);
        Bytecodes.def(42, "aload_0", "b", null, BasicType.getTObject(), 1, true);
        Bytecodes.def(43, "aload_1", "b", null, BasicType.getTObject(), 1, false);
        Bytecodes.def(44, "aload_2", "b", null, BasicType.getTObject(), 1, false);
        Bytecodes.def(45, "aload_3", "b", null, BasicType.getTObject(), 1, false);
        Bytecodes.def(46, "iaload", "b", null, BasicType.getTInt(), -1, true);
        Bytecodes.def(47, "laload", "b", null, BasicType.getTLong(), 0, true);
        Bytecodes.def(48, "faload", "b", null, BasicType.getTFloat(), -1, true);
        Bytecodes.def(49, "daload", "b", null, BasicType.getTDouble(), 0, true);
        Bytecodes.def(50, "aaload", "b", null, BasicType.getTObject(), -1, true);
        Bytecodes.def(51, "baload", "b", null, BasicType.getTInt(), -1, true);
        Bytecodes.def(52, "caload", "b", null, BasicType.getTInt(), -1, true);
        Bytecodes.def(53, "saload", "b", null, BasicType.getTInt(), -1, true);
        Bytecodes.def(54, "istore", "bi", "wbii", BasicType.getTVoid(), -1, false);
        Bytecodes.def(55, "lstore", "bi", "wbii", BasicType.getTVoid(), -2, false);
        Bytecodes.def(56, "fstore", "bi", "wbii", BasicType.getTVoid(), -1, false);
        Bytecodes.def(57, "dstore", "bi", "wbii", BasicType.getTVoid(), -2, false);
        Bytecodes.def(58, "astore", "bi", "wbii", BasicType.getTVoid(), -1, false);
        Bytecodes.def(59, "istore_0", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(60, "istore_1", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(61, "istore_2", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(62, "istore_3", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(63, "lstore_0", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(64, "lstore_1", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(65, "lstore_2", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(66, "lstore_3", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(67, "fstore_0", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(68, "fstore_1", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(69, "fstore_2", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(70, "fstore_3", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(71, "dstore_0", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(72, "dstore_1", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(73, "dstore_2", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(74, "dstore_3", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(75, "astore_0", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(76, "astore_1", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(77, "astore_2", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(78, "astore_3", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(79, "iastore", "b", null, BasicType.getTVoid(), -3, true);
        Bytecodes.def(80, "lastore", "b", null, BasicType.getTVoid(), -4, true);
        Bytecodes.def(81, "fastore", "b", null, BasicType.getTVoid(), -3, true);
        Bytecodes.def(82, "dastore", "b", null, BasicType.getTVoid(), -4, true);
        Bytecodes.def(83, "aastore", "b", null, BasicType.getTVoid(), -3, true);
        Bytecodes.def(84, "bastore", "b", null, BasicType.getTVoid(), -3, true);
        Bytecodes.def(85, "castore", "b", null, BasicType.getTVoid(), -3, true);
        Bytecodes.def(86, "sastore", "b", null, BasicType.getTVoid(), -3, true);
        Bytecodes.def(87, "pop", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(88, "pop2", "b", null, BasicType.getTVoid(), -2, false);
        Bytecodes.def(89, "dup", "b", null, BasicType.getTVoid(), 1, false);
        Bytecodes.def(90, "dup_x1", "b", null, BasicType.getTVoid(), 1, false);
        Bytecodes.def(91, "dup_x2", "b", null, BasicType.getTVoid(), 1, false);
        Bytecodes.def(92, "dup2", "b", null, BasicType.getTVoid(), 2, false);
        Bytecodes.def(93, "dup2_x1", "b", null, BasicType.getTVoid(), 2, false);
        Bytecodes.def(94, "dup2_x2", "b", null, BasicType.getTVoid(), 2, false);
        Bytecodes.def(95, "swap", "b", null, BasicType.getTVoid(), 0, false);
        Bytecodes.def(96, "iadd", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(97, "ladd", "b", null, BasicType.getTLong(), -2, false);
        Bytecodes.def(98, "fadd", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(99, "dadd", "b", null, BasicType.getTDouble(), -2, false);
        Bytecodes.def(100, "isub", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(101, "lsub", "b", null, BasicType.getTLong(), -2, false);
        Bytecodes.def(102, "fsub", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(103, "dsub", "b", null, BasicType.getTDouble(), -2, false);
        Bytecodes.def(104, "imul", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(105, "lmul", "b", null, BasicType.getTLong(), -2, false);
        Bytecodes.def(106, "fmul", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(107, "dmul", "b", null, BasicType.getTDouble(), -2, false);
        Bytecodes.def(108, "idiv", "b", null, BasicType.getTInt(), -1, true);
        Bytecodes.def(109, "ldiv", "b", null, BasicType.getTLong(), -2, true);
        Bytecodes.def(110, "fdiv", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(111, "ddiv", "b", null, BasicType.getTDouble(), -2, false);
        Bytecodes.def(112, "irem", "b", null, BasicType.getTInt(), -1, true);
        Bytecodes.def(113, "lrem", "b", null, BasicType.getTLong(), -2, true);
        Bytecodes.def(114, "frem", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(115, "drem", "b", null, BasicType.getTDouble(), -2, false);
        Bytecodes.def(116, "ineg", "b", null, BasicType.getTInt(), 0, false);
        Bytecodes.def(117, "lneg", "b", null, BasicType.getTLong(), 0, false);
        Bytecodes.def(118, "fneg", "b", null, BasicType.getTFloat(), 0, false);
        Bytecodes.def(119, "dneg", "b", null, BasicType.getTDouble(), 0, false);
        Bytecodes.def(120, "ishl", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(121, "lshl", "b", null, BasicType.getTLong(), -1, false);
        Bytecodes.def(122, "ishr", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(123, "lshr", "b", null, BasicType.getTLong(), -1, false);
        Bytecodes.def(124, "iushr", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(125, "lushr", "b", null, BasicType.getTLong(), -1, false);
        Bytecodes.def(126, "iand", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(127, "land", "b", null, BasicType.getTLong(), -2, false);
        Bytecodes.def(128, "ior", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(129, "lor", "b", null, BasicType.getTLong(), -2, false);
        Bytecodes.def(130, "ixor", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(131, "lxor", "b", null, BasicType.getTLong(), -2, false);
        Bytecodes.def(132, "iinc", "bic", "wbiicc", BasicType.getTVoid(), 0, false);
        Bytecodes.def(133, "i2l", "b", null, BasicType.getTLong(), 1, false);
        Bytecodes.def(134, "i2f", "b", null, BasicType.getTFloat(), 0, false);
        Bytecodes.def(135, "i2d", "b", null, BasicType.getTDouble(), 1, false);
        Bytecodes.def(136, "l2i", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(137, "l2f", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(138, "l2d", "b", null, BasicType.getTDouble(), 0, false);
        Bytecodes.def(139, "f2i", "b", null, BasicType.getTInt(), 0, false);
        Bytecodes.def(140, "f2l", "b", null, BasicType.getTLong(), 1, false);
        Bytecodes.def(141, "f2d", "b", null, BasicType.getTDouble(), 1, false);
        Bytecodes.def(142, "d2i", "b", null, BasicType.getTInt(), -1, false);
        Bytecodes.def(143, "d2l", "b", null, BasicType.getTLong(), 0, false);
        Bytecodes.def(144, "d2f", "b", null, BasicType.getTFloat(), -1, false);
        Bytecodes.def(145, "i2b", "b", null, BasicType.getTByte(), 0, false);
        Bytecodes.def(146, "i2c", "b", null, BasicType.getTChar(), 0, false);
        Bytecodes.def(147, "i2s", "b", null, BasicType.getTShort(), 0, false);
        Bytecodes.def(148, "lcmp", "b", null, BasicType.getTVoid(), -3, false);
        Bytecodes.def(149, "fcmpl", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(150, "fcmpg", "b", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(151, "dcmpl", "b", null, BasicType.getTVoid(), -3, false);
        Bytecodes.def(152, "dcmpg", "b", null, BasicType.getTVoid(), -3, false);
        Bytecodes.def(153, "ifeq", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(154, "ifne", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(155, "iflt", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(156, "ifge", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(157, "ifgt", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(158, "ifle", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(159, "if_icmpeq", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(160, "if_icmpne", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(161, "if_icmplt", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(162, "if_icmpge", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(163, "if_icmpgt", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(164, "if_icmple", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(165, "if_acmpeq", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(166, "if_acmpne", "boo", null, BasicType.getTVoid(), -2, false, false);
        Bytecodes.def(167, "goto", "boo", null, BasicType.getTVoid(), 0, false, false);
        Bytecodes.def(168, "jsr", "boo", null, BasicType.getTInt(), 0, false);
        Bytecodes.def(169, "ret", "bi", "wbii", BasicType.getTVoid(), 0, false);
        Bytecodes.def(170, "tableswitch", "", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(171, "lookupswitch", "", null, BasicType.getTVoid(), -1, false);
        Bytecodes.def(172, "ireturn", "b", null, BasicType.getTInt(), -1, true, false);
        Bytecodes.def(173, "lreturn", "b", null, BasicType.getTLong(), -2, true, false);
        Bytecodes.def(174, "freturn", "b", null, BasicType.getTFloat(), -1, true, false);
        Bytecodes.def(175, "dreturn", "b", null, BasicType.getTDouble(), -2, true, false);
        Bytecodes.def(176, "areturn", "b", null, BasicType.getTObject(), -1, true, false);
        Bytecodes.def(177, "return", "b", null, BasicType.getTVoid(), 0, true, false);
        Bytecodes.def(178, "getstatic", "bjj", null, BasicType.getTIllegal(), 1, true);
        Bytecodes.def(179, "putstatic", "bjj", null, BasicType.getTIllegal(), -1, true);
        Bytecodes.def(180, "getfield", "bjj", null, BasicType.getTIllegal(), 0, true);
        Bytecodes.def(181, "putfield", "bjj", null, BasicType.getTIllegal(), -2, true);
        Bytecodes.def(182, "invokevirtual", "bjj", null, BasicType.getTIllegal(), -1, true);
        Bytecodes.def(183, "invokespecial", "bjj", null, BasicType.getTIllegal(), -1, true);
        Bytecodes.def(184, "invokestatic", "bjj", null, BasicType.getTIllegal(), 0, true);
        Bytecodes.def(185, "invokeinterface", "bjj__", null, BasicType.getTIllegal(), -1, true);
        Bytecodes.def(186, "xxxunusedxxx", null, null, BasicType.getTVoid(), 0, false);
        Bytecodes.def(187, "new", "bii", null, BasicType.getTObject(), 1, true);
        Bytecodes.def(188, "newarray", "bc", null, BasicType.getTObject(), 0, true);
        Bytecodes.def(189, "anewarray", "bii", null, BasicType.getTObject(), 0, true);
        Bytecodes.def(190, "arraylength", "b", null, BasicType.getTVoid(), 0, true);
        Bytecodes.def(191, "athrow", "b", null, BasicType.getTVoid(), -1, true);
        Bytecodes.def(192, "checkcast", "bii", null, BasicType.getTObject(), 0, true);
        Bytecodes.def(193, "instanceof", "bii", null, BasicType.getTInt(), 0, true);
        Bytecodes.def(194, "monitorenter", "b", null, BasicType.getTVoid(), -1, true);
        Bytecodes.def(195, "monitorexit", "b", null, BasicType.getTVoid(), -1, true);
        Bytecodes.def(196, "wide", "", null, BasicType.getTVoid(), 0, false);
        Bytecodes.def(197, "multianewarray", "biic", null, BasicType.getTObject(), 1, true);
        Bytecodes.def(198, "ifnull", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(199, "ifnonnull", "boo", null, BasicType.getTVoid(), -1, false, false);
        Bytecodes.def(200, "goto_w", "boooo", null, BasicType.getTVoid(), 0, false, false);
        Bytecodes.def(201, "jsr_w", "boooo", null, BasicType.getTInt(), 0, false);
        Bytecodes.def(202, "breakpoint", "", null, BasicType.getTVoid(), 0, true, true);
        Bytecodes.def(203, "fast_agetfield", "bjj", null, BasicType.getTObject(), 0, true, 180);
        Bytecodes.def(204, "fast_bgetfield", "bjj", null, BasicType.getTInt(), 0, true, 180);
        Bytecodes.def(205, "fast_cgetfield", "bjj", null, BasicType.getTChar(), 0, true, 180);
        Bytecodes.def(206, "fast_dgetfield", "bjj", null, BasicType.getTDouble(), 0, true, 180);
        Bytecodes.def(207, "fast_fgetfield", "bjj", null, BasicType.getTFloat(), 0, true, 180);
        Bytecodes.def(208, "fast_igetfield", "bjj", null, BasicType.getTInt(), 0, true, 180);
        Bytecodes.def(209, "fast_lgetfield", "bjj", null, BasicType.getTLong(), 0, true, 180);
        Bytecodes.def(210, "fast_sgetfield", "bjj", null, BasicType.getTShort(), 0, true, 180);
        Bytecodes.def(211, "fast_aputfield", "bjj", null, BasicType.getTObject(), 0, true, 181);
        Bytecodes.def(212, "fast_bputfield", "bjj", null, BasicType.getTInt(), 0, true, 181);
        Bytecodes.def(213, "fast_cputfield", "bjj", null, BasicType.getTChar(), 0, true, 181);
        Bytecodes.def(214, "fast_dputfield", "bjj", null, BasicType.getTDouble(), 0, true, 181);
        Bytecodes.def(215, "fast_fputfield", "bjj", null, BasicType.getTFloat(), 0, true, 181);
        Bytecodes.def(216, "fast_iputfield", "bjj", null, BasicType.getTInt(), 0, true, 181);
        Bytecodes.def(217, "fast_lputfield", "bjj", null, BasicType.getTLong(), 0, true, 181);
        Bytecodes.def(218, "fast_sputfield", "bjj", null, BasicType.getTShort(), 0, true, 181);
        Bytecodes.def(219, "fast_aload_0", "b", null, BasicType.getTObject(), 1, true, 42);
        Bytecodes.def(220, "fast_iaccess_0", "b_jj", null, BasicType.getTInt(), 1, true, 42);
        Bytecodes.def(221, "fast_aaccess_0", "b_jj", null, BasicType.getTObject(), 1, true, 42);
        Bytecodes.def(222, "fast_faccess_0", "b_jj", null, BasicType.getTObject(), 1, true, 42);
        Bytecodes.def(223, "fast_iload", "bi", null, BasicType.getTInt(), 1, false, 21);
        Bytecodes.def(224, "fast_iload2", "bi_i", null, BasicType.getTInt(), 2, false, 21);
        Bytecodes.def(225, "fast_icaload", "bi_", null, BasicType.getTInt(), 0, false, 21);
        Bytecodes.def(226, "fast_invokevfinal", "bjj", null, BasicType.getTIllegal(), -1, true, 182, false);
        Bytecodes.def(227, "fast_linearswitch", "", null, BasicType.getTVoid(), -1, false, 171);
        Bytecodes.def(228, "fast_binaryswitch", "", null, BasicType.getTVoid(), -1, false, 171);
        Bytecodes.def(229, "_shouldnotreachhere", "b", null, BasicType.getTVoid(), 0, false);
        for (int i = 0; i < 230; ++i) {
            if (!Bytecodes.isDefined(i)) continue;
            int j = Bytecodes.javaCode(i);
            if (!Bytecodes.canTrap(i) || Bytecodes.canTrap(j)) continue;
            Assert.that(false, Bytecodes.name(i) + " can trap => " + Bytecodes.name(j) + " can trap, too");
        }
    }

    private static void def(int code, String name, String format, String wide_format, int result_type, int depth, boolean can_trap) {
        Bytecodes.def(code, name, format, wide_format, result_type, depth, can_trap, true);
    }

    private static void def(int code, String name, String format, String wide_format, int result_type, int depth, boolean can_trap, boolean safepoint_safe) {
        Bytecodes.def(code, name, format, wide_format, result_type, depth, can_trap, code, safepoint_safe);
    }

    private static void def(int code, String name, String format, String wide_format, int result_type, int depth, boolean can_trap, int java_code) {
        Bytecodes.def(code, name, format, wide_format, result_type, depth, can_trap, java_code, true);
    }

    private static void def(int code, String name, String format, String wide_format, int result_type, int depth, boolean can_trap, int java_code, boolean safepoint_safe) {
        Assert.that(wide_format == null || format != null, "short form must exist if there's a wide form");
        Bytecodes._name[code] = name;
        Bytecodes._format[code] = format;
        Bytecodes._wide_format[code] = wide_format;
        Bytecodes._result_type[code] = result_type;
        Bytecodes._depth[code] = (byte)depth;
        Bytecodes._can_trap[code] = can_trap;
        Bytecodes._safepoint_safe[code] = safepoint_safe;
        Bytecodes._length[code] = (byte)(format != null ? format.length() : 0);
        Bytecodes._java_code[code] = java_code;
        Bytecodes._can_rewrite[java_code] = java_code != code;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Bytecodes.initialize();
            }
        });
    }
}

