/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.LookupswitchPair;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeLookupswitch
extends Bytecode {
    BytecodeLookupswitch(Method method, int bci) {
        super(method, bci);
    }

    public int defaultOffset() {
        return this.javaSignedWordAt(this.alignedOffset(1));
    }

    public int numberOfPairs() {
        return this.javaSignedWordAt(this.alignedOffset(5));
    }

    public LookupswitchPair pairAt(int i) {
        Assert.that(0 <= i && i < this.numberOfPairs(), "pair index out of bounds");
        return new LookupswitchPair(this.method, this.bci + this.alignedOffset(1 + (1 + i) * 2 * 4));
    }

    public void verify() {
        Assert.that(this.isValid(), "check lookupswitch");
    }

    public boolean isValid() {
        boolean result;
        boolean bl = result = this.javaCode() == 171;
        if (!result) {
            return false;
        }
        int i = this.numberOfPairs() - 1;
        while (i-- > 0) {
            if (this.pairAt(i).match() <= this.pairAt(i + 1).match()) continue;
            return false;
        }
        return true;
    }

    public static BytecodeLookupswitch at(Method method, int bci) {
        BytecodeLookupswitch b = new BytecodeLookupswitch(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeLookupswitch atCheck(Method method, int bci) {
        BytecodeLookupswitch b = new BytecodeLookupswitch(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeLookupswitch at(BytecodeStream bcs) {
        return new BytecodeLookupswitch(bcs.method(), bcs.bci());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("lookupswitch");
        buf.append(" ");
        buf.append("default: ");
        buf.append(Integer.toString(this.bci() + this.defaultOffset()));
        buf.append(", ");
        int i = this.numberOfPairs() - 1;
        while (i-- > 0) {
            LookupswitchPair pair = this.pairAt(i);
            buf.append("case ");
            buf.append(Integer.toString(pair.match()));
            buf.append(':');
            buf.append(Integer.toString(this.bci() + pair.offset()));
            buf.append(", ");
        }
        return buf.toString();
    }
}

