/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import sun.jvm.hotspot.code.CompressedStream;
import sun.jvm.hotspot.debugger.Address;

public class CompressedReadStream
extends CompressedStream {
    public CompressedReadStream(Address buffer) {
        this(buffer, 0);
    }

    public CompressedReadStream(Address buffer, int position) {
        super(buffer, position);
    }

    public boolean readBoolean() {
        return this.read() != 0;
    }

    public byte readByte() {
        return (byte)this.read();
    }

    public char readChar() {
        return (char)this.readInt();
    }

    public short readShort() {
        return (short)this.readInt();
    }

    public int readInt() {
        int shift = 0;
        int value = 0;
        short s = this.read();
        while (s < 128) {
            value += s << shift;
            shift += 7;
            s = this.read();
        }
        return value += s - 192 << shift;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public long readLong() {
        long low = (long)this.readInt() & 0xFFFFFFFFL;
        long high = this.readInt();
        return high << 32 | low;
    }

    private short read() {
        short retval = (short)this.buffer.getCIntegerAt(this.position, 1L, true);
        ++this.position;
        return retval;
    }
}

