/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import sun.tools.asm.SwitchData;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CaseStatement;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.IntegerExpression;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class SwitchStatement
extends Statement {
    Expression expr;
    Statement[] args;

    public SwitchStatement(long l, Expression expression, Statement[] statementArray) {
        super(95, l);
        this.expr = expression;
        this.args = statementArray;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        this.checkLabel(environment, context);
        CheckContext checkContext = new CheckContext(context, this);
        vset = this.expr.checkValue(environment, checkContext, this.reach(environment, vset), hashtable);
        Type type = this.expr.type;
        this.expr = this.convert(environment, checkContext, Type.tInt, this.expr);
        Hashtable<Expression, Statement> hashtable2 = new Hashtable<Expression, Statement>();
        boolean bl = false;
        Vset vset2 = DEAD_END;
        for (int i = 0; i < this.args.length; ++i) {
            Statement statement = this.args[i];
            if (statement.op == 96) {
                vset2 = statement.check(environment, checkContext, vset2.join(vset.copy()), hashtable);
                Expression expression = ((CaseStatement)statement).expr;
                if (expression != null) {
                    if (expression instanceof IntegerExpression) {
                        boolean bl2;
                        Integer n = (Integer)((IntegerExpression)expression).getValue();
                        int n2 = n;
                        if (hashtable2.get(expression) != null) {
                            environment.error(statement.where, "duplicate.label", n);
                            continue;
                        }
                        hashtable2.put(expression, statement);
                        switch (type.getTypeCode()) {
                            case 1: {
                                bl2 = n2 != (byte)n2;
                                break;
                            }
                            case 3: {
                                bl2 = n2 != (short)n2;
                                break;
                            }
                            case 2: {
                                bl2 = n2 != (char)n2;
                                break;
                            }
                            default: {
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        environment.error(statement.where, "switch.overflow", n, type);
                        continue;
                    }
                    if (expression.isConstant() && expression.getType() == Type.tInt) continue;
                    environment.error(statement.where, "const.expr.required");
                    continue;
                }
                if (bl) {
                    environment.error(statement.where, "duplicate.default");
                }
                bl = true;
                continue;
            }
            vset2 = statement.checkBlockStatement(environment, checkContext, vset2, hashtable);
        }
        if (!vset2.isDeadEnd()) {
            checkContext.vsBreak = checkContext.vsBreak.join(vset2);
        }
        if (bl) {
            vset = checkContext.vsBreak;
        }
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        this.expr = this.expr.inlineValue(environment, context);
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i] = this.args[i].inline(environment, context);
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        SwitchStatement switchStatement = (SwitchStatement)this.clone();
        switchStatement.expr = this.expr.copyInline(context);
        switchStatement.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            switchStatement.args[i] = this.args[i].copyInline(context, bl);
        }
        return switchStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = this.expr.costInline(n, environment, context);
        for (int i = 0; i < this.args.length && n2 < n; ++i) {
            if (this.args[i] == null) continue;
            n2 += this.args[i].costInline(n, environment, context);
        }
        return n2;
    }

    public void code(Environment environment, Context context, Assembler assembler) {
        Expression expression;
        Statement statement;
        int n;
        CodeContext codeContext = new CodeContext(context, this);
        this.expr.codeValue(environment, codeContext, assembler);
        SwitchData switchData = new SwitchData();
        boolean bl = false;
        for (n = 0; n < this.args.length; ++n) {
            statement = this.args[n];
            if (statement == null || statement.op != 96) continue;
            expression = ((CaseStatement)statement).expr;
            if (expression != null) {
                switchData.add(((IntegerExpression)expression).value, new Label());
                continue;
            }
            bl = true;
        }
        if (environment.coverage()) {
            switchData.initTableCase();
        }
        assembler.add(this.where, 170, switchData);
        for (n = 0; n < this.args.length; ++n) {
            statement = this.args[n];
            if (statement == null) continue;
            if (statement.op == 96) {
                expression = ((CaseStatement)statement).expr;
                if (expression != null) {
                    assembler.add(switchData.get(((IntegerExpression)expression).value));
                    switchData.addTableCase(((IntegerExpression)expression).value, statement.where);
                    continue;
                }
                assembler.add(switchData.getDefaultLabel());
                switchData.addTableDefault(statement.where);
                continue;
            }
            statement.code(environment, codeContext, assembler);
        }
        if (!bl) {
            assembler.add(switchData.getDefaultLabel());
        }
        assembler.add(codeContext.breakLabel);
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("switch (");
        this.expr.print(printStream);
        printStream.print(") {\n");
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.printIndent(printStream, n + 1);
            this.args[i].print(printStream, n + 1);
            printStream.print("\n");
        }
        this.printIndent(printStream, n);
        printStream.print("}");
    }
}

