/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ByteValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class ByteValueImpl
extends PrimitiveValueImpl
implements ByteValue {
    private byte value;

    ByteValueImpl(VirtualMachine virtualMachine, byte by) {
        super(virtualMachine);
        this.value = by;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ByteValue) {
            return this.value == ((ByteValue)object).value() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(ByteValue byteValue) {
        byte by = byteValue.value();
        return this.value() - by;
    }

    public Type type() {
        return this.vm.theByteType();
    }

    public byte value() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public byte byteValue() {
        return this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    public String toString() {
        return "" + this.value;
    }

    byte typeValueKey() {
        return 66;
    }
}

