/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.TreeSet;

public final class DeploySigningCertStore
implements CertStore {
    private static String _filenameUser = null;
    private static String _filenameSys = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private KeyStore _deploymentUserCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemCerts = CertUtils.createEmptyKeyStore();

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long l;
        if (_filenameUser != null && (l = CertUtils.getFileLastModified(_filenameUser)) != this._userLastModified) {
            this._deploymentUserCerts = this.load(_filenameUser);
            this._userLastModified = l;
        }
        if (_filenameSys != null && (l = CertUtils.getFileLastModified(_filenameSys)) != this._sysLastModified) {
            this._deploymentSystemCerts = this.load(_filenameSys);
            this._sysLastModified = l;
        }
    }

    private KeyStore load(final String string) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("deploycertstore.cert.loading", new Object[]{string});
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(string);
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        keyStore.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.loaded", new Object[]{string});
        return keyStore;
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("deploycertstore.cert.saving", new Object[]{_filenameUser});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_filenameUser);
                    file.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    DeploySigningCertStore.this._deploymentUserCerts.store(bufferedOutputStream, new char[0]);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.saved", new Object[]{_filenameUser});
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.adding");
        String string = this._deploymentUserCerts.getCertificateAlias(certificate);
        if (string == null) {
            Random random = new Random();
            boolean bl = false;
            String string2 = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentUserCerts.getCertificate(string2 = "deploymentusercert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._deploymentUserCerts.setCertificateEntry(string2, certificate);
            Trace.msgSecurityPrintln("deploycertstore.cert.added", new Object[]{string2});
        }
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.removing");
        String string = this._deploymentUserCerts.getCertificateAlias(certificate);
        if (string != null) {
            this._deploymentUserCerts.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removed", new Object[]{string});
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.instore");
        String string = this._deploymentSystemCerts.getCertificateAlias(certificate);
        if (string != null) {
            return true;
        }
        string = this._deploymentUserCerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("deploycertstore.cert.canverify");
        return false;
    }

    public Iterator iterator(int n) throws KeyStoreException {
        Object object;
        Trace.msgSecurityPrintln("deploycertstore.cert.iterator");
        LinkedHashSet<Certificate> linkedHashSet = new LinkedHashSet<Certificate>();
        KeyStore keyStore = this.getKeyStore(n);
        Enumeration<String> enumeration = keyStore.aliases();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            treeSet.add(object);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            Certificate certificate = keyStore.getCertificate(string);
            linkedHashSet.add(certificate);
        }
        return linkedHashSet.iterator();
    }

    private KeyStore getKeyStore(int n) {
        Trace.msgSecurityPrintln("deploycertstore.cert.getkeystore");
        return n == 0 ? this._deploymentUserCerts : this._deploymentSystemCerts;
    }

    static {
        _filenameUser = Config.getUserTrustedCertificateFile();
        _filenameSys = Config.getSystemTrustedCertificateFile();
    }
}

