/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecretKeyFactory
extends SecretKeyFactorySpi {
    private final Token token;
    private final String algorithm;

    P11SecretKeyFactory(Token token, String string) {
        this.token = token;
        this.algorithm = string;
    }

    static P11Key convertKey(Token token, Key key, String string) throws InvalidKeyException {
        P11Key p11Key;
        token.ensureValid();
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key must be a SecretKey");
        }
        P11SecretKeyFactory.checkAlgorithm(string, key.getAlgorithm());
        if (key instanceof P11Key) {
            p11Key = (P11Key)key;
            if (p11Key.token == token) {
                return p11Key;
            }
        }
        if ((p11Key = token.secretCache.get(key)) != null) {
            return p11Key;
        }
        if (!"RAW".equals(key.getFormat())) {
            throw new InvalidKeyException("Encoded format must be RAW");
        }
        byte[] byArray = key.getEncoded();
        p11Key = P11SecretKeyFactory.createKey(token, byArray, string);
        token.secretCache.put(key, p11Key);
        return p11Key;
    }

    private static void checkAlgorithm(String string, String string2) throws InvalidKeyException {
        String string3 = string.toUpperCase();
        if (string3.startsWith("HMAC")) {
            return;
        }
        if (string3.equals("RC4")) {
            string3 = "ARCFOUR";
        }
        if ((string2 = string2.toUpperCase()).equals("RC4")) {
            string2 = "ARCFOUR";
        }
        if (!string3.equals(string2)) {
            throw new InvalidKeyException("Key algorithm must be " + string);
        }
    }

    private static void fixDESParity(byte[] byArray, int n) {
        for (int i = 0; i < 8; ++i) {
            int n2 = byArray[n] & 0xFE;
            n2 |= Integer.bitCount(n2) & 1 ^ 1;
            byArray[n++] = (byte)n2;
        }
    }

    private static P11Key createKey(Token token, byte[] byArray, String string) throws InvalidKeyException {
        P11Key p11Key;
        int n;
        long l;
        int n2 = byArray.length;
        if (string.equals("RC4") || string.equals("ARCFOUR")) {
            if (n2 < 5 || n2 > 128) {
                throw new InvalidKeyException("ARCFOUR key length must be between 5 and 128 bytes");
            }
            l = 18L;
            n = n2 << 3;
        } else if (string.equals("DES")) {
            if (n2 != 8) {
                throw new InvalidKeyException("DES key length must be 8 bytes");
            }
            l = 19L;
            n = 56;
            P11SecretKeyFactory.fixDESParity(byArray, 0);
        } else if (string.equals("DESede")) {
            if (n2 == 16) {
                l = 20L;
            } else if (n2 == 24) {
                l = 21L;
                P11SecretKeyFactory.fixDESParity(byArray, 16);
            } else {
                throw new InvalidKeyException("DESede key length must be 16 or 24 bytes");
            }
            P11SecretKeyFactory.fixDESParity(byArray, 0);
            P11SecretKeyFactory.fixDESParity(byArray, 8);
            n = n2 * 7;
        } else if (string.equals("AES")) {
            if (n2 != 16 && n2 != 24 && n2 != 32) {
                throw new InvalidKeyException("AES key length must be 16, 24, or 32 bytes");
            }
            l = 31L;
            n = n2 << 3;
        } else if (string.equals("Blowfish")) {
            if (n2 < 5 || n2 > 56) {
                throw new InvalidKeyException("Blowfish key length must be between 5 and 56 bytes");
            }
            l = 32L;
            n = n2 << 3;
        } else if (string.startsWith("Hmac")) {
            if (n2 == 0) {
                throw new InvalidKeyException("HMAC keys must not be empty");
            }
            l = 16L;
            n = n2 << 3;
        } else {
            throw new InvalidKeyException("Unknown algorithm " + string);
        }
        Session session = null;
        try {
            P11Key p11Key2;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l), new CK_ATTRIBUTE(17L, byArray)};
            cK_ATTRIBUTEArray = token.getAttributes("import", 4L, l, cK_ATTRIBUTEArray);
            session = token.getObjSession();
            long l2 = token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            p11Key = p11Key2 = (P11Key)((Object)P11Key.secretKey(session, l2, string, n, cK_ATTRIBUTEArray));
            token.releaseSession(session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            try {
                throw new InvalidKeyException("Could not create key", pKCS11Exception);
            }
            catch (Throwable throwable) {
                token.releaseSession(session);
                throw throwable;
            }
        }
        return p11Key;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec == null) {
            throw new InvalidKeySpecException("KeySpec must not be null");
        }
        if (keySpec instanceof SecretKeySpec) {
            try {
                P11Key p11Key = P11SecretKeyFactory.convertKey(this.token, (SecretKey)((Object)keySpec), this.algorithm);
                return (SecretKey)((Object)p11Key);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException(invalidKeyException);
            }
        }
        if (this.algorithm.equalsIgnoreCase("DES")) {
            if (keySpec instanceof DESKeySpec) {
                byte[] byArray = ((DESKeySpec)keySpec).getKey();
                keySpec = new SecretKeySpec(byArray, "DES");
                return this.engineGenerateSecret(keySpec);
            }
        } else if (this.algorithm.equalsIgnoreCase("DESede") && keySpec instanceof DESedeKeySpec) {
            byte[] byArray = ((DESedeKeySpec)keySpec).getKey();
            keySpec = new SecretKeySpec(byArray, "DESede");
            return this.engineGenerateSecret(keySpec);
        }
        throw new InvalidKeySpecException("Unsupported spec: " + keySpec.getClass().getName());
    }

    private byte[] getKeyBytes(SecretKey secretKey) throws InvalidKeySpecException {
        try {
            secretKey = this.engineTranslateKey(secretKey);
            if (!"RAW".equals(secretKey.getFormat())) {
                throw new InvalidKeySpecException("Could not obtain key bytes");
            }
            byte[] byArray = secretKey.getEncoded();
            return byArray;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        block10: {
            this.token.ensureValid();
            if (secretKey == null || clazz == null) {
                throw new InvalidKeySpecException("key and keySpec must not be null");
            }
            if (SecretKeySpec.class.isAssignableFrom(clazz)) {
                return new SecretKeySpec(this.getKeyBytes(secretKey), this.algorithm);
            }
            if (this.algorithm.equalsIgnoreCase("DES")) {
                try {
                    if (DESKeySpec.class.isAssignableFrom(clazz)) {
                        return new DESKeySpec(this.getKeyBytes(secretKey));
                    }
                    break block10;
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException);
                }
            }
            if (this.algorithm.equalsIgnoreCase("DESede")) {
                try {
                    if (DESedeKeySpec.class.isAssignableFrom(clazz)) {
                        return new DESedeKeySpec(this.getKeyBytes(secretKey));
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException);
                }
            }
        }
        throw new InvalidKeySpecException("Unsupported spec: " + clazz.getName());
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        return (SecretKey)((Object)P11SecretKeyFactory.convertKey(this.token, secretKey, this.algorithm));
    }
}

