/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.HashMap;

public class ManifestDigester {
    public static final String MF_MAIN_ATTRS = "Manifest-Main-Attributes";
    byte[] rawBytes;
    HashMap entries;

    private boolean findSection(int n2, Position position) {
        int n3 = this.rawBytes.length;
        int n4 = n2;
        boolean bl2 = true;
        position.endOfFirstLine = -1;
        block4: for (int i2 = n2; i2 < n3; ++i2) {
            byte by = this.rawBytes[i2];
            switch (by) {
                case 13: {
                    if (position.endOfFirstLine == -1) {
                        position.endOfFirstLine = i2 - 1;
                    }
                    if (i2 < n3 && this.rawBytes[i2 + 1] == 10) {
                        ++i2;
                    }
                }
                case 10: {
                    if (position.endOfFirstLine == -1) {
                        position.endOfFirstLine = i2 - 1;
                    }
                    if (bl2 || i2 == n3 - 1) {
                        position.endOfSection = i2 == n3 - 1 ? i2 : n4;
                        position.startOfNext = i2 + 1;
                        return true;
                    }
                    n4 = i2;
                    bl2 = true;
                    continue block4;
                }
                default: {
                    bl2 = false;
                }
            }
        }
        return false;
    }

    public ManifestDigester(byte[] byArray) {
        this.rawBytes = byArray;
        this.entries = new HashMap();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Position position = new Position();
        if (!this.findSection(0, position)) {
            return;
        }
        this.entries.put(MF_MAIN_ATTRS, new Entry(0, position.endOfSection + 1, position.startOfNext, this.rawBytes));
        int n2 = position.startOfNext;
        while (this.findSection(n2, position)) {
            int n3 = position.endOfFirstLine - n2 + 1;
            int n4 = position.endOfSection - n2 + 1;
            int n5 = position.startOfNext - n2;
            if (n3 > 6 && this.isNameAttr(byArray, n2)) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    stringBuffer.append(new String(byArray, n2 + 6, n3 - 6, "UTF8"));
                    int n6 = n2 + n3;
                    if (n6 - n2 < n4) {
                        n6 = byArray[n6] == 13 ? (n6 += 2) : ++n6;
                    }
                    while (n6 - n2 < n4 && byArray[n6++] == 32) {
                        int n7 = n6;
                        while (n6 - n2 < n4 && byArray[n6++] != 10) {
                        }
                        if (byArray[n6 - 1] != 10) {
                            return;
                        }
                        int n8 = byArray[n6 - 2] == 13 ? n6 - n7 - 2 : n6 - n7 - 1;
                        stringBuffer.append(new String(byArray, n7, n8, "UTF8"));
                    }
                    String string = stringBuffer.toString();
                    this.entries.put(new String(string.getBytes(), "UTF8"), new Entry(n2, n4, n5, this.rawBytes));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException("UTF8 not available on platform");
                }
            }
            n2 = position.startOfNext;
        }
    }

    private boolean isNameAttr(byte[] byArray, int n2) {
        return !(byArray[n2] != 78 && byArray[n2] != 110 || byArray[n2 + 1] != 97 && byArray[n2 + 1] != 65 || byArray[n2 + 2] != 109 && byArray[n2 + 2] != 77 || byArray[n2 + 3] != 101 && byArray[n2 + 3] != 69 || byArray[n2 + 4] != 58 || byArray[n2 + 5] != 32);
    }

    public Entry get(String string, boolean bl2) {
        Entry entry = null;
        try {
            entry = (Entry)this.entries.get(new String(string.getBytes(), "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF8 not available on platform");
        }
        if (entry != null) {
            entry.oldStyle = bl2;
        }
        return entry;
    }

    public byte[] manifestDigest(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(this.rawBytes, 0, this.rawBytes.length);
        return messageDigest.digest();
    }

    public static class Entry {
        int offset;
        int length;
        int lengthWithBlankLine;
        byte[] rawBytes;
        boolean oldStyle;

        public Entry(int n2, int n3, int n4, byte[] byArray) {
            this.offset = n2;
            this.length = n3;
            this.lengthWithBlankLine = n4;
            this.rawBytes = byArray;
        }

        public byte[] digest(MessageDigest messageDigest) {
            messageDigest.reset();
            if (this.oldStyle) {
                this.doOldStyle(messageDigest, this.rawBytes, this.offset, this.lengthWithBlankLine);
            } else {
                messageDigest.update(this.rawBytes, this.offset, this.lengthWithBlankLine);
            }
            return messageDigest.digest();
        }

        private void doOldStyle(MessageDigest messageDigest, byte[] byArray, int n2, int n3) {
            int n4;
            int n5 = n2;
            int n6 = n2 + n3;
            int n7 = -1;
            for (n4 = n2; n4 < n6; ++n4) {
                if (byArray[n4] == 13 && n7 == 32) {
                    messageDigest.update(byArray, n5, n4 - n5 - 1);
                    n5 = n4;
                }
                n7 = byArray[n4];
            }
            messageDigest.update(byArray, n5, n4 - n5);
        }

        public byte[] digestWorkaround(MessageDigest messageDigest) {
            messageDigest.reset();
            messageDigest.update(this.rawBytes, this.offset, this.length);
            return messageDigest.digest();
        }
    }

    static class Position {
        int endOfFirstLine;
        int endOfSection;
        int startOfNext;

        Position() {
        }
    }
}

