/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PolicyNodeImpl
implements PolicyNode {
    private static final String ANY_POLICY = "2.5.29.32.0";
    private PolicyNodeImpl mParent;
    private HashSet mChildren;
    private String mValidPolicy;
    private HashSet mQualifierSet;
    private boolean mCriticalityIndicator;
    private HashSet mExpectedPolicySet;
    private boolean mOriginalExpectedPolicySet;
    private int mDepth;
    private boolean isImmutable = false;

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, String string, Set set, boolean bl2, Set set2, boolean bl3) {
        this.mParent = policyNodeImpl;
        this.mChildren = new HashSet();
        this.mValidPolicy = string != null ? string : "";
        this.mQualifierSet = set != null ? new HashSet(set) : new HashSet();
        this.mCriticalityIndicator = bl2;
        this.mExpectedPolicySet = set2 != null ? new HashSet(set2) : new HashSet();
        boolean bl4 = this.mOriginalExpectedPolicySet = !bl3;
        if (this.mParent != null) {
            this.mDepth = this.mParent.getDepth() + 1;
            this.mParent.addChild(this);
        } else {
            this.mDepth = 0;
        }
    }

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, PolicyNodeImpl policyNodeImpl2) {
        this(policyNodeImpl, policyNodeImpl2.mValidPolicy, policyNodeImpl2.mQualifierSet, policyNodeImpl2.mCriticalityIndicator, policyNodeImpl2.mExpectedPolicySet, false);
    }

    @Override
    public PolicyNode getParent() {
        return this.mParent;
    }

    public Iterator<PolicyNodeImpl> getChildren() {
        return Collections.unmodifiableSet(this.mChildren).iterator();
    }

    @Override
    public int getDepth() {
        return this.mDepth;
    }

    @Override
    public String getValidPolicy() {
        return this.mValidPolicy;
    }

    public Set<PolicyQualifierInfo> getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.mQualifierSet);
    }

    @Override
    public Set<String> getExpectedPolicies() {
        return Collections.unmodifiableSet(this.mExpectedPolicySet);
    }

    @Override
    public boolean isCritical() {
        return this.mCriticalityIndicator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.asString());
        Iterator<PolicyNodeImpl> iterator = this.getChildren();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    boolean isImmutable() {
        return this.isImmutable;
    }

    void setImmutable() {
        if (this.isImmutable) {
            return;
        }
        for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
            policyNodeImpl.setImmutable();
        }
        this.isImmutable = true;
    }

    private void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.add(policyNodeImpl);
    }

    void addExpectedPolicy(String string) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mOriginalExpectedPolicySet) {
            this.mExpectedPolicySet.clear();
            this.mOriginalExpectedPolicySet = false;
        }
        this.mExpectedPolicySet.add(string);
    }

    void prune(int n2) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mChildren.size() == 0) {
            return;
        }
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
            policyNodeImpl.prune(n2);
            if (policyNodeImpl.mChildren.size() != 0 || n2 <= this.mDepth + 1) continue;
            iterator.remove();
        }
    }

    void deleteChild(PolicyNode policyNode) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.remove(policyNode);
    }

    PolicyNodeImpl copyTree() {
        return this.copyTree(null);
    }

    private PolicyNodeImpl copyTree(PolicyNodeImpl policyNodeImpl) {
        PolicyNodeImpl policyNodeImpl2 = new PolicyNodeImpl(policyNodeImpl, this);
        for (PolicyNodeImpl policyNodeImpl3 : this.mChildren) {
            policyNodeImpl3.copyTree(policyNodeImpl2);
        }
        return policyNodeImpl2;
    }

    Set getPolicyNodes(int n2) {
        HashSet hashSet = new HashSet();
        this.getPolicyNodes(n2, hashSet);
        return hashSet;
    }

    private void getPolicyNodes(int n2, Set set) {
        if (this.mDepth == n2) {
            set.add(this);
        } else {
            for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
                policyNodeImpl.getPolicyNodes(n2, set);
            }
        }
    }

    Set getPolicyNodesExpected(int n2, String string, boolean bl2) {
        if (string.equals(ANY_POLICY)) {
            return this.getPolicyNodes(n2);
        }
        return this.getPolicyNodesExpectedHelper(n2, string, bl2);
    }

    private Set getPolicyNodesExpectedHelper(int n2, String string, boolean bl2) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        if (this.mDepth < n2) {
            for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
                hashSet.addAll(policyNodeImpl.getPolicyNodesExpectedHelper(n2, string, bl2));
            }
        } else if (bl2) {
            if (this.mExpectedPolicySet.contains(ANY_POLICY)) {
                hashSet.add(this);
            }
        } else if (this.mExpectedPolicySet.contains(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    Set getPolicyNodesValid(int n2, String string) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        if (this.mDepth < n2) {
            for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
                hashSet.addAll(policyNodeImpl.getPolicyNodesValid(n2, string));
            }
        } else if (this.mValidPolicy.equals(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    private static String policyToString(String string) {
        if (string.equals(ANY_POLICY)) {
            return "anyPolicy";
        }
        return string;
    }

    String asString() {
        if (this.mParent == null) {
            return "anyPolicy  ROOT\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getDepth();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(PolicyNodeImpl.policyToString(this.getValidPolicy()));
        stringBuffer.append("  CRIT: ");
        stringBuffer.append(this.isCritical());
        stringBuffer.append("  EP: ");
        for (String string : this.getExpectedPolicies()) {
            stringBuffer.append(PolicyNodeImpl.policyToString(string));
            stringBuffer.append(" ");
        }
        stringBuffer.append(" (");
        stringBuffer.append(this.getDepth());
        stringBuffer.append(")\n");
        return stringBuffer.toString();
    }
}

