/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetProperties;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxySelector
extends ProxySelector {
    static final String[][] props = new String[][]{{"http", "http.proxy", "proxy", "socksProxy"}, {"https", "https.proxy", "proxy", "socksProxy"}, {"ftp", "ftp.proxy", "ftpProxy", "proxy", "socksProxy"}, {"gopher", "gopherProxy", "socksProxy"}, {"socket", "socksProxy"}};
    private static boolean hasSystemProxies = false;
    private static Properties defprops = new Properties();
    private static NonProxyInfo ftpNonProxyInfo;
    private static NonProxyInfo httpNonProxyInfo;
    private static final Pattern p6;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private int number;

    @Override
    public List<Proxy> select(URI uRI) {
        Object object;
        if (uRI == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String string = uRI.getScheme();
        Object object2 = uRI.getHost();
        int n2 = uRI.getPort();
        if (object2 == null && (object = uRI.getAuthority()) != null) {
            int n3 = ((String)object).indexOf(64);
            if (n3 >= 0) {
                object = ((String)object).substring(n3 + 1);
            }
            if ((n3 = ((String)object).lastIndexOf(58)) >= 0) {
                try {
                    n2 = Integer.parseInt(((String)object).substring(n3 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                object = ((String)object).substring(0, n3);
            }
            object2 = object;
        }
        if (string == null || object2 == null) {
            throw new IllegalArgumentException("protocol = " + string + " host = " + (String)object2);
        }
        object = new ArrayList(1);
        if (this.isLoopback((String)object2)) {
            object.add(Proxy.NO_PROXY);
            return object;
        }
        NonProxyInfo nonProxyInfo = null;
        if ("http".equalsIgnoreCase(string)) {
            nonProxyInfo = httpNonProxyInfo;
        } else if ("https".equalsIgnoreCase(string)) {
            nonProxyInfo = httpNonProxyInfo;
        } else if ("ftp".equalsIgnoreCase(string)) {
            nonProxyInfo = ftpNonProxyInfo;
        }
        final String string2 = string;
        NonProxyInfo nonProxyInfo2 = nonProxyInfo;
        Object object3 = object2;
        Proxy proxy = (Proxy)AccessController.doPrivileged(new PrivilegedAction((String)object3, nonProxyInfo2){
            final /* synthetic */ String val$urlhost;
            final /* synthetic */ NonProxyInfo val$nprop;
            {
                this.val$urlhost = string22;
                this.val$nprop = nonProxyInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                String string = null;
                int n2 = 0;
                String string22 = null;
                InetSocketAddress inetSocketAddress = null;
                for (int i2 = 0; i2 < props.length; ++i2) {
                    int n3;
                    if (!props[i2][0].equalsIgnoreCase(string2)) continue;
                    for (n3 = 1; n3 < props[i2].length && ((string = NetProperties.get(props[i2][n3] + "Host")) == null || string.length() == 0); ++n3) {
                    }
                    if (string == null || string.length() == 0) {
                        String string3;
                        Proxy proxy;
                        if (hasSystemProxies && (proxy = DefaultProxySelector.this.getSystemProxy(string3 = string2.equalsIgnoreCase("socket") ? "socks" : string2, this.val$urlhost)) != null) {
                            return proxy;
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (this.val$nprop != null) {
                        string22 = NetProperties.get(this.val$nprop.property);
                        NonProxyInfo nonProxyInfo = this.val$nprop;
                        synchronized (nonProxyInfo) {
                            if (string22 == null) {
                                this.val$nprop.hostsSource = null;
                                this.val$nprop.hostsPool = null;
                            } else if (!string22.equals(this.val$nprop.hostsSource)) {
                                RegexpPool regexpPool = new RegexpPool();
                                StringTokenizer stringTokenizer = new StringTokenizer(string22, "|", false);
                                try {
                                    while (stringTokenizer.hasMoreTokens()) {
                                        regexpPool.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                                    }
                                }
                                catch (REException rEException) {
                                    // empty catch block
                                }
                                this.val$nprop.hostsPool = regexpPool;
                                this.val$nprop.hostsSource = string22;
                            }
                            if (this.val$nprop.hostsPool != null && this.val$nprop.hostsPool.match(this.val$urlhost) != null) {
                                return Proxy.NO_PROXY;
                            }
                        }
                    }
                    if ((n2 = NetProperties.getInteger(props[i2][n3] + "Port", 0).intValue()) == 0 && n3 < props[i2].length - 1) {
                        for (int i3 = 1; i3 < props[i2].length - 1; ++i3) {
                            if (i3 == n3 || n2 != 0) continue;
                            n2 = NetProperties.getInteger(props[i2][i3] + "Port", 0);
                        }
                    }
                    if (n2 == 0) {
                        n2 = n3 == props[i2].length - 1 ? DefaultProxySelector.this.defaultPort("socket") : DefaultProxySelector.this.defaultPort(string2);
                    }
                    inetSocketAddress = InetSocketAddress.createUnresolved(string, n2);
                    if (n3 == props[i2].length - 1) {
                        return new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
                    }
                    return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                }
                return Proxy.NO_PROXY;
            }
        });
        object.add(proxy);
        return object;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        if (uRI == null || socketAddress == null || iOException == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
    }

    private int defaultPort(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        if ("ftp".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("socket".equalsIgnoreCase(string)) {
            return 1080;
        }
        if ("gopher".equalsIgnoreCase(string)) {
            return 80;
        }
        return -1;
    }

    private boolean isLoopback(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (string.startsWith("127.")) {
            int n2 = 4;
            int n3 = string.length();
            int n4 = this.scanByte(string, n2, n3);
            if (n4 <= n2) {
                return false;
            }
            n2 = n4;
            if ((n4 = this.scan(string, n2, n3, '.')) <= n2) {
                return n4 == n3 && this.number > 0;
            }
            n2 = n4;
            if ((n4 = this.scanByte(string, n2, n3)) <= n2) {
                return false;
            }
            n2 = n4;
            if ((n4 = this.scan(string, n2, n3, '.')) <= n2) {
                return n4 == n3 && this.number > 0;
            }
            n2 = n4;
            if ((n4 = this.scanByte(string, n2, n3)) <= n2) {
                return false;
            }
            return n4 == n3 && this.number > 0;
        }
        if (string.endsWith(":1")) {
            return p6.matcher(string).matches();
        }
        return false;
    }

    private static long lowMask(char c2, char c3) {
        long l2 = 0L;
        int n2 = Math.max(Math.min(c2, 63), 0);
        int n3 = Math.max(Math.min(c3, 63), 0);
        for (int i2 = n2; i2 <= n3; ++i2) {
            l2 |= 1L << i2;
        }
        return l2;
    }

    private int scanByte(String string, int n2, int n3) {
        int n4 = n2;
        int n5 = this.scan(string, n4, n3, L_DIGIT, 0L);
        if (n5 <= n4) {
            return n5;
        }
        this.number = Integer.parseInt(string.substring(n4, n5));
        if (this.number > 255) {
            return n4;
        }
        return n5;
    }

    private int scan(String string, int n2, int n3, char c2) {
        if (n2 < n3 && string.charAt(n2) == c2) {
            return n2 + 1;
        }
        return n2;
    }

    private int scan(String string, int n2, int n3, long l2, long l3) {
        char c2;
        int n4;
        for (n4 = n2; n4 < n3 && this.match(c2 = string.charAt(n4), l2, l3); ++n4) {
        }
        return n4;
    }

    private boolean match(char c2, long l2, long l3) {
        if (c2 < '@') {
            return (1L << c2 & l2) != 0L;
        }
        if (c2 < '\u0080') {
            return (1L << c2 - 64 & l3) != 0L;
        }
        return false;
    }

    private static native boolean init();

    private native Proxy getSystemProxy(String var1, String var2);

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return NetProperties.getBoolean("java.net.useSystemProxies");
            }
        });
        if (bl2 != null && bl2.booleanValue()) {
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            hasSystemProxies = DefaultProxySelector.init();
        }
        ftpNonProxyInfo = new NonProxyInfo("ftp.nonProxyHosts", null, null);
        httpNonProxyInfo = new NonProxyInfo("http.nonProxyHosts", null, null);
        p6 = Pattern.compile("::1|(0:){7}1|(0:){1,6}:1");
        L_DIGIT = DefaultProxySelector.lowMask('0', '9');
    }

    static class NonProxyInfo {
        String hostsSource;
        RegexpPool hostsPool;
        String property;

        NonProxyInfo(String string, String string2, RegexpPool regexpPool) {
            this.property = string;
            this.hostsSource = string2;
            this.hostsPool = regexpPool;
        }
    }
}

