/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import sun.nio.ByteBuffered;

public abstract class Resource {
    private InputStream cis;

    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength() throws IOException;

    private synchronized InputStream cachedInputStream() throws IOException {
        if (this.cis == null) {
            this.cis = this.getInputStream();
        }
        return this.cis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] byArray;
        InputStream inputStream = this.cachedInputStream();
        try {
            int n2;
            if (n2 != -1) {
                int n3;
                byArray = new byte[n2];
                for (n2 = this.getContentLength(); n2 > 0; n2 -= n3) {
                    n3 = inputStream.read(byArray, byArray.length - n2, n2);
                    if (n3 != -1) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] byArray2;
                byArray = new byte[1024];
                int n4 = 0;
                while ((n2 = inputStream.read(byArray, n4, byArray.length - n4)) != -1) {
                    if ((n4 += n2) < byArray.length) continue;
                    byArray2 = new byte[n4 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                    byArray = byArray2;
                }
                if (n4 != byArray.length) {
                    byArray2 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                    byArray = byArray2;
                }
            }
        }
        finally {
            inputStream.close();
        }
        return byArray;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        InputStream inputStream = this.cachedInputStream();
        if (inputStream instanceof ByteBuffered) {
            return ((ByteBuffered)((Object)inputStream)).getByteBuffer();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        return null;
    }
}

