/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.OpenDataException;
import sun.management.MappedMXBeanType;
import sun.management.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanSupport
implements DynamicMBean {
    private String className;
    private Class interfaceClass;
    private Map<String, AttributeMethod> attrMethods;
    private Map<String, List<Method>> opMethods;
    private MBeanInfo minfo;
    private Map<Method, ProxyMethod> proxyMethods;
    private int numAttributes;
    private int numOperations;
    private boolean notificationEmitter;
    private static Map<Class, MXBeanSupport> proxyMXBeans = new HashMap<Class, MXBeanSupport>();
    private static final Type[] NO_PARAMS = new Type[0];

    protected MXBeanSupport(Class clazz) {
        this.initialize(clazz, false);
    }

    protected MXBeanSupport(Class clazz, boolean bl2) {
        this.initialize(clazz, bl2);
    }

    void initialize(Class clazz, boolean bl2) {
        this.className = this.getClass().getName();
        this.interfaceClass = clazz;
        this.attrMethods = null;
        this.opMethods = null;
        this.minfo = null;
        this.proxyMethods = null;
        this.numAttributes = 0;
        this.numOperations = 0;
        this.notificationEmitter = bl2;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getAttribute(this, string);
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        return this.getAttributes(this, stringArray);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.setAttribute(this, attribute);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        return this.setAttributes(this, attributeList);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return this.invoke(this, string, objectArray, stringArray);
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray;
        MBeanConstructorInfo[] mBeanConstructorInfoArray;
        if (this.minfo != null) {
            return this.minfo;
        }
        if (this.notificationEmitter) {
            mBeanConstructorInfoArray = (MBeanConstructorInfo[])this;
            mBeanNotificationInfoArray = mBeanConstructorInfoArray.getNotificationInfo();
        } else {
            mBeanNotificationInfoArray = new MBeanNotificationInfo[]{};
        }
        this.parse();
        mBeanConstructorInfoArray = new MBeanConstructorInfo[]{};
        MBeanAttributeInfo[] mBeanAttributeInfoArray = MXBeanSupport.buildAttributeInfoArray(this.attrMethods);
        MBeanOperationInfo[] mBeanOperationInfoArray = MXBeanSupport.buildOperationInfoArray(this.opMethods, this.numOperations);
        this.minfo = new MBeanInfo(this.className, this.className, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        return this.minfo;
    }

    private synchronized void parse() {
        if (this.attrMethods != null || this.opMethods != null) {
            return;
        }
        Method[] methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MXBeanSupport.this.interfaceClass.getMethods();
            }
        });
        this.attrMethods = new HashMap<String, AttributeMethod>();
        this.opMethods = new HashMap<String, List<Method>>();
        for (Method method : methodArray) {
            List<Method> list;
            String string;
            if (MXBeanSupport.isGetter(method)) {
                string = MXBeanSupport.getAttributeName(method);
                list = this.attrMethods.get(string);
                if (list == null) {
                    list = new AttributeMethod(string);
                    this.attrMethods.put(string, (AttributeMethod)((Object)list));
                }
                ((AttributeMethod)((Object)list)).setGetterMethod(method);
                continue;
            }
            if (MXBeanSupport.isSetter(method)) {
                string = MXBeanSupport.getAttributeName(method);
                list = this.attrMethods.get(string);
                if (list == null) {
                    list = new AttributeMethod(string);
                    this.attrMethods.put(string, (AttributeMethod)((Object)list));
                }
                ((AttributeMethod)((Object)list)).setSetterMethod(method);
                continue;
            }
            string = method.getName();
            list = this.opMethods.get(string);
            if (list == null) {
                list = new ArrayList<Method>();
                this.opMethods.put(string, list);
            }
            list.add(method);
            ++this.numOperations;
        }
    }

    public static boolean isGetter(Method method) {
        String string = method.getName();
        Class<?> clazz = method.getReturnType();
        String string2 = "";
        if (string.startsWith("get")) {
            string2 = string.substring(3);
        } else if (string.startsWith("is") && clazz == Boolean.TYPE) {
            string2 = string.substring(2);
        } else {
            return false;
        }
        return !string2.equals("") && !string2.equals("Class") && method.getParameterTypes().length == 0 && clazz != Void.TYPE;
    }

    public static boolean isSetter(Method method) {
        String string = method.getName();
        Class<?> clazz = method.getReturnType();
        String string2 = "";
        if (!string.startsWith("set")) {
            return false;
        }
        string2 = string.substring(3);
        return !string2.equals("") && method.getParameterTypes().length == 1 && clazz == Void.TYPE;
    }

    public static String getAttributeName(Method method) {
        String string = method.getName();
        String string2 = null;
        if (string.startsWith("get")) {
            string2 = string.substring(3);
        } else if (string.startsWith("is")) {
            string2 = string.substring(2);
        } else if (string.startsWith("set")) {
            string2 = string.substring(3);
        }
        return string2;
    }

    static synchronized MXBeanSupport newProxy(Class clazz) {
        MXBeanSupport mXBeanSupport = proxyMXBeans.get(clazz);
        if (mXBeanSupport == null) {
            mXBeanSupport = new MXBeanSupport(clazz);
            proxyMXBeans.put(clazz, mXBeanSupport);
            mXBeanSupport.buildProxyMethods();
        }
        return mXBeanSupport;
    }

    private void buildProxyMethods() {
        Method[] methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MXBeanSupport.this.interfaceClass.getMethods();
            }
        });
        this.proxyMethods = new HashMap<Method, ProxyMethod>();
        for (Method method : methodArray) {
            ProxyMethod proxyMethod = null;
            try {
                proxyMethod = new ProxyMethod(method);
            }
            catch (OpenDataException openDataException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(this.interfaceClass.getName() + " is not a valid MXBean interface.");
                illegalArgumentException.initCause(openDataException);
                throw illegalArgumentException;
            }
            this.proxyMethods.put(method, proxyMethod);
        }
    }

    public Object forward(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Method method, Object[] objectArray) throws Throwable {
        ProxyMethod proxyMethod = this.proxyMethods.get(method);
        if (proxyMethod == null) {
            proxyMethod = new ProxyMethod(method);
            this.proxyMethods.put(method, proxyMethod);
        }
        return proxyMethod.invoke(mBeanServerConnection, objectName, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Object object, String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeName cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.attrMethods == null) {
                this.parse();
            }
        }
        object2 = this.attrMethods.get(string);
        if (object2 != null && ((AttributeMethod)object2).getter != null) {
            try {
                Object object3 = ((AttributeMethod)object2).getter.invoke(object, new Object[0]);
                return MappedMXBeanType.toOpenTypeData(object3, ((AttributeMethod)object2).getType());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw MXBeanSupport.unwrapException(invocationTargetException, "when getting attribute " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(illegalAccessException, "IllegalAccessException when getting attribute " + string);
            }
            catch (Exception exception) {
                throw new MBeanException(exception, "Exception thrown when  getting attribute " + string);
            }
        }
        throw new AttributeNotFoundException("Attribute " + string + " does not exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Object object, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.attrMethods == null) {
                this.parse();
            }
        }
        object2 = this.attrMethods.get(attribute.getName());
        if (object2 != null && ((AttributeMethod)object2).setter != null) {
            try {
                Object object3 = MappedMXBeanType.toJavaTypeData(attribute.getValue(), ((AttributeMethod)object2).getType());
                ((AttributeMethod)object2).setter.invoke(object, object3);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw MXBeanSupport.unwrapException(invocationTargetException, "when setting attribute " + attribute.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(illegalAccessException, "IllegalAccessException when setting attribute " + attribute.getName());
            }
            catch (Exception exception) {
                throw new MBeanException(exception, "Exception thrown when  setting attribute " + attribute.getName());
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + attribute.getName() + " does not exist.");
        }
    }

    public AttributeList getAttributes(Object object, String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                Object object2 = this.getAttribute(object, stringArray[i2]);
                attributeList.add(new Attribute(stringArray[i2], object2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(Object object, AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        AttributeList attributeList2 = new AttributeList();
        if (attributeList.isEmpty()) {
            return attributeList2;
        }
        MXBeanSupport mXBeanSupport = this;
        synchronized (mXBeanSupport) {
            if (this.attrMethods == null) {
                this.parse();
            }
        }
        for (Attribute attribute : attributeList) {
            try {
                this.setAttribute(object, attribute);
                String string = attribute.getName();
                Object object2 = this.getAttribute(object, string);
                attributeList2.add(new Attribute(string, object2));
            }
            catch (Exception exception) {}
        }
        return attributeList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Exception occured trying to invoke the operation on the MBean");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.opMethods == null) {
                this.parse();
            }
        }
        object2 = this.opMethods.get(string);
        if (object2 != null) {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                try {
                    Type[] typeArray = method.getGenericParameterTypes();
                    int n2 = objectArray == null ? 0 : objectArray.length;
                    int n3 = stringArray == null ? 0 : stringArray.length;
                    Object[] objectArray2 = new Object[n2];
                    if (typeArray.length != n2 || typeArray.length != n3) continue;
                    boolean bl2 = true;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        MappedMXBeanType mappedMXBeanType = MappedMXBeanType.getMappedType(typeArray[i2]);
                        String string2 = mappedMXBeanType.getMappedTypeClass().getName();
                        if (!stringArray[i2].equals(string2)) {
                            bl2 = false;
                            break;
                        }
                        objectArray2[i2] = mappedMXBeanType.toJavaTypeData(objectArray[i2]);
                    }
                    if (!bl2) continue;
                    Object object3 = method.invoke(object, objectArray2);
                    return MappedMXBeanType.toOpenTypeData(object3, method.getGenericReturnType());
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw MXBeanSupport.unwrapException(invocationTargetException, "when invoking operation " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ReflectionException(illegalAccessException, "IllegalAccessException when invoking operation " + string);
                }
                catch (Exception exception) {
                    throw new MBeanException(exception, "Exception thrown when  invoking operation " + string);
                }
            }
        }
        throw new ReflectionException(new NoSuchMethodException("Operation " + string + " does not exist."));
    }

    private static MBeanAttributeInfo[] buildAttributeInfoArray(Map<String, AttributeMethod> map) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[map.size()];
        int n2 = 0;
        for (AttributeMethod attributeMethod : map.values()) {
            MappedMXBeanType mappedMXBeanType;
            try {
                mappedMXBeanType = MappedMXBeanType.getMappedType(attributeMethod.getType());
            }
            catch (OpenDataException openDataException) {
                throw Util.newInternalError(openDataException);
            }
            mBeanAttributeInfoArray[n2++] = new MBeanAttributeInfo(attributeMethod.getName(), mappedMXBeanType.getTypeName(), attributeMethod.getName(), attributeMethod.isReadable(), attributeMethod.isWriteable(), attributeMethod.isIs());
        }
        return mBeanAttributeInfoArray;
    }

    private static MBeanOperationInfo[] buildOperationInfoArray(Map<String, List<Method>> map, int n2) {
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[n2];
        int n3 = 0;
        for (List<Method> list : map.values()) {
            for (Method method : list) {
                MappedMXBeanType mappedMXBeanType;
                try {
                    mappedMXBeanType = MappedMXBeanType.getMappedType(method.getGenericReturnType());
                }
                catch (OpenDataException openDataException) {
                    throw Util.newInternalError(openDataException);
                }
                Type[] typeArray = method.getGenericParameterTypes();
                MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[typeArray.length];
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    MappedMXBeanType mappedMXBeanType2;
                    String string;
                    String string2 = string = "p" + i2;
                    try {
                        mappedMXBeanType2 = MappedMXBeanType.getMappedType(typeArray[i2]);
                    }
                    catch (OpenDataException openDataException) {
                        throw Util.newInternalError(openDataException);
                    }
                    mBeanParameterInfoArray[i2] = new MBeanParameterInfo(string, mappedMXBeanType2.getTypeName(), string2);
                }
                mBeanOperationInfoArray[n3++] = new MBeanOperationInfo(method.getName(), method.getName(), mBeanParameterInfoArray, mappedMXBeanType.getTypeName(), 2);
            }
        }
        assert (n3 == n2);
        return mBeanOperationInfoArray;
    }

    private static MBeanException unwrapException(InvocationTargetException invocationTargetException, String string) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return new MBeanException((Exception)throwable, "Exception thrown " + string);
    }

    static class AttributeMethod {
        String attributeName;
        Method getter;
        Method setter;

        AttributeMethod(String string) {
            this.attributeName = string;
            this.getter = null;
            this.setter = null;
        }

        void setGetterMethod(Method method) {
            if (this.getter != null) {
                throw new AssertionError((Object)("Getter already exists: " + this.getter.getName() + " of type " + this.getter.getReturnType().getName()));
            }
            if (this.setter != null) {
                Class<?> clazz = this.setter.getParameterTypes()[0];
                Class<?> clazz2 = method.getReturnType();
                if (!clazz.getName().equals(clazz2.getName())) {
                    throw new AssertionError((Object)("Mismatched attribute type " + method.getName() + "()" + clazz2.getName() + this.setter.getName() + "(" + clazz.getName() + ")"));
                }
            }
            this.getter = method;
        }

        void setSetterMethod(Method method) {
            if (this.setter != null) {
                throw new AssertionError((Object)("Setter already exists: " + this.setter.getName()));
            }
            if (this.getter != null) {
                Class<?> clazz = this.getter.getReturnType();
                Class<?> clazz2 = method.getParameterTypes()[0];
                if (!clazz2.getName().equals(clazz.getName())) {
                    throw new AssertionError((Object)("Mismatched attribute type " + method.getName() + "()" + clazz.getName() + this.setter.getName() + "(" + clazz2.getName() + ")"));
                }
            }
            this.setter = method;
        }

        String getName() {
            return this.attributeName;
        }

        Type getType() {
            if (this.getter != null) {
                return this.getter.getGenericReturnType();
            }
            return this.setter.getGenericParameterTypes()[0];
        }

        boolean isReadable() {
            return this.getter != null;
        }

        boolean isWriteable() {
            return this.setter != null;
        }

        boolean isIs() {
            return this.getter != null && this.getter.getName().startsWith("is");
        }
    }

    static class ProxyMethod {
        Method method;
        String name;
        boolean isSetter;
        boolean isGetter;
        Type returnType;
        Type[] paramTypes;
        String[] openParamTypeSignatures;

        ProxyMethod(Method method) throws OpenDataException {
            this.method = method;
            this.isGetter = MXBeanSupport.isGetter(method);
            this.isSetter = MXBeanSupport.isSetter(method);
            if (this.isGetter) {
                this.name = MXBeanSupport.getAttributeName(method);
                this.returnType = method.getGenericReturnType();
                this.paramTypes = NO_PARAMS;
            } else if (this.isSetter) {
                this.name = MXBeanSupport.getAttributeName(method);
                this.paramTypes = method.getGenericParameterTypes();
            } else {
                this.name = this.method.getName();
                this.paramTypes = method.getGenericParameterTypes();
                this.returnType = method.getGenericReturnType();
            }
            this.openParamTypeSignatures = new String[this.paramTypes.length];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                MappedMXBeanType mappedMXBeanType = MappedMXBeanType.getMappedType(this.paramTypes[i2]);
                this.openParamTypeSignatures[i2] = mappedMXBeanType.getMappedTypeClass().getName();
            }
        }

        Object invoke(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Object[] objectArray) throws Throwable {
            try {
                if (this.isGetter) {
                    Object object = mBeanServerConnection.getAttribute(objectName, this.name);
                    return MappedMXBeanType.toJavaTypeData(object, this.returnType);
                }
                if (this.isSetter) {
                    Object object = MappedMXBeanType.toOpenTypeData(objectArray[0], this.paramTypes[0]);
                    Attribute attribute = new Attribute(this.name, object);
                    mBeanServerConnection.setAttribute(objectName, attribute);
                    return null;
                }
                int n2 = objectArray == null ? 0 : objectArray.length;
                Object[] objectArray2 = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray2[i2] = MappedMXBeanType.toOpenTypeData(objectArray[i2], this.paramTypes[i2]);
                }
                Object object = mBeanServerConnection.invoke(objectName, this.name, objectArray2, this.openParamTypeSignatures);
                return MappedMXBeanType.toJavaTypeData(object, this.returnType);
            }
            catch (MBeanException mBeanException) {
                throw mBeanException.getTargetException();
            }
            catch (JMRuntimeException jMRuntimeException) {
                Throwable throwable = jMRuntimeException.getCause();
                while (throwable instanceof JMRuntimeException) {
                    throwable = throwable.getCause();
                }
                throw throwable;
            }
        }
    }
}

