/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbcObject;

public class JdbcOdbcBoundArrayOfParams
extends JdbcOdbcObject {
    protected int numParams;
    protected Hashtable hashedLenIdx;
    protected Object[] storedParams;
    protected int[] paramLenIdx;
    protected Object[][] storedInputStreams;
    protected Object[][] paramSets;
    protected int[][] paramLenIdxSets;
    protected int batchSize;

    public JdbcOdbcBoundArrayOfParams(int n2) {
        this.numParams = n2;
        this.initialize();
    }

    public void initialize() {
        this.storedParams = new Object[this.numParams];
        this.paramLenIdx = new int[this.numParams];
        this.hashedLenIdx = new Hashtable();
        this.batchSize = 0;
        for (int i2 = 0; i2 < this.numParams; ++i2) {
            this.paramLenIdx[i2] = -5;
        }
    }

    public void storeValue(int n2, Object object, int n3) {
        this.storedParams[n2] = object;
        this.paramLenIdx[n2] = n3;
    }

    public void clearParameterSet() {
        if (this.storedParams != null) {
            for (int i2 = 0; i2 < this.numParams; ++i2) {
                this.storedParams[i2] = new Object();
                this.paramLenIdx[i2] = -5;
            }
        }
    }

    public Object[] getStoredParameterSet() {
        Object[] objectArray = new Object[]{};
        if (this.storedParams != null) {
            objectArray = new Object[this.numParams];
            try {
                for (int i2 = 0; i2 < this.numParams; ++i2) {
                    objectArray[i2] = this.storedParams[i2];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    public void storeRowIndex(int n2, int[] nArray) {
        this.hashedLenIdx.put(new Integer(n2), nArray);
    }

    public int[] getStoredRowIndex(int n2) {
        return (int[])this.hashedLenIdx.get(new Integer(n2));
    }

    public void clearStoredRowIndexs() {
        if (!this.hashedLenIdx.isEmpty()) {
            this.hashedLenIdx.clear();
        }
    }

    public int[] getStoredIndexSet() {
        int[] nArray = new int[]{};
        if (this.paramLenIdx != null) {
            nArray = new int[this.numParams];
            try {
                for (int i2 = 0; i2 < this.numParams; ++i2) {
                    nArray[i2] = this.paramLenIdx[i2];
                    if (nArray[i2] != -5) continue;
                    nArray = new int[]{};
                    return nArray;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return nArray;
    }

    public void builtColumWiseParameteSets(int n2, Vector vector) {
        int[] nArray = new int[]{};
        Object[] objectArray = new Object[]{};
        this.batchSize = n2;
        if (vector.size() == this.batchSize) {
            this.storedInputStreams = new Object[this.batchSize][this.numParams];
            this.paramSets = new Object[this.batchSize][this.numParams];
            this.paramLenIdxSets = new int[this.batchSize][this.numParams];
            for (int i2 = 0; i2 < this.batchSize; ++i2) {
                nArray = this.getStoredRowIndex(i2);
                objectArray = (Object[])vector.elementAt(i2);
                for (int i3 = 0; i3 < this.numParams; ++i3) {
                    this.paramSets[i2][i3] = objectArray[i3];
                    this.paramLenIdxSets[i2][i3] = nArray[i3];
                }
            }
        }
    }

    public Object[] getColumnWiseParamSet(int n2) {
        Object[] objectArray = new Object[this.batchSize];
        if (this.paramSets != null) {
            for (int i2 = 0; i2 < this.batchSize; ++i2) {
                objectArray[i2] = this.paramSets[i2][n2 - 1];
            }
        }
        return objectArray;
    }

    public int[] getColumnWiseIndexArray(int n2) {
        int[] nArray = new int[this.batchSize];
        if (this.paramLenIdxSets != null) {
            for (int i2 = 0; i2 < this.batchSize; ++i2) {
                nArray[i2] = this.paramLenIdxSets[i2][n2 - 1];
            }
        }
        return nArray;
    }

    public void setInputStreamElements(int n2, Object[] objectArray) {
        if (n2 >= 1 && n2 <= this.numParams && this.storedInputStreams != null && objectArray != null) {
            for (int i2 = 0; i2 < this.batchSize; ++i2) {
                this.storedInputStreams[i2][n2 - 1] = objectArray[i2];
            }
        }
    }

    public InputStream getInputStreamElement(int n2, int n3) {
        InputStream inputStream = null;
        if (n2 >= 1 && n2 <= this.numParams && n3 >= 1 && n3 <= this.batchSize) {
            inputStream = (InputStream)this.storedInputStreams[n3 - 1][n2 - 1];
        }
        return inputStream;
    }

    public int getElementLength(int n2, int n3) {
        return this.paramLenIdxSets[n3 - 1][n2 - 1];
    }
}

