/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.HashMap;
import sun.io.CharToByteConverter;
import sun.io.MalformedInputException;

class XMap {
    private static HashMap xMappers = new HashMap();
    char[] convertedGlyphs;
    static final int SINGLE_BYTE = 1;
    static final int DOUBLE_BYTE = 2;

    static synchronized XMap getXMapper(String string) {
        XMap xMap = (XMap)xMappers.get(string);
        if (xMap == null) {
            xMap = XMap.getXMapperInternal(string);
            xMappers.put(string, xMap);
        }
        return xMap;
    }

    private static XMap getXMapperInternal(String string) {
        String string2 = null;
        int n2 = 1;
        int n3 = 65535;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.equals("dingbats")) {
            string2 = "awt.motif.CharToByteX11Dingbats";
            n4 = 9985;
            n3 = 10174;
        } else if (string.equals("symbol")) {
            string2 = "awt.CharToByteSymbol";
            n4 = 913;
            n3 = 8943;
        } else if (string.equals("iso8859-1")) {
            n3 = 255;
        } else if (string.equals("iso8859-2")) {
            string2 = "io.CharToByteISO8859_2";
        } else if (string.equals("jisx0208.1983-0")) {
            string2 = "awt.motif.CharToByteX11JIS0208";
            n2 = 2;
        } else if (string.equals("jisx0201.1976-0")) {
            string2 = "awt.motif.CharToByteX11JIS0201";
            bl2 = true;
            bl3 = true;
        } else if (string.equals("jisx0212.1990-0")) {
            string2 = "awt.motif.CharToByteX11JIS0212";
            n2 = 2;
        } else if (string.equals("iso8859-4")) {
            string2 = "io.CharToByteISO8859_4";
        } else if (string.equals("iso8859-5")) {
            string2 = "io.CharToByteISO8859_5";
        } else if (string.equals("koi8-r")) {
            string2 = "io.CharToByteKOI8_R";
        } else if (string.equals("ansi-1251")) {
            string2 = "io.CharToByteCp1251";
        } else if (string.equals("iso8859-6")) {
            string2 = "io.CharToByteISO8859_6";
        } else if (string.equals("iso8859-7")) {
            string2 = "io.CharToByteISO8859_7";
        } else if (string.equals("iso8859-8")) {
            string2 = "io.CharToByteISO8859_8";
        } else if (string.equals("iso8859-9")) {
            string2 = "io.CharToByteISO8859_9";
        } else if (string.equals("iso8859-13")) {
            string2 = "io.CharToByteISO8859_13";
        } else if (string.equals("iso8859-15")) {
            string2 = "io.CharToByteISO8859_15";
        } else if (string.equals("ksc5601.1987-0")) {
            string2 = "awt.motif.CharToByteX11KSC5601";
            n2 = 2;
        } else if (string.equals("ksc5601.1992-3")) {
            string2 = "awt.motif.CharToByteX11Johab";
            n2 = 2;
        } else if (string.equals("ksc5601.1987-1")) {
            string2 = "io.CharToByteEUC_KR";
            n2 = 2;
        } else if (string.equals("cns11643-1")) {
            string2 = "awt.motif.CharToByteX11CNS11643P1";
            n2 = 2;
        } else if (string.equals("cns11643-2")) {
            string2 = "awt.motif.CharToByteX11CNS11643P2";
            n2 = 2;
        } else if (string.equals("cns11643-3")) {
            string2 = "awt.motif.CharToByteX11CNS11643P3";
            n2 = 2;
        } else if (string.equals("gb2312.1980-0")) {
            string2 = "awt.motif.CharToByteX11GB2312";
            n2 = 2;
        } else if (string.indexOf("big5") >= 0) {
            string2 = "io.CharToByteBig5";
            n2 = 2;
            bl2 = true;
        } else if (string.equals("tis620.2533-0")) {
            string2 = "io.CharToByteTIS620";
        } else if (string.equals("gbk-0")) {
            string2 = "awt.motif.CharToByteX11GBK";
            n2 = 2;
        } else if (string.indexOf("sun.unicode-0") >= 0) {
            string2 = "awt.motif.CharToByteX11SunUnicode_0";
            n2 = 2;
        } else if (string.indexOf("gb18030.2000-1") >= 0) {
            string2 = "awt.motif.CharToByteX11GB18030_1";
            n2 = 2;
        } else if (string.indexOf("gb18030.2000-0") >= 0) {
            string2 = "awt.motif.CharToByteX11GB18030_0";
            n2 = 2;
        } else if (string.indexOf("hkscs") >= 0) {
            string2 = "io.CharToByteHKSCS";
            n2 = 2;
        }
        if (string2 != null) {
            string2 = "sun." + string2;
        }
        return new XMap(string2, n4, n3, n2, bl2, bl3);
    }

    private XMap(String string, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        int n5;
        int n6;
        Class<?> clazz = null;
        CharToByteConverter charToByteConverter = null;
        if (string != null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            this.convertedGlyphs = new char[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                this.convertedGlyphs[i2] = (char)i2;
            }
            return;
        }
        try {
            charToByteConverter = (CharToByteConverter)clazz.newInstance();
            charToByteConverter.setSubstitutionBytes(new byte[n4]);
        }
        catch (Exception exception) {
            this.convertedGlyphs = new char[256];
            for (int n7 = 0; n7 < 256; n7 = (int)((char)(n7 + 1))) {
                this.convertedGlyphs[n7] = n7;
            }
            return;
        }
        int n8 = n3 - n2 + 1;
        byte[] byArray = new byte[n8 * n4];
        char[] cArray = new char[n8];
        for (n6 = 0; n6 < n8; ++n6) {
            cArray[n6] = (char)(n2 + n6);
        }
        n6 = 0;
        if (n4 > 1 && n2 < 256) {
            n6 = 256 - n2;
        }
        boolean bl4 = false;
        while (!bl4) {
            try {
                n5 = charToByteConverter.convert(cArray, n6, n8, byArray, n6 * n4, n8 * n4);
                bl4 = true;
            }
            catch (MalformedInputException malformedInputException) {
                n6 = charToByteConverter.nextCharIndex() + 1;
            }
            catch (Exception exception) {
                bl4 = true;
            }
        }
        this.convertedGlyphs = new char[65536];
        for (n5 = 0; n5 < n8; ++n5) {
            this.convertedGlyphs[n5 + n2] = n4 == 1 ? (char)(byArray[n5] & 0xFF) : (char)(((byArray[n5 * 2] & 0xFF) << 8) + (byArray[n5 * 2 + 1] & 0xFF));
        }
        int n9 = n8 = bl3 ? 128 : 256;
        if (bl2 && this.convertedGlyphs.length >= 256) {
            for (int i3 = 0; i3 < n8; ++i3) {
                if (this.convertedGlyphs[i3] != '\u0000') continue;
                this.convertedGlyphs[i3] = (char)i3;
            }
        }
    }
}

