/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.security.AccessController;
import sun.font.CharToGlyphMapper;
import sun.font.CompositeGlyphMapper;
import sun.font.CompositeStrike;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalFont;
import sun.security.action.GetPropertyAction;

public final class CompositeFont
extends Font2D {
    private boolean[] deferredInitialisation;
    String[] componentFileNames;
    String[] componentNames;
    private PhysicalFont[] components;
    int numSlots;
    int numMetricsSlots;
    int[] exclusionRanges;
    int[] maxIndices;
    int numGlyphs = 0;
    boolean isStdComposite = true;

    public CompositeFont(String string, String[] stringArray, String[] stringArray2, int n2, int[] nArray, int[] nArray2, boolean bl2) {
        int n3;
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.componentFileNames = stringArray;
        this.componentNames = stringArray2;
        this.numSlots = stringArray2 == null ? this.componentFileNames.length : this.componentNames.length;
        this.numMetricsSlots = n2;
        this.exclusionRanges = nArray;
        this.maxIndices = nArray2;
        if (FontManager.eudcFont != null) {
            ++this.numSlots;
            if (this.componentNames != null) {
                this.componentNames = new String[this.numSlots];
                System.arraycopy(stringArray2, 0, this.componentNames, 0, this.numSlots - 1);
                this.componentNames[this.numSlots - 1] = FontManager.eudcFont.getFontName(null);
            }
            if (this.componentFileNames != null) {
                this.componentFileNames = new String[this.numSlots];
                System.arraycopy(stringArray, 0, this.componentFileNames, 0, this.numSlots - 1);
            }
            this.components = new PhysicalFont[this.numSlots];
            this.components[this.numSlots - 1] = FontManager.eudcFont;
            this.deferredInitialisation = new boolean[this.numSlots];
            if (bl2) {
                for (n3 = 0; n3 < this.numSlots - 1; ++n3) {
                    this.deferredInitialisation[n3] = true;
                }
            }
        } else {
            this.components = new PhysicalFont[this.numSlots];
            this.deferredInitialisation = new boolean[this.numSlots];
            if (bl2) {
                for (n3 = 0; n3 < this.numSlots; ++n3) {
                    this.deferredInitialisation[n3] = true;
                }
            }
        }
        this.fontRank = 2;
        n3 = this.fullName.indexOf(46);
        if (n3 > 0) {
            this.familyName = this.fullName.substring(0, n3);
            if (n3 + 1 < this.fullName.length()) {
                String string2 = this.fullName.substring(n3 + 1);
                if ("plain".equals(string2)) {
                    this.style = 0;
                } else if ("bold".equals(string2)) {
                    this.style = 1;
                } else if ("italic".equals(string2)) {
                    this.style = 2;
                } else if ("bolditalic".equals(string2)) {
                    this.style = 3;
                }
            }
        } else {
            this.familyName = this.fullName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompositeFont(PhysicalFont physicalFont, CompositeFont compositeFont) {
        this.handle = new Font2DHandle(this);
        this.fullName = physicalFont.fullName;
        this.familyName = physicalFont.familyName;
        this.style = physicalFont.style;
        this.numMetricsSlots = 1;
        this.numSlots = compositeFont.numSlots + 1;
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            this.components = new PhysicalFont[this.numSlots];
            this.components[0] = physicalFont;
            System.arraycopy(compositeFont.components, 0, this.components, 1, compositeFont.numSlots);
            if (compositeFont.componentNames != null) {
                this.componentNames = new String[this.numSlots];
                this.componentNames[0] = physicalFont.fullName;
                System.arraycopy(compositeFont.componentNames, 0, this.componentNames, 1, compositeFont.numSlots);
            }
            if (compositeFont.componentFileNames != null) {
                this.componentFileNames = new String[this.numSlots];
                this.componentFileNames[0] = null;
                System.arraycopy(compositeFont.componentFileNames, 0, this.componentFileNames, 1, compositeFont.numSlots);
            }
            this.deferredInitialisation = new boolean[this.numSlots];
            this.deferredInitialisation[0] = false;
            System.arraycopy(compositeFont.deferredInitialisation, 0, this.deferredInitialisation, 1, compositeFont.numSlots);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeferredInitialisation(int n2) {
        if (!this.deferredInitialisation[n2]) {
            return;
        }
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (this.componentNames == null) {
                this.componentNames = new String[this.numSlots];
            }
            if (this.components[n2] == null) {
                if (this.componentFileNames != null && this.componentFileNames[n2] != null) {
                    this.components[n2] = FontManager.initialiseDeferredFont(this.componentFileNames[n2]);
                }
                if (this.components[n2] == null) {
                    this.components[n2] = FontManager.getDefaultPhysicalFont();
                }
                String string = this.components[n2].getFontName(null);
                if (this.componentNames[n2] == null) {
                    this.componentNames[n2] = string;
                } else if (!this.componentNames[n2].equalsIgnoreCase(string)) {
                    this.components[n2] = (PhysicalFont)FontManager.findFont2D(this.componentNames[n2], this.style, 1);
                }
            }
            this.deferredInitialisation[n2] = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void replaceComponentFont(PhysicalFont physicalFont, PhysicalFont physicalFont2) {
        if (this.components == null) {
            return;
        }
        for (int i2 = 0; i2 < this.numSlots; ++i2) {
            if (this.components[i2] != physicalFont) continue;
            this.components[i2] = physicalFont2;
            if (this.componentNames == null) continue;
            this.componentNames[i2] = physicalFont2.getFontName(null);
        }
    }

    public boolean isExcludedChar(int n2, int n3) {
        if (this.exclusionRanges == null || this.maxIndices == null || n2 >= this.numMetricsSlots) {
            return false;
        }
        int n4 = 0;
        int n5 = this.maxIndices[n2];
        if (n2 > 0) {
            n4 = this.maxIndices[n2 - 1];
        }
        for (int i2 = n4; n5 > i2; i2 += 2) {
            if (n3 < this.exclusionRanges[i2] || n3 > this.exclusionRanges[i2 + 1]) continue;
            return true;
        }
        return false;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public PhysicalFont getSlotFont(int n2) {
        if (this.deferredInitialisation[n2]) {
            this.doDeferredInitialisation(n2);
        }
        try {
            PhysicalFont physicalFont = this.components[n2];
            if (physicalFont == null) {
                try {
                    this.components[n2] = physicalFont = (PhysicalFont)FontManager.findFont2D(this.componentNames[n2], this.style, 1);
                }
                catch (ClassCastException classCastException) {
                    physicalFont = FontManager.getDefaultPhysicalFont();
                }
            }
            return physicalFont;
        }
        catch (Exception exception) {
            return FontManager.getDefaultPhysicalFont();
        }
    }

    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        return new CompositeStrike(this, fontStrikeDesc);
    }

    public boolean isStdComposite() {
        return this.isStdComposite;
    }

    protected int getValidatedGlyphCode(int n2) {
        int n3 = n2 >>> 24;
        if (n3 >= this.numSlots) {
            return this.getMapper().getMissingGlyphCode();
        }
        int n4 = n2 & 0xFFFFFF;
        PhysicalFont physicalFont = this.getSlotFont(n3);
        if (physicalFont.getValidatedGlyphCode(n4) == physicalFont.getMissingGlyphCode()) {
            return this.getMapper().getMissingGlyphCode();
        }
        return n2;
    }

    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    public int getNumGlyphs() {
        if (this.numGlyphs == 0) {
            this.numGlyphs = this.getMapper().getNumGlyphs();
        }
        return this.numGlyphs;
    }

    public int getMissingGlyphCode() {
        return this.getMapper().getMissingGlyphCode();
    }

    public boolean canDisplay(char c2) {
        return this.getMapper().canDisplay(c2);
    }

    public String toString() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        String string2 = "";
        for (int i2 = 0; i2 < this.numSlots; ++i2) {
            string2 = string2 + "    Slot[" + i2 + "]=" + this.getSlotFont(i2) + string;
        }
        return "** Composite Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + string + string2;
    }
}

