/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import sun.font.FontManager;
import sun.font.TrueTypeFont;
import sun.io.ByteToCharConverter;

abstract class CMap {
    static final short ShiftJISEncoding = 2;
    static final short GBKEncoding = 3;
    static final short Big5Encoding = 4;
    static final short WansungEncoding = 5;
    static final short JohabEncoding = 6;
    static final short MSUnicodeSurrogateEncoding = 10;
    static final char noSuchChar = '\ufffd';
    static final int SHORTMASK = 65535;
    static final int INTMASK = -1;
    static final char[][] converterMaps = new char[7][];
    char[] xlat;
    public static final NullCMapClass theNullCmap = new NullCMapClass();

    CMap() {
    }

    static CMap initialize(TrueTypeFont trueTypeFont) {
        CMap cMap = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl2 = false;
        ByteBuffer byteBuffer = trueTypeFont.getTableBuffer(1668112752);
        int n11 = trueTypeFont.getTableSize(1668112752);
        int n12 = byteBuffer.getShort(2);
        block10: for (int i2 = 0; i2 < n12; ++i2) {
            byteBuffer.position(i2 * 8 + 4);
            short s2 = byteBuffer.getShort();
            if (s2 != 3) continue;
            bl2 = true;
            n2 = byteBuffer.getShort();
            int n13 = byteBuffer.getInt();
            switch (n2) {
                case 0: {
                    n3 = n13;
                    continue block10;
                }
                case 1: {
                    n4 = n13;
                    continue block10;
                }
                case 2: {
                    n5 = n13;
                    continue block10;
                }
                case 3: {
                    n6 = n13;
                    continue block10;
                }
                case 4: {
                    n7 = n13;
                    continue block10;
                }
                case 5: {
                    n8 = n13;
                    continue block10;
                }
                case 6: {
                    n9 = n13;
                    continue block10;
                }
                case 10: {
                    n10 = n13;
                }
            }
        }
        if (bl2) {
            if (n10 != 0) {
                cMap = CMap.createCMap(byteBuffer, n10, null);
            } else if (n3 != 0) {
                cMap = CMap.createCMap(byteBuffer, n3, null);
            } else if (n4 != 0) {
                cMap = CMap.createCMap(byteBuffer, n4, null);
            } else if (n5 != 0) {
                cMap = CMap.createCMap(byteBuffer, n5, CMap.getConverterMap((short)2));
            } else if (n6 != 0) {
                cMap = CMap.createCMap(byteBuffer, n6, CMap.getConverterMap((short)3));
            } else if (n7 != 0) {
                cMap = FontManager.isSolaris && trueTypeFont.platName != null && (trueTypeFont.platName.startsWith("/usr/openwin/lib/locale/zh_CN.EUC/X11/fonts/TrueType") || trueTypeFont.platName.startsWith("/usr/openwin/lib/locale/zh_CN/X11/fonts/TrueType") || trueTypeFont.platName.startsWith("/usr/openwin/lib/locale/zh/X11/fonts/TrueType")) ? CMap.createCMap(byteBuffer, n7, CMap.getConverterMap((short)3)) : CMap.createCMap(byteBuffer, n7, CMap.getConverterMap((short)4));
            } else if (n8 != 0) {
                cMap = CMap.createCMap(byteBuffer, n8, CMap.getConverterMap((short)5));
            } else if (n9 != 0) {
                cMap = CMap.createCMap(byteBuffer, n9, CMap.getConverterMap((short)6));
            }
        } else {
            cMap = CMap.createCMap(byteBuffer, byteBuffer.getInt(8), null);
        }
        return cMap;
    }

    static char[] getConverter(short s2) {
        String string;
        int n2 = 32768;
        int n3 = 65535;
        switch (s2) {
            case 2: {
                n2 = 33088;
                n3 = 64764;
                string = "SJIS";
                break;
            }
            case 3: {
                n2 = 33088;
                n3 = 65184;
                string = "GBK";
                break;
            }
            case 4: {
                n2 = 41280;
                n3 = 65278;
                string = "Big5";
                break;
            }
            case 5: {
                n2 = 41377;
                n3 = 65246;
                string = "EUC_KR";
                break;
            }
            case 6: {
                n2 = 33089;
                n3 = 65022;
                string = "Johab";
                break;
            }
            default: {
                return null;
            }
        }
        try {
            int n4;
            ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverter(string);
            if (byteToCharConverter == null) {
                return null;
            }
            char[] cArray = new char[]{'\u0000'};
            byteToCharConverter.setSubstitutionChars(cArray);
            char[] cArray2 = new char[65536];
            for (int i2 = 0; i2 < 65536; ++i2) {
                cArray2[i2] = 65533;
            }
            byte[] byArray = new byte[(n3 - n2 + 1) * 2];
            char[] cArray3 = new char[n3 - n2 + 1];
            int n5 = 0;
            if (s2 == 2) {
                for (n4 = n2; n4 <= n3; ++n4) {
                    int n6 = n4 >> 8 & 0xFF;
                    if (n6 >= 161 && n6 <= 223) {
                        byArray[n5++] = -1;
                        byArray[n5++] = -1;
                        continue;
                    }
                    byArray[n5++] = (byte)n6;
                    byArray[n5++] = (byte)(n4 & 0xFF);
                }
            } else {
                for (n4 = n2; n4 <= n3; ++n4) {
                    byArray[n5++] = (byte)(n4 >> 8 & 0xFF);
                    byArray[n5++] = (byte)(n4 & 0xFF);
                }
            }
            byteToCharConverter.convert(byArray, 0, byArray.length, cArray3, 0, cArray3.length);
            for (n4 = 32; n4 <= 126; ++n4) {
                cArray2[n4] = (char)n4;
            }
            if (s2 == 2) {
                for (n4 = 161; n4 <= 223; ++n4) {
                    cArray2[n4] = (char)(n4 - 161 + 65377);
                }
            }
            System.arraycopy(cArray3, 0, cArray2, n2, cArray3.length);
            char[] cArray4 = new char[65536];
            for (int i3 = 0; i3 < 65536; ++i3) {
                if (cArray2[i3] == '\ufffd') continue;
                cArray4[cArray2[i3]] = (char)i3;
            }
            return cArray4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static char[] getConverterMap(short s2) {
        if (converterMaps[s2] == null) {
            CMap.converterMaps[s2] = CMap.getConverter(s2);
        }
        return converterMaps[s2];
    }

    static CMap createCMap(ByteBuffer byteBuffer, int n2, char[] cArray) {
        char c2 = byteBuffer.getChar(n2);
        long l2 = c2 < '\b' ? (long)byteBuffer.getChar(n2 + 2) : (long)(byteBuffer.getInt(n2 + 2) & 0xFFFFFFFF);
        if ((long)n2 + l2 > (long)byteBuffer.capacity()) {
            if (FontManager.logging) {
                FontManager.logger.warning("Found unusable Cmap subtable");
            }
            return null;
        }
        switch (c2) {
            case '\u0000': {
                return new CMapFormat0(byteBuffer, n2);
            }
            case '\u0002': {
                return new CMapFormat2(byteBuffer, n2, cArray);
            }
            case '\u0004': {
                return new CMapFormat4(byteBuffer, n2, cArray);
            }
            case '\u0006': {
                return new CMapFormat6(byteBuffer, n2, cArray);
            }
            case '\b': {
                return new CMapFormat8(byteBuffer, n2, cArray);
            }
            case '\n': {
                return new CMapFormat10(byteBuffer, n2, cArray);
            }
            case '\f': {
                return new CMapFormat12(byteBuffer, n2, cArray);
            }
        }
        throw new RuntimeException("Cmap format unimplemented: " + byteBuffer.getChar(n2));
    }

    abstract char getGlyph(int var1);

    final int getControlCodeGlyph(int n2, boolean bl2) {
        if (n2 < 16) {
            switch (n2) {
                case 9: 
                case 10: 
                case 13: {
                    return 65535;
                }
            }
        } else if (n2 >= 8204) {
            if (n2 <= 8207 || n2 >= 8232 && n2 <= 8238 || n2 >= 8298 && n2 <= 8303) {
                return 65535;
            }
            if (bl2 && n2 >= 65535) {
                return 0;
            }
        }
        return -1;
    }

    static class CMapFormat0
    extends CMap {
        byte[] cmap;

        CMapFormat0(ByteBuffer byteBuffer, int n2) {
            char c2 = byteBuffer.getChar(n2 + 2);
            this.cmap = new byte[c2 - 6];
            byteBuffer.position(n2 + 6);
            byteBuffer.get(this.cmap);
        }

        char getGlyph(int n2) {
            if (n2 < 256) {
                if (n2 < 16) {
                    switch (n2) {
                        case 9: 
                        case 10: 
                        case 13: {
                            return '\uffff';
                        }
                    }
                }
                return (char)(0xFF & this.cmap[n2]);
            }
            return '\u0000';
        }
    }

    static class CMapFormat10
    extends CMap {
        long firstCode;
        int entryCount;
        char[] glyphIdArray;

        CMapFormat10(ByteBuffer byteBuffer, int n2, char[] cArray) {
            System.err.println("WARNING: CMapFormat10 is untested.");
            this.firstCode = byteBuffer.getInt() & 0xFFFFFFFF;
            this.entryCount = byteBuffer.getInt() & 0xFFFFFFFF;
            byteBuffer.position(n2 + 20);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            this.glyphIdArray = new char[this.entryCount];
            for (int i2 = 0; i2 < this.entryCount; ++i2) {
                this.glyphIdArray[i2] = charBuffer.get();
            }
        }

        char getGlyph(int n2) {
            if (this.xlat != null) {
                throw new RuntimeException("xlat array for cmap fmt=10");
            }
            int n3 = (int)((long)n2 - this.firstCode);
            if (n3 < 0 || n3 >= this.entryCount) {
                return '\u0000';
            }
            return this.glyphIdArray[n3];
        }
    }

    static class CMapFormat12
    extends CMap {
        int numGroups;
        int highBit = 0;
        int power;
        int extra;
        long[] startCharCode;
        long[] endCharCode;
        int[] startGlyphID;

        CMapFormat12(ByteBuffer byteBuffer, int n2, char[] cArray) {
            int n3;
            if (cArray != null) {
                throw new RuntimeException("xlat array for cmap fmt=12");
            }
            this.numGroups = byteBuffer.getInt(n2 + 12);
            this.startCharCode = new long[this.numGroups];
            this.endCharCode = new long[this.numGroups];
            this.startGlyphID = new int[this.numGroups];
            byteBuffer.position(n2 + 16);
            byteBuffer = byteBuffer.slice();
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (n3 = 0; n3 < this.numGroups; ++n3) {
                this.startCharCode[n3] = intBuffer.get() & 0xFFFFFFFF;
                this.endCharCode[n3] = intBuffer.get() & 0xFFFFFFFF;
                this.startGlyphID[n3] = intBuffer.get() & 0xFFFFFFFF;
            }
            n3 = this.numGroups;
            if (n3 >= 65536) {
                n3 >>= 16;
                this.highBit += 16;
            }
            if (n3 >= 256) {
                n3 >>= 8;
                this.highBit += 8;
            }
            if (n3 >= 16) {
                n3 >>= 4;
                this.highBit += 4;
            }
            if (n3 >= 4) {
                n3 >>= 2;
                this.highBit += 2;
            }
            if (n3 >= 2) {
                n3 >>= 1;
                ++this.highBit;
            }
            this.power = 1 << this.highBit;
            this.extra = this.numGroups - this.power;
        }

        char getGlyph(int n2) {
            int n3 = this.getControlCodeGlyph(n2, false);
            if (n3 >= 0) {
                return (char)n3;
            }
            int n4 = this.power;
            int n5 = 0;
            if (this.startCharCode[this.extra] <= (long)n2) {
                n5 = this.extra;
            }
            while (n4 > 1) {
                if (this.startCharCode[n5 + (n4 >>= 1)] > (long)n2) continue;
                n5 += n4;
            }
            if (this.startCharCode[n5] <= (long)n2 && this.endCharCode[n5] >= (long)n2) {
                return (char)((long)this.startGlyphID[n5] + ((long)n2 - this.startCharCode[n5]));
            }
            return '\u0000';
        }
    }

    static class CMapFormat2
    extends CMap {
        char[] subHeaderKey = new char[256];
        char[] firstCodeArray;
        char[] entryCountArray;
        short[] idDeltaArray;
        char[] idRangeOffSetArray;
        char[] glyphIndexArray;

        CMapFormat2(ByteBuffer byteBuffer, int n2, char[] cArray) {
            int n3;
            int n4;
            this.xlat = cArray;
            char c2 = byteBuffer.getChar(n2 + 2);
            byteBuffer.position(n2 + 6);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            char c3 = '\u0000';
            for (n4 = 0; n4 < 256; ++n4) {
                this.subHeaderKey[n4] = charBuffer.get();
                if (this.subHeaderKey[n4] <= c3) continue;
                c3 = this.subHeaderKey[n4];
            }
            n4 = (c3 >> 3) + 1;
            this.firstCodeArray = new char[n4];
            this.entryCountArray = new char[n4];
            this.idDeltaArray = new short[n4];
            this.idRangeOffSetArray = new char[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.firstCodeArray[n3] = charBuffer.get();
                this.entryCountArray[n3] = charBuffer.get();
                this.idDeltaArray[n3] = (short)charBuffer.get();
                this.idRangeOffSetArray[n3] = charBuffer.get();
            }
            n3 = (c2 - 518 - n4 * 8) / 2;
            this.glyphIndexArray = new char[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                this.glyphIndexArray[i2] = charBuffer.get();
            }
        }

        char getGlyph(int n2) {
            int n3;
            int n4;
            char c2;
            char c3;
            int n5 = this.getControlCodeGlyph(n2, true);
            if (n5 >= 0) {
                return (char)n5;
            }
            if (this.xlat != null) {
                n2 = this.xlat[n2];
            }
            char c4 = (char)(n2 >> 8);
            char c5 = (char)(n2 & 0xFF);
            int n6 = this.subHeaderKey[c4] >> 3;
            if (n6 != 0) {
                c3 = c5;
            } else {
                c3 = c4;
                if (c3 == '\u0000') {
                    c3 = c5;
                }
            }
            char c6 = this.firstCodeArray[n6];
            if (c3 < c6) {
                return '\u0000';
            }
            if ((c3 = (char)(c3 - c6)) < this.entryCountArray[n6] && (c2 = this.glyphIndexArray[(n4 = (this.idRangeOffSetArray[n6] - (n3 = (this.idRangeOffSetArray.length - n6) * 8 - 6)) / 2) + c3]) != '\u0000') {
                c2 = (char)(c2 + this.idDeltaArray[n6]);
                return c2;
            }
            return '\u0000';
        }
    }

    static class CMapFormat4
    extends CMap {
        int segCount;
        int entrySelector;
        int rangeShift;
        char[] endCount;
        char[] startCount;
        short[] idDelta;
        char[] idRangeOffset;
        char[] glyphIds;

        CMapFormat4(ByteBuffer byteBuffer, int n2, char[] cArray) {
            int n3;
            int n4;
            this.xlat = cArray;
            byteBuffer.position(n2);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            charBuffer.get();
            char c2 = charBuffer.get();
            charBuffer.get();
            this.segCount = charBuffer.get() / 2;
            char c3 = charBuffer.get();
            this.entrySelector = charBuffer.get();
            this.rangeShift = charBuffer.get() / 2;
            this.startCount = new char[this.segCount];
            this.endCount = new char[this.segCount];
            this.idDelta = new short[this.segCount];
            this.idRangeOffset = new char[this.segCount];
            for (n4 = 0; n4 < this.segCount; ++n4) {
                this.endCount[n4] = charBuffer.get();
            }
            charBuffer.get();
            for (n4 = 0; n4 < this.segCount; ++n4) {
                this.startCount[n4] = charBuffer.get();
            }
            for (n4 = 0; n4 < this.segCount; ++n4) {
                this.idDelta[n4] = (short)charBuffer.get();
            }
            for (n4 = 0; n4 < this.segCount; ++n4) {
                n3 = charBuffer.get();
                this.idRangeOffset[n4] = (char)(n3 >> 1 & 0xFFFF);
            }
            n4 = (this.segCount * 8 + 16) / 2;
            charBuffer.position(n4);
            n3 = c2 / 2 - n4;
            this.glyphIds = new char[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                this.glyphIds[i2] = charBuffer.get();
            }
        }

        char getGlyph(int n2) {
            int n3 = 0;
            char c2 = '\u0000';
            int n4 = this.getControlCodeGlyph(n2, true);
            if (n4 >= 0) {
                return (char)n4;
            }
            if (this.xlat != null) {
                n2 = this.xlat[n2];
            }
            if (this.startCount[this.rangeShift] <= n2) {
                n3 = this.rangeShift;
            }
            int n5 = this.entrySelector;
            while (n5-- > 0) {
                if (this.startCount[n3 + (1 << n5)] > n2) continue;
                n3 += 1 << n5;
            }
            if (n2 >= this.startCount[n3] && n2 <= this.endCount[n3]) {
                char c3 = this.idRangeOffset[n3];
                if (c3 == '\u0000') {
                    c2 = (char)(n2 + this.idDelta[n3]);
                } else {
                    int n6 = c3 - this.segCount + n3 + (n2 - this.startCount[n3]);
                    c2 = this.glyphIds[n6];
                    if (c2 != '\u0000') {
                        c2 = (char)(c2 + this.idDelta[n3]);
                    }
                }
            }
            if (c2 != '\u0000') {
                // empty if block
            }
            return c2;
        }
    }

    static class CMapFormat6
    extends CMap {
        char firstCode;
        char entryCount;
        char[] glyphIdArray;

        CMapFormat6(ByteBuffer byteBuffer, int n2, char[] cArray) {
            System.err.println("WARNING: CMapFormat8 is untested.");
            byteBuffer.position(n2 + 6);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            this.firstCode = charBuffer.get();
            this.entryCount = charBuffer.get();
            this.glyphIdArray = new char[this.entryCount];
            for (int i2 = 0; i2 < this.entryCount; ++i2) {
                this.glyphIdArray[i2] = charBuffer.get();
            }
        }

        char getGlyph(int n2) {
            int n3 = this.getControlCodeGlyph(n2, true);
            if (n3 >= 0) {
                return (char)n3;
            }
            if (this.xlat != null) {
                n2 = this.xlat[n2];
            }
            if ((n2 -= this.firstCode) < 0 || n2 >= this.entryCount) {
                return '\u0000';
            }
            return this.glyphIdArray[n2];
        }
    }

    static class CMapFormat8
    extends CMap {
        byte[] is32 = new byte[8192];
        int nGroups;
        int[] startCharCode;
        int[] endCharCode;
        int[] startGlyphID;

        CMapFormat8(ByteBuffer byteBuffer, int n2, char[] cArray) {
            System.err.println("WARNING: CMapFormat8 is untested.");
            byteBuffer.position(12);
            byteBuffer.get(this.is32);
            this.nGroups = byteBuffer.getInt();
            this.startCharCode = new int[this.nGroups];
            this.endCharCode = new int[this.nGroups];
            this.startGlyphID = new int[this.nGroups];
        }

        char getGlyph(int n2) {
            if (this.xlat != null) {
                throw new RuntimeException("xlat array for cmap fmt=8");
            }
            return '\u0000';
        }
    }

    static class NullCMapClass
    extends CMap {
        NullCMapClass() {
        }

        char getGlyph(int n2) {
            return '\u0000';
        }
    }
}

