/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.InputEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.WindowPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.DebugHelper;
import sun.awt.EmbeddedFrame;
import sun.awt.Graphics2Delegate;
import sun.awt.KeyboardFocusManagerPeerImpl;
import sun.awt.RepaintArea;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.awt.motif.AWTLockAccess;
import sun.awt.motif.MGlobalCursorManager;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11FontMetrics;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public abstract class MComponentPeer
implements ComponentPeer,
DropTargetPeer,
X11ComponentPeer {
    private static final Logger focusLog = Logger.getLogger("sun.awt.motif.focus.MComponentPeer");
    private static final DebugHelper dbg = DebugHelper.create(MComponentPeer.class);
    Component target;
    long pData;
    long jniGlobalRef;
    protected X11GraphicsConfig graphicsConfig;
    SurfaceData surfaceData;
    int oldWidth = -1;
    int oldHeight = -1;
    private RepaintArea paintArea;
    boolean isLayouting = false;
    boolean paintPending = false;
    private boolean disposed = false;
    private static int JAWT_LOCK_ERROR = 1;
    private static int JAWT_LOCK_CLIP_CHANGED = 2;
    private static int JAWT_LOCK_BOUNDS_CHANGED = 4;
    private static int JAWT_LOCK_SURFACE_CHANGED = 8;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    static final int MOTIF_NA = 0;
    static final int MOTIF_V1 = 1;
    static final int MOTIF_V2 = 2;
    private Font font;
    private long backBuffer = 0L;
    private VolatileImage xBackBuffer = null;
    static final Font defaultFont;
    public int serialNum = 0;

    private static native void initIDs();

    public boolean isObscured() {
        MWindowPeer mWindowPeer;
        Container container;
        Container container2;
        Container container3 = container2 = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        if (container2 == null) {
            return true;
        }
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        if (container2 instanceof Window && (mWindowPeer = (MWindowPeer)container2.getPeer()) != null) {
            return mWindowPeer.winAttr.visibilityState != MWindowAttributes.AWT_UNOBSCURED;
        }
        return true;
    }

    public boolean canDetermineObscurity() {
        return true;
    }

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    void EFcreate(MComponentPeer mComponentPeer, int n2) {
    }

    native void pInitialize();

    native void pShow();

    native void pHide();

    native void pEnable();

    native void pDisable();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pMakeCursorVisible();

    native Point pGetLocationOnScreen();

    native Point pGetLocationOnScreen2(Window var1, MWindowPeer var2);

    native void pSetForeground(Color var1);

    native void pSetBackground(Color var1);

    private native void pSetFont(Font var1);

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    static native Container getParent_NoClientCode(Component var0);

    static native Component[] getComponents_NoClientCode(Container var0);

    void initialize() {
        Font font;
        if (!this.target.isVisible()) {
            this.hide();
        }
        this.pInitialize();
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        this.pSetCursor(this.target.getCursor());
        if (!this.target.isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = this.target.getBounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.show();
        }
        this.surfaceData = this.graphicsConfig.createSurfaceData(this);
    }

    public void init(Component component, Object object) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.create(mComponentPeer, object);
        this.initialize();
    }

    MComponentPeer(Component component, Object object) {
        this.init(component, object);
    }

    MComponentPeer() {
    }

    public void init(Component component) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.create(mComponentPeer);
        if (container != null && container instanceof ScrollPane) {
            MScrollPanePeer mScrollPanePeer = (MScrollPanePeer)mComponentPeer;
            mScrollPanePeer.setScrollChild(this);
        }
        this.initialize();
    }

    MComponentPeer(Component component) {
        this.init(component);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void setForeground(Color color) {
        this.pSetForeground(color);
    }

    public void setBackground(Color color) {
        this.pSetBackground(color);
    }

    public void updateCursorImmediately() {
        MGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    public void setFont(Font font) {
        if (font == null) {
            font = defaultFont;
        }
        this.pSetFont(font);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n2 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n2; ++i2) {
                ComponentPeer componentPeer;
                if (componentArray[i2] == null || (componentPeer = componentArray[i2].getPeer()) == null) continue;
                Font font2 = componentArray[i2].getFont();
                if (!font.equals(font2)) {
                    componentPeer.setFont(font2);
                    continue;
                }
                if (!(componentArray[i2] instanceof Container)) continue;
                componentPeer.setFont(font);
            }
        }
        this.font = font;
    }

    public native void setTargetBackground(Color var1);

    public native void pSetCursor(Cursor var1);

    public native void pSetScrollbarBackground(Color var1);

    public native void pSetInnerForeground(Color var1);

    public boolean isFocusable() {
        return false;
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public ColorModel getColorModel() {
        return this.graphicsConfig.getColorModel();
    }

    public ColorModel getColorModel(int n2) {
        return this.graphicsConfig.getColorModel(n2);
    }

    public int updatePriority() {
        return 5;
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.paint(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.print(graphics);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    native void nativeHandleEvent(AWTEvent var1);

    protected boolean shouldFocusOnClick() {
        return this.isFocusable();
    }

    static boolean canBeFocusedByClick(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDisplayable() && component.isVisible() && component.isEnabled() && component.isFocusable();
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, false);
                }
                return;
            }
            case 501: {
                if (this.target != aWTEvent.getSource() || ((InputEvent)aWTEvent).isConsumed() || !this.shouldFocusOnClick() || this.target.isFocusOwner() || !MComponentPeer.canBeFocusedByClick(this.target)) break;
                this.target.requestFocusInWindow();
                break;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void layout() {
    }

    public Rectangle getBounds() {
        return this.target.getBounds();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public synchronized Graphics getGraphics() {
        if (!this.disposed) {
            Font font;
            Color color;
            Component component = this.target;
            Color color2 = component.getBackground();
            if (color2 == null) {
                color2 = SystemColor.window;
            }
            if ((color = component.getForeground()) == null) {
                color = SystemColor.windowText;
            }
            if ((font = component.getFont()) == null) {
                font = defaultFont;
            }
            return new SunGraphics2D(this.surfaceData, color, color2, font);
        }
        return null;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    public Image createImage(int n2, int n3) {
        return this.graphicsConfig.createAcceleratedImage(this.target, n2, n3);
    }

    public VolatileImage createVolatileImage(int n2, int n3) {
        return new SunVolatileImage(this.target, n2, n3);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n2, n3, imageObserver);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n2, n3, imageObserver);
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    protected void disposeImpl() {
        SurfaceData surfaceData = this.surfaceData;
        this.surfaceData = null;
        surfaceData.invalidate();
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl2 = false;
        if (!this.disposed) {
            MComponentPeer mComponentPeer = this;
            synchronized (mComponentPeer) {
                AWTLockAccess.awtLock();
                try {
                    if (!this.disposed) {
                        bl2 = true;
                        this.disposed = true;
                    }
                }
                finally {
                    AWTLockAccess.awtUnlock();
                }
            }
        }
        if (bl2) {
            this.disposeImpl();
        }
    }

    static native boolean processSynchronousLightweightTransfer(Component var0, Component var1, boolean var2, boolean var3, long var4);

    public boolean requestFocus(Component component, boolean bl2, boolean bl3, long l2) {
        Container container;
        if (MComponentPeer.processSynchronousLightweightTransfer(this.target, component, bl2, bl3, l2)) {
            return true;
        }
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Current native focused window " + MComponentPeer.getNativeFocusedWindow());
        }
        Container container2 = container = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        while (container != null && !(container instanceof Window)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container != null) {
            Window window = (Window)container;
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.finer("Parent window " + window);
            }
            if (!window.isFocused() && MComponentPeer.getNativeFocusedWindow() == window) {
                return true;
            }
            if (MComponentPeer.getNativeFocusedWindow() != window) {
                WindowPeer windowPeer = (WindowPeer)window.getPeer();
                boolean bl4 = windowPeer.requestWindowFocus();
                if (focusLog.isLoggable(Level.FINER)) {
                    focusLog.finer("Requested window focus: " + bl4);
                }
                if (!bl4 || !window.isFocused()) {
                    focusLog.finer("Waiting for asynchronous processing of window focus request");
                    KeyboardFocusManagerPeerImpl.removeLastFocusRequest(this.target);
                    return false;
                }
            }
        }
        return this._requestFocus(component, bl2, bl3, l2);
    }

    native boolean _requestFocus(Component var1, boolean var2, boolean var3, long var4);

    static native Window getNativeFocusedWindow();

    void postEvent(AWTEvent aWTEvent) {
        MToolkit.postEvent(MToolkit.targetToAppContext(this.target), aWTEvent);
    }

    void handleExpose(int n2, int n3, int n4, int n5) {
        if (!this.target.getIgnoreRepaint()) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle(n2, n3, n4, n5)));
        }
    }

    void handleRepaint(int n2, int n3, int n4, int n5) {
        if (!this.target.getIgnoreRepaint()) {
            this.postEvent(new PaintEvent(this.target, 801, new Rectangle(n2, n3, n4, n5)));
        }
    }

    public int getZOrderPosition_NoClientCode() {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        if (container != null) {
            Component[] componentArray = MComponentPeer.getComponents_NoClientCode(container);
            int n2 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] == this.target) {
                    return n2;
                }
                Object object = MToolkit.targetToPeer(componentArray[i2]);
                if (object == null || object instanceof LightweightPeer) continue;
                ++n2;
            }
        }
        return -1;
    }

    void draw3DOval(Graphics graphics, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl2 ? color4 : color3);
        graphics.drawArc(n2, n3, n4, n5, 45, 180);
        graphics.setColor(bl2 ? color3 : color4);
        graphics.drawArc(n2, n3, n4, n5, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl2 ? color4 : color3);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.drawLine(n2 + 1, n3, n2 + n4 - 1, n3);
        graphics.setColor(bl2 ? color3 : color4);
        graphics.drawLine(n2 + 1, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
        graphics.setColor(color2);
    }

    void drawScrollbar(Graphics graphics, Color color, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Color color2 = graphics.getColor();
        double d2 = (double)(n3 - 2 * (n2 - 1)) / (double)Math.max(1, n5 - n4 + n7);
        int n8 = n2 + (int)(d2 * (double)(n6 - n4));
        int n9 = (int)(d2 * (double)n7);
        int n10 = n2 - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n3 < 3 * n10) {
            n9 = 0;
            n8 = 0;
            if (n3 < 2 * n10 + 2) {
                n10 = (n3 - 2) / 2;
            }
        } else if (n9 < 7) {
            n8 = Math.max(0, n8 - (7 - n9 >> 1));
            n9 = 7;
        }
        int n11 = n2 / 2;
        int n12 = n11 - n10 / 2;
        int n13 = n11 + n10 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl2) {
            graphics.fillRect(0, 0, n3, n2);
        } else {
            graphics.fillRect(0, 0, n2, n3);
        }
        graphics.setColor(color);
        if (n8 > 0) {
            if (bl2) {
                graphics.fillRect(n8, 3, n9, n2 - 3);
            } else {
                graphics.fillRect(3, n8, n2 - 3, n9);
            }
        }
        nArray[0] = n11;
        nArray2[0] = 2;
        nArray[1] = n12;
        nArray2[1] = n10;
        nArray[2] = n13;
        nArray2[2] = n10;
        if (bl2) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n3 - 2;
        nArray2[1] = n3 - n10;
        nArray2[2] = n3 - n10;
        if (bl2) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        color3 = color.brighter();
        graphics.setColor(color3);
        if (bl2) {
            graphics.drawLine(1, n2, n3 - 1, n2);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n2);
            graphics.drawLine(1, n11, n10, n12);
            graphics.drawLine(n3 - n10, n12, n3 - n10, n13);
            graphics.drawLine(n3 - n10, n12, n3 - 2, n11);
        } else {
            graphics.drawLine(n2, 1, n2, n3 - 1);
            graphics.drawLine(1, n3 - 1, n2, n3 - 1);
            graphics.drawLine(n11, 1, n12, n10);
            graphics.drawLine(n12, n3 - n10, n13, n3 - n10);
            graphics.drawLine(n12, n3 - n10, n11, n3 - 2);
        }
        if (n8 > 0) {
            if (bl2) {
                graphics.drawLine(n8, 2, n8 + n9, 2);
                graphics.drawLine(n8, 2, n8, n2 - 3);
            } else {
                graphics.drawLine(2, n8, 2, n8 + n9);
                graphics.drawLine(2, n8, n2 - 3, n8);
            }
        }
        Color color4 = color.darker();
        graphics.setColor(color4);
        if (bl2) {
            graphics.drawLine(0, 0, 0, n2);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(n10, n12, n10, n13);
            graphics.drawLine(n10, n13, 1, n11);
            graphics.drawLine(n3 - 2, n11, n3 - n10, n13);
        } else {
            graphics.drawLine(0, 0, n2, 0);
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(n12, n10, n13, n10);
            graphics.drawLine(n13, n10, n11, 1);
            graphics.drawLine(n11, n3 - 2, n13, n3 - n10);
        }
        if (n8 > 0) {
            if (bl2) {
                graphics.drawLine(n8 + n9, 2, n8 + n9, n2 - 2);
                graphics.drawLine(n8, n2 - 2, n8 + n9, n2 - 2);
            } else {
                graphics.drawLine(2, n8 + n9, n2 - 2, n8 + n9);
                graphics.drawLine(n2 - 2, n8, n2 - 2, n8 + n9);
            }
        }
        graphics.setColor(color2);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    public void setVisible(boolean bl2) {
        if (bl2) {
            Dimension dimension = this.target.getSize();
            this.oldWidth = dimension.width;
            this.oldHeight = dimension.height;
            this.pShow();
        } else {
            this.pHide();
        }
    }

    public void setEnabled(boolean bl2) {
        if (bl2) {
            this.pEnable();
        } else {
            this.pDisable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            Component component = this.target;
            while (component != null && !(component instanceof Window)) {
                component = MComponentPeer.getParent_NoClientCode(component);
            }
            if (component == null || component instanceof EmbeddedFrame) {
                return this.pGetLocationOnScreen();
            }
            MWindowPeer mWindowPeer = (MWindowPeer)MToolkit.targetToPeer(component);
            if (mWindowPeer == null) {
                return this.pGetLocationOnScreen();
            }
            return this.pGetLocationOnScreen2((Window)component, mWindowPeer);
        }
    }

    public boolean checkNativePaintOnSetBounds(int n2, int n3) {
        return n2 != this.oldWidth || n3 != this.oldHeight;
    }

    void setBounds(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5, 3);
    }

    public void setBounds(int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (this.disposed) {
            return;
        }
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        this.paintPending = false;
        if (container != null && container instanceof ScrollPane) {
            object = (MScrollPanePeer)container.getPeer();
            if (!((MScrollPanePeer)object).ignore) {
                this.pReshape(n2, n3, n4, n5);
                ((MScrollPanePeer)object).childResized(n4, n5);
            }
        } else {
            this.pReshape(n2, n3, n4, n5);
        }
        if (n4 != this.oldWidth || n5 != this.oldHeight) {
            object = this.surfaceData;
            if (object != null) {
                this.surfaceData = this.graphicsConfig.createSurfaceData(this);
                ((SurfaceData)object).invalidate();
            }
            this.oldWidth = n4;
            this.oldHeight = n5;
        }
        this.validateSurface(n4, n5);
        ++this.serialNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateSurface(int n2, int n3) {
        AWTLockAccess.awtLock();
        try {
            if (!(this.disposed || n2 == this.oldWidth && n3 == this.oldHeight)) {
                SurfaceData surfaceData = this.surfaceData;
                if (surfaceData != null) {
                    this.surfaceData = this.graphicsConfig.createSurfaceData(this);
                    surfaceData.invalidate();
                }
                this.oldWidth = n2;
                this.oldHeight = n3;
            }
        }
        finally {
            AWTLockAccess.awtUnlock();
        }
    }

    public void beginValidate() {
    }

    native void restoreFocus();

    public void endValidate() {
        this.restoreFocus();
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintPending || this.paintArea.isEmpty() || this.target.getIgnoreRepaint())) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void addDropTarget(DropTarget dropTarget) {
        if (MToolkit.useMotifDnD()) {
            this.addNativeDropTarget(dropTarget);
        } else {
            MWindowPeer mWindowPeer;
            Component component = this.target;
            while (component != null && !(component instanceof Window)) {
                component = MComponentPeer.getParent_NoClientCode(component);
            }
            if (component instanceof Window && (mWindowPeer = (MWindowPeer)component.getPeer()) != null) {
                mWindowPeer.addDropTarget();
            }
        }
    }

    public void removeDropTarget(DropTarget dropTarget) {
        if (MToolkit.useMotifDnD()) {
            this.removeNativeDropTarget(dropTarget);
        } else {
            MWindowPeer mWindowPeer;
            Component component = this.target;
            while (component != null && !(component instanceof Window)) {
                component = MComponentPeer.getParent_NoClientCode(component);
            }
            if (component instanceof Window && (mWindowPeer = (MWindowPeer)component.getPeer()) != null) {
                mWindowPeer.removeDropTarget();
            }
        }
    }

    public void notifyTextComponentChange(boolean bl2) {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container instanceof Frame || container instanceof Dialog) {
            if (bl2) {
                ((MInputMethodControl)((Object)container.getPeer())).addTextComponent(this);
            } else {
                ((MInputMethodControl)((Object)container.getPeer())).removeTextComponent(this);
            }
        }
    }

    native void addNativeDropTarget(DropTarget var1);

    native void removeNativeDropTarget(DropTarget var1);

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
        if (graphicsConfiguration == null) {
            graphicsConfiguration = this.target.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public void cancelPendingPaint(int n2, int n3, int n4, int n5) {
        if (this.target instanceof Container) {
            Insets insets = ((Container)this.target).getInsets();
            this.paintArea.constrain(insets.left, insets.top, this.target.getWidth() - insets.left - insets.right, this.target.getHeight() - insets.top - insets.bottom);
        }
        this.paintArea.subtract(n2, n3, n4, n5);
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    private native long getWindow(long var1);

    public long getContentWindow() {
        return this.getWindow(this.pData);
    }

    public void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        this.backBuffer = this.graphicsConfig.createBackBuffer(this, n2, bufferCapabilities);
        this.xBackBuffer = this.graphicsConfig.createBackBufferImage(this.target, this.backBuffer);
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        this.graphicsConfig.flip(this, this.target, this.xBackBuffer, flipContents);
    }

    public Image getBackBuffer() {
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.xBackBuffer;
    }

    public void destroyBuffers() {
        this.graphicsConfig.destroyBackBuffer(this.backBuffer);
        this.backBuffer = 0L;
        this.xBackBuffer = null;
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void reparent(ContainerPeer containerPeer) {
        throw new UnsupportedOperationException();
    }

    static {
        MComponentPeer.initIDs();
        defaultFont = new Font("Dialog", 0, 12);
    }
}

