/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSelectionClearEvent;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;

public class XSelection {
    private static final Hashtable table = new Hashtable();
    private static final Object lock = new Object();
    private static final XAtom selectionPropertyAtom = XAtom.get("XAWT_SELECTION");
    public static final long MAX_LENGTH = 1000000L;
    public static final int MAX_PROPERTY_SIZE;
    public static final long SELECTION_TIMEOUT = 10000L;
    private static final XEventDispatcher incrementalTransferHandler;
    private static WindowPropertyGetter propertyGetter;
    private final XAtom selectionAtom;
    private final XClipboard clipboard;
    private Transferable contents = null;
    private Map formatMap = null;
    private long[] formats = null;
    private AppContext appContext = null;
    private long ownershipTime = 0L;
    private boolean isOwner;
    private volatile XAtom targetsPropertyAtom;
    private static volatile Set targetsPropertyAtoms;
    private volatile boolean isSelectionNotifyProcessed;
    private long convertSelectionTime;

    static XSelection getSelection(XAtom xAtom) {
        return (XSelection)table.get(xAtom);
    }

    public XSelection(XAtom xAtom, XClipboard xClipboard) {
        if (xAtom == null) {
            throw new NullPointerException("Null atom");
        }
        this.selectionAtom = xAtom;
        this.clipboard = xClipboard;
        table.put(this.selectionAtom, this);
    }

    public XAtom getSelectionAtom() {
        return this.selectionAtom;
    }

    void initializeSelectionForTrackingChanges() {
        this.targetsPropertyAtom = XAtom.get("XAWT_TARGETS_OF_SELECTION:" + this.selectionAtom.getName());
        if (targetsPropertyAtoms == null) {
            targetsPropertyAtoms = Collections.synchronizedSet(new HashSet(2));
        }
        targetsPropertyAtoms.add(new Long(this.targetsPropertyAtom.getAtom()));
        this.isSelectionNotifyProcessed = true;
    }

    void deinitializeSelectionForTrackingChanges() {
        if (targetsPropertyAtoms != null && this.targetsPropertyAtom != null) {
            targetsPropertyAtoms.remove(new Long(this.targetsPropertyAtom.getAtom()));
        }
        this.isSelectionNotifyProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setOwner(Transferable transferable, Map map, long[] lArray, long l2) {
        long l3 = XWindow.getXAWTRootWindow().getWindow();
        long l4 = this.selectionAtom.getAtom();
        if (l2 == 0L) {
            l2 = XToolkit.getCurrentServerTime();
        }
        this.contents = transferable;
        this.formatMap = map;
        this.formats = lArray;
        this.appContext = AppContext.getAppContext();
        this.ownershipTime = l2;
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XSetSelectionOwner(XToolkit.getDisplay(), l4, l3, l2);
            if (XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), l4) != l3) {
                this.reset();
                return false;
            }
            this.isOwner = true;
            if (this.clipboard != null) {
                this.clipboard.checkChangeHere(transferable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForSelectionNotify(WindowPropertyGetter windowPropertyGetter) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            do {
                DataTransferer.getInstance().processDataConversionRequests();
                XToolkit.getAWTLock().wait(250L);
            } while (propertyGetter == windowPropertyGetter && System.currentTimeMillis() < l2 + 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long[] getTargets(long l2) {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        long[] lArray = null;
        Object object = lock;
        // MONITORENTER : object
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, true, 0L);
        try {
            Object object2 = XToolkit.getAWTLock();
            // MONITORENTER : object2
            propertyGetter = windowPropertyGetter;
            XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l2);
            try {
                XSelection.waitForSelectionNotify(windowPropertyGetter);
                return XSelection.getFormats(windowPropertyGetter);
            }
            catch (InterruptedException interruptedException) {
                long[] lArray2 = new long[]{};
                windowPropertyGetter.dispose();
                // MONITOREXIT : object
                return lArray2;
            }
            finally {
                propertyGetter = null;
            }
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    private static long[] getFormats(WindowPropertyGetter windowPropertyGetter) {
        int n2;
        long[] lArray = null;
        if (windowPropertyGetter.isExecuted() && !windowPropertyGetter.isDisposed() && (windowPropertyGetter.getActualType() == 4L || windowPropertyGetter.getActualType() == XDataTransferer.TARGETS_ATOM.getAtom()) && windowPropertyGetter.getActualFormat() == 32 && (n2 = windowPropertyGetter.getNumberOfItems()) > 0) {
            long l2 = windowPropertyGetter.getData();
            lArray = new long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                lArray[i2] = Native.getLong(l2 + (long)(i2 * XAtom.getAtomSize()));
            }
        }
        return lArray != null ? lArray : new long[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTargetsDelayed() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l2 = System.currentTimeMillis();
            if (this.isSelectionNotifyProcessed || l2 >= this.convertSelectionTime + 10000L) {
                this.convertSelectionTime = l2;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), this.targetsPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), 0L);
                this.isSelectionNotifyProcessed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public byte[] getData(long var1_1, long var3_2) throws IOException {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        var5_3 = null;
        var6_4 = XSelection.lock;
        synchronized (var6_4) {
            var7_5 = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XSelection.selectionPropertyAtom, 0L, 1000000L, false, 0L);
            try {
                var8_6 = XToolkit.getAWTLock();
                synchronized (var8_6) {
                    XSelection.propertyGetter = var7_5;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), var1_1, XSelection.selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), var3_2);
                    try {
                        XSelection.waitForSelectionNotify(var7_5);
                        XSelection.propertyGetter = null;
                    }
                    catch (InterruptedException var9_9) {
                        try {
                            var10_12 = new byte[]{};
                            XSelection.propertyGetter = null;
                        }
                        catch (Throwable var11_13) {
                            XSelection.propertyGetter = null;
                            throw var11_13;
                        }
                        var7_5.dispose();
                        return var10_12;
                    }
                    ** finally { 
                }
            }
            finally {
                var7_5.dispose();
            }
        }
    }

    boolean isOwner() {
        return this.isOwner;
    }

    public void lostOwnership() {
        this.isOwner = false;
        if (this.clipboard != null) {
            this.clipboard.run();
        }
    }

    public synchronized void reset() {
        this.contents = null;
        this.formatMap = null;
        this.formats = null;
        this.appContext = null;
        this.ownershipTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertAndStore(long l2, long l3, long l4) {
        int n2 = 8;
        byte[] byArray = null;
        long l5 = 0L;
        int n3 = 0;
        try {
            SunToolkit.insertTargetMapping(this, this.appContext);
            byArray = DataTransferer.getInstance().convertData(this, this.contents, l3, this.formatMap, XToolkit.isToolkitThread());
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        n3 = byArray.length;
        try {
            if (n3 > 0) {
                if (n3 <= MAX_PROPERTY_SIZE) {
                    l5 = Native.toData(byArray);
                } else {
                    new IncrementalDataProvider(l2, l4, l3, 8, byArray);
                    l5 = XlibWrapper.unsafe.allocateMemory(XAtom.getAtomSize());
                    Native.putLong(l5, n3);
                    l3 = XDataTransferer.INCR_ATOM.getAtom();
                    n2 = 32;
                    n3 = 1;
                }
            }
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, l4, l3, n2, 0, l5, n3);
            }
        }
        finally {
            if (l5 != 0L) {
                XlibWrapper.unsafe.freeMemory(l5);
                l5 = 0L;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleSelectionRequest(XSelectionRequestEvent var1_1) {
        block31: {
            var2_2 = var1_1.get_property();
            var4_3 = var1_1.get_requestor();
            var6_4 = var1_1.get_time();
            var8_5 = var1_1.get_target();
            var10_6 = 0;
            var11_7 = false;
            if (this.ownershipTime != 0L && (var6_4 == 0L || var6_4 > this.ownershipTime)) {
                var2_2 = var1_1.get_property();
                if (var8_5 == XDataTransferer.MULTIPLE_ATOM.getAtom()) {
                    if (var2_2 != 0L) {
                        var12_8 = new WindowPropertyGetter(var4_3, XAtom.get(var2_2), 0L, 1000000L, false, 0L);
                        try {
                            var12_8.execute();
                            if (var12_8.getActualFormat() != 32 || var12_8.getNumberOfItems() % 2 != 0) ** GOTO lbl69
                            var13_11 = var12_8.getNumberOfItems() / 2;
                            var15_13 = var12_8.getData();
                            var17_15 = false;
                            var18_16 = 0;
                            while ((long)var18_16 < var13_11) {
                                var19_18 = Native.getLong(var15_13, 2 * var18_16);
                                if (!this.convertAndStore(var4_3, var19_18, var21_19 = Native.getLong(var15_13, 2 * var18_16 + 1))) {
                                    Native.putLong(var15_13, 2 * var18_16, 0L);
                                    var17_15 = true;
                                }
                                ++var18_16;
                            }
                            if (var17_15) {
                                var18_17 = XToolkit.getAWTLock();
                                synchronized (var18_17) {
                                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), var4_3, var2_2, var12_8.getActualType(), var12_8.getActualFormat(), 0, var12_8.getData(), var12_8.getNumberOfItems());
                                }
                            }
                            var11_7 = true;
                        }
                        finally {
                            var12_8.dispose();
                        }
                    }
                } else {
                    if (var2_2 == 0L) {
                        var2_2 = var8_5;
                    }
                    if (var8_5 == XDataTransferer.TARGETS_ATOM.getAtom()) {
                        var12_9 = 0L;
                        var14_22 = 0;
                        var10_6 = 32;
                        var15_14 = this.formats;
                        if (var15_14 == null) {
                            throw new IllegalStateException("Not an owner.");
                        }
                        var14_22 = var15_14.length;
                        try {
                            if (var14_22 > 0) {
                                var12_9 = Native.allocateLongArray(var14_22);
                                Native.put(var12_9, var15_14);
                            }
                            var11_7 = true;
                            var16_23 = XToolkit.getAWTLock();
                            synchronized (var16_23) {
                                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), var4_3, var2_2, var8_5, var10_6, 0, var12_9, var14_22);
                                break block31;
                            }
                        }
                        finally {
                            if (var12_9 != 0L) {
                                XlibWrapper.unsafe.freeMemory(var12_9);
                                var12_9 = 0L;
                            }
                        }
                    }
                    var11_7 = this.convertAndStore(var4_3, var8_5, var2_2);
                }
            }
        }
        if (!var11_7) {
            var2_2 = 0L;
        }
        var12_10 = new XSelectionEvent();
        try {
            var12_10.set_type(31);
            var12_10.set_send_event(true);
            var12_10.set_requestor(var4_3);
            var12_10.set_selection(this.selectionAtom.getAtom());
            var12_10.set_target(var8_5);
            var12_10.set_property(var2_2);
            var12_10.set_time(var6_4);
            var13_12 = XToolkit.getAWTLock();
            synchronized (var13_12) {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), var4_3, false, 0L, var12_10.pData);
            }
        }
        finally {
            var12_10.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkChange(XSelectionEvent xSelectionEvent) {
        Object object;
        if (targetsPropertyAtoms == null || targetsPropertyAtoms.isEmpty()) {
            return;
        }
        long l2 = xSelectionEvent.get_property();
        long[] lArray = null;
        if (l2 == 0L) {
            lArray = new long[]{};
        } else {
            if (!targetsPropertyAtoms.contains(new Long(l2))) {
                return;
            }
            object = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XAtom.get(l2), 0L, 1000000L, true, 0L);
            try {
                ((WindowPropertyGetter)object).execute();
                lArray = XSelection.getFormats((WindowPropertyGetter)object);
            }
            finally {
                ((WindowPropertyGetter)object).dispose();
            }
        }
        object = XAtom.get(xSelectionEvent.get_selection());
        XSelection xSelection = XSelection.getSelection((XAtom)object);
        if (xSelection != null) {
            xSelection.isSelectionNotifyProcessed = true;
            xSelection.clipboard.checkChange(lArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            MAX_PROPERTY_SIZE = (int)(XlibWrapper.XMaxRequestSize(XToolkit.getDisplay()) * 4L - 100L);
        }
        incrementalTransferHandler = new IncrementalTransferHandler();
        propertyGetter = null;
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionEventHandler());
    }

    private static class IncrementalDataProvider
    implements XEventDispatcher {
        private final long requestor;
        private final long property;
        private final long target;
        private final int format;
        private final byte[] data;
        private int offset = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncrementalDataProvider(long l2, long l3, long l4, int n2, byte[] byArray) {
            if (n2 != 8) {
                throw new IllegalArgumentException("Unsupported format: " + n2);
            }
            this.requestor = l2;
            this.property = l3;
            this.target = l4;
            this.format = n2;
            this.data = byArray;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                Object object = XToolkit.getAWTLock();
                synchronized (object) {
                    XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes.pData);
                    XlibWrapper.XSelectInput(XToolkit.getDisplay(), l2, xWindowAttributes.get_your_event_mask() | 0x400000L);
                }
            }
            finally {
                xWindowAttributes.dispose();
            }
            XToolkit.addEventDispatcher(l2, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(IXAnyEvent iXAnyEvent) {
            switch (iXAnyEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = new XPropertyEvent(iXAnyEvent.getPData());
                    if (xPropertyEvent.get_window() != this.requestor || xPropertyEvent.get_state() != 1 || xPropertyEvent.get_atom() != this.property) break;
                    int n2 = this.data.length - this.offset;
                    long l2 = 0L;
                    if (n2 > MAX_PROPERTY_SIZE) {
                        n2 = MAX_PROPERTY_SIZE;
                    }
                    if (n2 > 0) {
                        l2 = XlibWrapper.unsafe.allocateMemory(n2);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Native.putByte(l2 + (long)i2, this.data[this.offset + i2]);
                        }
                    } else {
                        assert (n2 == 0);
                        XToolkit.removeEventDispatcher(this.requestor, this);
                    }
                    Object object = XToolkit.getAWTLock();
                    synchronized (object) {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), this.requestor, this.property, this.target, this.format, 0, l2, n2);
                    }
                    if (l2 != 0L) {
                        XlibWrapper.unsafe.freeMemory(l2);
                        l2 = 0L;
                    }
                    this.offset += n2;
                }
            }
        }
    }

    private static class IncrementalTransferHandler
    implements XEventDispatcher {
        private IncrementalTransferHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(IXAnyEvent iXAnyEvent) {
            switch (iXAnyEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = new XPropertyEvent(iXAnyEvent.getPData());
                    if (xPropertyEvent.get_state() != 0 || xPropertyEvent.get_atom() != selectionPropertyAtom.getAtom()) break;
                    Object object = XToolkit.getAWTLock();
                    synchronized (object) {
                        if (propertyGetter != null) {
                            propertyGetter.execute();
                            propertyGetter = null;
                        }
                        XToolkit.getAWTLock().notifyAll();
                        break;
                    }
                }
            }
        }
    }

    private static class SelectionEventHandler
    implements XEventDispatcher {
        private SelectionEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(IXAnyEvent iXAnyEvent) {
            switch (iXAnyEvent.get_type()) {
                case 31: {
                    XSelectionEvent xSelectionEvent = new XSelectionEvent(iXAnyEvent.getPData());
                    XSelection.checkChange(xSelectionEvent);
                    Object object = XToolkit.getAWTLock();
                    synchronized (object) {
                        if (propertyGetter != null) {
                            if (xSelectionEvent.get_property() == selectionPropertyAtom.getAtom()) {
                                propertyGetter.execute();
                                propertyGetter = null;
                            } else if (xSelectionEvent.get_property() == 0L) {
                                propertyGetter.dispose();
                                propertyGetter = null;
                            }
                        }
                        XToolkit.getAWTLock().notifyAll();
                        break;
                    }
                }
                case 30: {
                    XSelectionRequestEvent xSelectionRequestEvent = new XSelectionRequestEvent(iXAnyEvent.getPData());
                    long l2 = xSelectionRequestEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l2));
                    if (xSelection == null) break;
                    xSelection.handleSelectionRequest(xSelectionRequestEvent);
                    break;
                }
                case 29: {
                    XSelectionClearEvent xSelectionClearEvent = new XSelectionClearEvent(iXAnyEvent.getPData());
                    long l3 = xSelectionClearEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l3));
                    if (xSelection != null) {
                        xSelection.lostOwnership();
                    }
                    Object object = XToolkit.getAWTLock();
                    synchronized (object) {
                        XToolkit.getAWTLock().notifyAll();
                        break;
                    }
                }
            }
        }
    }
}

