/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.peer.LabelPeer;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;

class XLabelPeer
extends XComponentPeer
implements LabelPeer {
    static final int TEXT_XPAD = 8;
    static final int TEXT_YPAD = 6;
    String label;
    int alignment;
    FontMetrics cachedFontMetrics;
    Font oldfont;

    FontMetrics getFontMetrics() {
        if (this.cachedFontMetrics != null) {
            return this.cachedFontMetrics;
        }
        return this.getFontMetrics(this.getPeerFont());
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Label label = (Label)this.target;
        this.label = label.getText();
        if (this.label == null) {
            this.label = "";
        }
        this.alignment = label.getAlignment();
    }

    XLabelPeer(Label label) {
        super(label);
    }

    public Dimension getMinimumSize() {
        int n2;
        FontMetrics fontMetrics = this.getFontMetrics();
        try {
            n2 = fontMetrics.stringWidth(this.label);
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
        }
        return new Dimension(n2 + 8, fontMetrics.getAscent() + fontMetrics.getMaxDescent() + 6);
    }

    public void paint(Graphics graphics) {
        int n2 = 0;
        int n3 = 0;
        graphics.setColor(this.getPeerBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        Font font = this.getPeerFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.cachedFontMetrics == null) {
            this.cachedFontMetrics = fontMetrics;
        } else if (this.oldfont != font) {
            this.cachedFontMetrics = fontMetrics;
        }
        switch (this.alignment) {
            case 0: {
                n2 = 2;
                n3 = (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
                break;
            }
            case 2: {
                n2 = this.width - (fontMetrics.stringWidth(this.label) + 2);
                n3 = (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
                break;
            }
            case 1: {
                n2 = (this.width - fontMetrics.stringWidth(this.label)) / 2;
                n3 = (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
            }
        }
        if (this.isEnabled()) {
            graphics.setColor(this.getPeerForeground());
            graphics.drawString(this.label, n2, n3);
        } else {
            graphics.setColor(this.getPeerBackground().brighter());
            graphics.drawString(this.label, n2, n3);
            graphics.setColor(this.getPeerBackground().darker());
            graphics.drawString(this.label, n2 - 1, n3 - 1);
        }
    }

    public void setText(String string) {
        this.label = string;
        if (this.label == null) {
            this.label = "";
        }
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.target.repaint();
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
        this.repaint();
    }
}

