/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.peer.CheckboxPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;

class XCheckboxPeer
extends XComponentPeer
implements CheckboxPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XCheckboxPeer");
    private static final Insets focusInsets = new Insets(0, 0, 0, 0);
    private static final Insets borderInsets = new Insets(2, 2, 2, 2);
    private static final int checkBoxInsetFromText = 2;
    private static final double MASTER_SIZE = 128.0;
    private static final Polygon MASTER_CHECKMARK = new Polygon(new int[]{1, 25, 56, 124, 124, 85, 64}, new int[]{59, 35, 67, 0, 12, 66, 123}, 7);
    private Shape myCheckMark;
    private Color focusColor = SystemColor.windowText;
    private boolean pressed = false;
    private boolean armed = false;
    private boolean selected;
    private Rectangle textRect;
    private Rectangle focusRect;
    private int checkBoxSize;
    private int cbX;
    private int cbY;
    String label;
    CheckboxGroup checkBoxGroup;

    XCheckboxPeer(Checkbox checkbox) {
        super(checkbox);
        this.selected = checkbox.getState();
        this.label = checkbox.getLabel();
        if (this.label == null) {
            this.label = "";
        }
        this.checkBoxGroup = checkbox.getCheckboxGroup();
        this.updateMotifColors(this.getPeerBackground());
    }

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        this.textRect = new Rectangle();
        this.focusRect = new Rectangle();
        super.preInit(xCreateWindowParams);
    }

    public boolean isFocusable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint();
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyTyped(keyEvent);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.action(!this.selected);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setLabel(String string) {
        this.label = string;
        if (string == null) {
            string = "";
        }
        this.layout();
        this.repaint();
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 500: {
                this.mouseClicked(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Checkbox checkbox;
        if (XToolkit.isLeftMouseButton(mouseEvent) && (checkbox = (Checkbox)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("mousePressed() on " + this.target.getName() + " : armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
            }
            if (!this.isEnabled()) {
                return;
            }
            if (!this.armed) {
                this.armed = true;
            }
            this.pressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("mouseReleased() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        boolean bl2 = false;
        if (XToolkit.isLeftMouseButton(mouseEvent)) {
            if (this.armed) {
                bl2 = true;
            }
            this.pressed = false;
            this.armed = false;
            if (bl2) {
                this.action(!this.selected);
            } else {
                this.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("mouseEntered() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        if (this.pressed) {
            this.armed = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("mouseExited() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        if (this.armed) {
            this.armed = false;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getPeerFont());
        int n2 = fontMetrics.stringWidth(this.label) + this.getCheckboxSize(fontMetrics) + 4 + 8;
        int n3 = Math.max(fontMetrics.getHeight() + 8, 15);
        return new Dimension(n2, n3);
    }

    private int getCheckboxSize(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() * 76 / 100 - 1;
    }

    public void setBackground(Color color) {
        this.updateMotifColors(color);
        super.setBackground(color);
    }

    public void layout() {
        Dimension dimension = this.getPeerSize();
        Font font = this.getPeerFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String string = this.label;
        this.checkBoxSize = this.getCheckboxSize(fontMetrics);
        this.cbX = XCheckboxPeer.borderInsets.left + 2;
        this.cbY = dimension.height / 2 - this.checkBoxSize / 2;
        int n2 = XCheckboxPeer.borderInsets.left + 4 + this.checkBoxSize;
        this.textRect.width = fontMetrics.stringWidth(string == null ? "" : string);
        this.textRect.height = fontMetrics.getHeight();
        this.textRect.x = Math.max(n2, dimension.width / 2 - this.textRect.width / 2);
        this.textRect.y = (dimension.height - this.textRect.height) / 2;
        this.focusRect.x = XCheckboxPeer.focusInsets.left;
        this.focusRect.y = XCheckboxPeer.focusInsets.top;
        this.focusRect.width = dimension.width - (XCheckboxPeer.focusInsets.left + XCheckboxPeer.focusInsets.right) - 1;
        this.focusRect.height = dimension.height - (XCheckboxPeer.focusInsets.top + XCheckboxPeer.focusInsets.bottom) - 1;
        double d2 = this.checkBoxSize;
        this.myCheckMark = AffineTransform.getScaleInstance(d2 / 128.0, d2 / 128.0).createTransformedShape(MASTER_CHECKMARK);
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            Dimension dimension = this.getPeerSize();
            Font font = this.getPeerFont();
            graphics.setColor(this.getPeerBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.label != null) {
                graphics.setFont(font);
                this.paintText(graphics, this.textRect, this.label);
            }
            if (this.hasFocus()) {
                this.paintFocus(graphics, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
            }
            if (this.checkBoxGroup == null) {
                this.paintCheckbox(graphics, this.cbX, this.cbY, this.checkBoxSize, this.checkBoxSize);
            } else {
                this.paintRadioButton(graphics, this.cbX, this.cbY, this.checkBoxSize, this.checkBoxSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCheckbox(Graphics graphics, int n2, int n3, int n4, int n5) {
        boolean bl2 = false;
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        int n6 = n2;
        int n7 = n3;
        if (!(graphics instanceof Graphics2D)) {
            bufferedImage = this.graphicsConfig.createCompatibleImage(n4, n5);
            graphics2D = bufferedImage.createGraphics();
            bl2 = true;
            n6 = 0;
            n7 = 0;
        } else {
            graphics2D = (Graphics2D)graphics;
        }
        try {
            this.drawMotif3DRect(graphics2D, n6, n7, n4 - 1, n5 - 1, this.armed | this.selected);
            graphics2D.setColor(this.armed | this.selected ? this.selectColor : this.getPeerBackground());
            graphics2D.fillRect(n6 + 1, n7 + 1, n4 - 2, n5 - 2);
            if (this.armed | this.selected) {
                graphics2D.setColor(this.getPeerForeground());
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.setTransform(AffineTransform.getTranslateInstance(n6, n7));
                graphics2D.fill(this.myCheckMark);
                graphics2D.setTransform(affineTransform);
            }
        }
        finally {
            if (bl2) {
                graphics2D.dispose();
            }
        }
        if (bl2) {
            graphics.drawImage(bufferedImage, n2, n3, null);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.target.repaint();
    }

    public void paintRadioButton(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.armed | this.selected ? this.darkShadow : this.lightShadow);
        graphics.drawArc(n2 - 1, n3 - 1, n4 + 2, n5 + 2, 45, 180);
        graphics.setColor(this.armed | this.selected ? this.lightShadow : this.darkShadow);
        graphics.drawArc(n2 - 1, n3 - 1, n4 + 2, n5 + 2, 45, -180);
        if (this.armed | this.selected) {
            graphics.setColor(this.selectColor);
            graphics.fillArc(n2 + 1, n3 + 1, n4 - 1, n5 - 1, 0, 360);
        }
    }

    protected void paintText(Graphics graphics, Rectangle rectangle, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = -1;
        if (this.isEnabled()) {
            graphics.setColor(this.getPeerForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getPeerBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(this.getPeerBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected void paintFocus(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.focusColor);
        graphics.drawRect(n2, n3, n4, n5);
    }

    public void setState(boolean bl2) {
        if (this.selected != bl2) {
            this.selected = bl2;
            this.repaint();
        }
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        this.checkBoxGroup = checkboxGroup;
        this.repaint();
    }

    void action(boolean bl2) {
        final Checkbox checkbox = (Checkbox)this.target;
        final boolean bl3 = bl2;
        XToolkit.executeOnEventHandlerThread(checkbox, new Runnable(){

            public void run() {
                CheckboxGroup checkboxGroup = XCheckboxPeer.this.checkBoxGroup;
                if (checkboxGroup != null && checkboxGroup.getSelectedCheckbox() == checkbox && checkbox.getState()) {
                    checkbox.setState(true);
                    return;
                }
                checkbox.setState(bl3);
                XCheckboxPeer.this.notifyStateChanged(bl3);
            }
        });
    }

    void notifyStateChanged(boolean bl2) {
        Checkbox checkbox = (Checkbox)this.target;
        ItemEvent itemEvent = new ItemEvent(checkbox, 701, checkbox.getLabel(), bl2 ? 1 : 2);
        this.postEvent(itemEvent);
    }
}

