/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AsyncBoxView;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    int maxZoneSize = 8192;
    int maxZonesLoaded = 3;
    Vector loadedZones = new Vector();

    public ZoneView(Element element, int n2) {
        super(element, n2);
    }

    public int getMaximumZoneSize() {
        return this.maxZoneSize;
    }

    public void setMaximumZoneSize(int n2) {
        this.maxZoneSize = n2;
    }

    public int getMaxZonesLoaded() {
        return this.maxZonesLoaded;
    }

    public void setMaxZonesLoaded(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("ZoneView.setMaxZonesLoaded must be greater than 0.");
        }
        this.maxZonesLoaded = n2;
        this.unloadOldZones();
    }

    protected void zoneWasLoaded(View view) {
        this.loadedZones.addElement(view);
        this.unloadOldZones();
    }

    void unloadOldZones() {
        while (this.loadedZones.size() > this.getMaxZonesLoaded()) {
            View view = (View)this.loadedZones.elementAt(0);
            this.loadedZones.removeElementAt(0);
            this.unloadZone(view);
        }
    }

    protected void unloadZone(View view) {
        view.removeAll();
    }

    protected boolean isZoneLoaded(View view) {
        return view.getViewCount() > 0;
    }

    protected View createZone(int n2, int n3) {
        Document document = this.getDocument();
        Zone zone = null;
        try {
            zone = new Zone(this.getElement(), document.createPosition(n2), document.createPosition(n3));
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError(badLocationException.getMessage());
        }
        return zone;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Document document = this.getDocument();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        this.append(this.createZone(n2, n3));
        this.handleInsert(n2, n3 - n2);
    }

    protected int getViewIndexAtPosition(int n2) {
        int n3 = this.getViewCount();
        if (n2 == this.getEndOffset()) {
            return n3 - 1;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            View view = this.getView(i2);
            if (n2 < view.getStartOffset() || n2 >= view.getEndOffset()) continue;
            return i2;
        }
        return -1;
    }

    void handleInsert(int n2, int n3) {
        int n4 = this.getViewIndex(n2, Position.Bias.Forward);
        View view = this.getView(n4);
        int n5 = view.getStartOffset();
        int n6 = view.getEndOffset();
        if (n6 - n5 > this.maxZoneSize) {
            this.splitZone(n4, n5, n6);
        }
    }

    void handleRemove(int n2, int n3) {
    }

    void splitZone(int n2, int n3, int n4) {
        Element element = this.getElement();
        Document document = element.getDocument();
        Vector<View> vector = new Vector<View>();
        int n5 = n3;
        do {
            n3 = n5;
            n5 = Math.min(this.getDesiredZoneEnd(n3), n4);
            vector.addElement(this.createZone(n3, n5));
        } while (n5 < n4);
        View view = this.getView(n2);
        Object[] objectArray = new View[vector.size()];
        vector.copyInto(objectArray);
        this.replace(n2, 1, (View[])objectArray);
    }

    int getDesiredZoneEnd(int n2) {
        Element element = this.getElement();
        int n3 = element.getElementIndex(n2 + this.maxZoneSize / 2);
        Element element2 = element.getElement(n3);
        int n4 = element2.getStartOffset();
        int n5 = element2.getEndOffset();
        if (n5 - n2 > this.maxZoneSize && n4 > n2) {
            return n4;
        }
        return n5;
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        return false;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.handleInsert(documentEvent.getOffset(), documentEvent.getLength());
        super.insertUpdate(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.handleRemove(documentEvent.getOffset(), documentEvent.getLength());
        super.removeUpdate(documentEvent, shape, viewFactory);
    }

    class Zone
    extends AsyncBoxView {
        private Position start;
        private Position end;

        public Zone(Element element, Position position, Position position2) {
            super(element, ZoneView.this.getAxis());
            this.start = position;
            this.end = position2;
        }

        public void load() {
            if (!this.isLoaded()) {
                this.setEstimatedMajorSpan(true);
                Element element = this.getElement();
                ViewFactory viewFactory = this.getViewFactory();
                int n2 = element.getElementIndex(this.getStartOffset());
                int n3 = element.getElementIndex(this.getEndOffset());
                View[] viewArray = new View[n3 - n2 + 1];
                for (int i2 = n2; i2 <= n3; ++i2) {
                    viewArray[i2 - n2] = viewFactory.create(element.getElement(i2));
                }
                this.replace(0, 0, viewArray);
                ZoneView.this.zoneWasLoaded(this);
            }
        }

        public void unload() {
            this.setEstimatedMajorSpan(true);
            this.removeAll();
        }

        public boolean isLoaded() {
            return this.getViewCount() != 0;
        }

        protected void loadChildren(ViewFactory viewFactory) {
            this.setEstimatedMajorSpan(true);
            Element element = this.getElement();
            int n2 = element.getElementIndex(this.getStartOffset());
            int n3 = element.getElementIndex(this.getEndOffset());
            int n4 = n3 - n2;
            View view = viewFactory.create(element.getElement(n2));
            view.setParent(this);
            float f2 = view.getPreferredSpan(0);
            float f3 = view.getPreferredSpan(1);
            if (this.getMajorAxis() == 0) {
                f2 *= (float)n4;
            } else {
                f3 += (float)n4;
            }
            this.setSize(f2, f3);
        }

        protected void flushRequirementChanges() {
            if (this.isLoaded()) {
                super.flushRequirementChanges();
            }
        }

        public int getViewIndex(int n2, Position.Bias bias) {
            boolean bl2 = bias == Position.Bias.Backward;
            n2 = bl2 ? Math.max(0, n2 - 1) : n2;
            Element element = this.getElement();
            int n3 = element.getElementIndex(n2);
            int n4 = element.getElementIndex(this.getStartOffset());
            return n3 - n4;
        }

        protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            Element element = this.getElement();
            int n2 = element.getElementIndex(this.getStartOffset());
            int n3 = element.getElementIndex(this.getEndOffset() - 1);
            int n4 = elementChange.getIndex();
            if (n4 >= n2 && n4 <= n3) {
                int n5 = n4 - n2;
                int n6 = Math.min(n3 - n2 + 1, elementArray2.length);
                int n7 = Math.min(n3 - n2 + 1, elementArray.length);
                View[] viewArray = new View[n6];
                for (int i2 = 0; i2 < n6; ++i2) {
                    viewArray[i2] = viewFactory.create(elementArray2[i2]);
                }
                this.replace(n5, n7, viewArray);
            }
            return true;
        }

        public AttributeSet getAttributes() {
            return ZoneView.this.getAttributes();
        }

        public void paint(Graphics graphics, Shape shape) {
            this.load();
            super.paint(graphics, shape);
        }

        public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
            this.load();
            return super.viewToModel(f2, f3, shape, biasArray);
        }

        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
            this.load();
            return super.modelToView(n2, shape, bias);
        }

        public int getStartOffset() {
            return this.start.getOffset();
        }

        public int getEndOffset() {
            return this.end.getOffset();
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.changedUpdate(documentEvent, shape, viewFactory);
            }
        }
    }
}

