/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import sun.font.FontManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static StyleContext defaultContext;
    public static final String DEFAULT_STYLE = "default";
    private static Hashtable freezeKeyMap;
    private static Hashtable thawKeyMap;
    private Style styles;
    private transient FontKey fontSearch = new FontKey(null, 0, 0);
    private transient Hashtable fontTable = new Hashtable();
    private transient Map attributesPool = Collections.synchronizedMap(new WeakHashMap());
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private int unusedSets;
    static final int THRESHOLD = 9;

    public static final StyleContext getDefaultStyleContext() {
        if (defaultContext == null) {
            defaultContext = new StyleContext();
        }
        return defaultContext;
    }

    public StyleContext() {
        this.styles = new NamedStyle(null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(string, style);
        if (string != null) {
            this.styles.addAttribute(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styles.removeAttribute(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styles.getAttribute(string);
    }

    public Enumeration<?> getStyleNames() {
        return this.styles.getAttributeNames();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.styles.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.styles.removeChangeListener(changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return ((NamedStyle)this.styles).getChangeListeners();
    }

    public Font getFont(AttributeSet attributeSet) {
        int n2 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n2 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n2 |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n3 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n3 -= 2;
        }
        return this.getFont(string, n2, n3);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    public Font getFont(String string, int n2, int n3) {
        this.fontSearch.setValue(string, n2, n3);
        Font font = (Font)this.fontTable.get(this.fontSearch);
        if (font == null) {
            font = new Font(string, n2, n3);
            if (!FontManager.fontSupportsDefaultEncoding(font)) {
                font = FontManager.getCompositeFontUIResource(font);
            }
            FontKey fontKey = new FontKey(string, n2, n3);
            this.fontTable.put(fontKey, font);
        }
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public synchronized AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet.getAttributeCount() + 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttribute(object, object2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() + attributeSet2.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttribute(object);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(enumeration);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    @Override
    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    @Override
    public void reclaim(AttributeSet attributeSet) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.attributesPool.size();
        }
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(attributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    synchronized void removeUnusedSets() {
        this.attributesPool.size();
    }

    AttributeSet getImmutableUniqueSet() {
        SmallAttributeSet smallAttributeSet;
        SmallAttributeSet smallAttributeSet2 = this.createSmallAttributeSet(this.search);
        WeakReference weakReference = (WeakReference)this.attributesPool.get(smallAttributeSet2);
        if (weakReference == null || (smallAttributeSet = (SmallAttributeSet)weakReference.get()) == null) {
            smallAttributeSet = smallAttributeSet2;
            this.attributesPool.put(smallAttributeSet, new WeakReference<SmallAttributeSet>(smallAttributeSet));
        }
        return smallAttributeSet;
    }

    MutableAttributeSet getMutableAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof MutableAttributeSet && attributeSet != SimpleAttributeSet.EMPTY) {
            return (MutableAttributeSet)attributeSet;
        }
        return this.createLargeAttributeSet(attributeSet);
    }

    public String toString() {
        this.removeUnusedSets();
        String string = "";
        for (SmallAttributeSet smallAttributeSet : this.attributesPool.keySet()) {
            string = string + smallAttributeSet + "\n";
        }
        return string;
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        StyleContext.writeAttributeSet(objectOutputStream, attributeSet);
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(objectInputStream, mutableAttributeSet);
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        int n2 = attributeSet.getAttributeCount();
        objectOutputStream.writeInt(n2);
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object obj = enumeration.nextElement();
            if (obj instanceof Serializable) {
                objectOutputStream.writeObject(obj);
            } else {
                object = freezeKeyMap.get(obj);
                if (object == null) {
                    throw new NotSerializableException(obj.getClass().getName() + " is not serializable as a key in an AttributeSet");
                }
                objectOutputStream.writeObject(object);
            }
            object = attributeSet.getAttribute(obj);
            Object v2 = freezeKeyMap.get(object);
            if (object instanceof Serializable) {
                objectOutputStream.writeObject(v2 != null ? v2 : object);
                continue;
            }
            if (v2 == null) {
                throw new NotSerializableException(object.getClass().getName() + " is not serializable as a value in an AttributeSet");
            }
            objectOutputStream.writeObject(v2);
        }
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        int n2 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (thawKeyMap != null) {
                Object v2;
                Object v3 = thawKeyMap.get(object);
                if (v3 != null) {
                    object = v3;
                }
                if ((v2 = thawKeyMap.get(object2)) != null) {
                    object2 = v2;
                }
            }
            mutableAttributeSet.addAttribute(object, object2);
        }
    }

    public static void registerStaticAttributeKey(Object object) {
        String string = object.getClass().getName() + "." + object.toString();
        if (freezeKeyMap == null) {
            freezeKeyMap = new Hashtable();
            thawKeyMap = new Hashtable();
        }
        freezeKeyMap.put(object, string);
        thawKeyMap.put(string, object);
    }

    public static Object getStaticAttribute(Object object) {
        if (thawKeyMap == null || object == null) {
            return null;
        }
        return thawKeyMap.get(object);
    }

    public static Object getStaticAttributeKey(Object object) {
        return object.getClass().getName() + "." + object.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeUnusedSets();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.fontSearch = new FontKey(null, 0, 0);
        this.fontTable = new Hashtable();
        this.search = new SimpleAttributeSet();
        this.attributesPool = Collections.synchronizedMap(new WeakHashMap());
        objectInputStream.defaultReadObject();
    }

    static {
        try {
            int n2 = StyleConstants.keys.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleContext.registerStaticAttributeKey(StyleConstants.keys[i2]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static class FontKey {
        private String family;
        private int style;
        private int size;

        public FontKey(String string, int n2, int n3) {
            this.setValue(string, n2, n3);
        }

        public void setValue(String string, int n2, int n3) {
            this.family = string != null ? string.intern() : null;
            this.style = n2;
            this.size = n3;
        }

        public int hashCode() {
            int n2 = this.family != null ? this.family.hashCode() : 0;
            return n2 ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }
    }

    class KeyBuilder {
        private Vector keys = new Vector();
        private Vector data = new Vector();

        KeyBuilder() {
        }

        public void initialize(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                this.initialize(((SmallAttributeSet)attributeSet).attributes);
            } else {
                this.keys.removeAllElements();
                this.data.removeAllElements();
                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    this.addAttribute(obj, attributeSet.getAttribute(obj));
                }
            }
        }

        private void initialize(Object[] objectArray) {
            this.keys.removeAllElements();
            this.data.removeAllElements();
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; i2 += 2) {
                this.keys.addElement(objectArray[i2]);
                this.data.addElement(objectArray[i2 + 1]);
            }
        }

        public Object[] createTable() {
            int n2 = this.keys.size();
            Object[] objectArray = new Object[2 * n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = 2 * i2;
                objectArray[n3] = this.keys.elementAt(i2);
                objectArray[n3 + 1] = this.data.elementAt(i2);
            }
            return objectArray;
        }

        int getCount() {
            return this.keys.size();
        }

        public void addAttribute(Object object, Object object2) {
            this.keys.addElement(object);
            this.data.addElement(object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                Object[] objectArray = ((SmallAttributeSet)attributeSet).attributes;
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; i2 += 2) {
                    this.addAttribute(objectArray[i2], objectArray[i2 + 1]);
                }
            } else {
                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    this.addAttribute(obj, attributeSet.getAttribute(obj));
                }
            }
        }

        public void removeAttribute(Object object) {
            int n2 = this.keys.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.keys.elementAt(i2).equals(object)) continue;
                this.keys.removeElementAt(i2);
                this.data.removeElementAt(i2);
                return;
            }
        }

        public void removeAttributes(Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                this.removeAttribute(e2);
            }
        }

        public void removeAttributes(AttributeSet attributeSet) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                this.removeSearchAttribute(obj, object);
            }
        }

        private void removeSearchAttribute(Object object, Object object2) {
            int n2 = this.keys.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.keys.elementAt(i2).equals(object)) continue;
                if (this.data.elementAt(i2).equals(object2)) {
                    this.keys.removeElementAt(i2);
                    this.data.removeElementAt(i2);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyEnumeration
    implements Enumeration<Object> {
        Object[] attr;
        int i;

        KeyEnumeration(Object[] objectArray) {
            this.attr = objectArray;
            this.i = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.attr.length;
        }

        @Override
        public Object nextElement() {
            if (this.i < this.attr.length) {
                Object object = this.attr[this.i];
                this.i += 2;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NamedStyle
    implements Style,
    Serializable {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        private transient AttributeSet attributes;

        public NamedStyle(String string, Style style) {
            this.attributes = StyleContext.this.getEmptySet();
            if (string != null) {
                this.setName(string);
            }
            if (style != null) {
                this.setResolveParent(style);
            }
        }

        public NamedStyle(Style style) {
            this(null, style);
        }

        public NamedStyle() {
            this.attributes = StyleContext.this.getEmptySet();
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        @Override
        public String getName() {
            if (this.isDefined(StyleConstants.NameAttribute)) {
                return this.getAttribute(StyleConstants.NameAttribute).toString();
            }
            return null;
        }

        public void setName(String string) {
            if (string != null) {
                this.addAttribute(StyleConstants.NameAttribute, string);
            }
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        }

        protected void fireStateChanged() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
                if (objectArray[i2] != ChangeListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
            }
        }

        public <T extends EventListener> T[] getListeners(Class<T> clazz) {
            return this.listenerList.getListeners(clazz);
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            NamedStyle namedStyle = new NamedStyle();
            namedStyle.attributes = this.attributes.copyAttributes();
            return namedStyle;
        }

        @Override
        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        @Override
        public void addAttribute(Object object, Object object2) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        @Override
        public void removeAttribute(Object object) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = attributeSet == this ? styleContext.getEmptySet() : styleContext.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
            } else {
                this.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(objectInputStream, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SmallAttributeSet
    implements AttributeSet {
        Object[] attributes;
        AttributeSet resolveParent;

        public SmallAttributeSet(Object[] objectArray) {
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        public SmallAttributeSet(AttributeSet attributeSet) {
            int n2 = attributeSet.getAttributeCount();
            Object[] objectArray = new Object[2 * n2];
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n3] = enumeration.nextElement();
                objectArray[n3 + 1] = attributeSet.getAttribute(objectArray[n3]);
                n3 += 2;
            }
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        private void updateResolveParent() {
            this.resolveParent = null;
            Object[] objectArray = this.attributes;
            for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
                if (objectArray[i2] != StyleConstants.ResolveAttribute) continue;
                this.resolveParent = (AttributeSet)objectArray[i2 + 1];
                break;
            }
        }

        Object getLocalAttribute(Object object) {
            if (object == StyleConstants.ResolveAttribute) {
                return this.resolveParent;
            }
            Object[] objectArray = this.attributes;
            for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
                if (!object.equals(objectArray[i2])) continue;
                return objectArray[i2 + 1];
            }
            return null;
        }

        public String toString() {
            String string = "{";
            Object[] objectArray = this.attributes;
            for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
                string = objectArray[i2 + 1] instanceof AttributeSet ? string + objectArray[i2] + "=" + "AttributeSet" + "," : string + objectArray[i2] + "=" + objectArray[i2 + 1] + ",";
            }
            string = string + "}";
            return string;
        }

        public int hashCode() {
            int n2 = 0;
            Object[] objectArray = this.attributes;
            for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
                n2 ^= objectArray[i2].hashCode();
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (object instanceof AttributeSet) {
                AttributeSet attributeSet = (AttributeSet)object;
                return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            }
            return false;
        }

        public Object clone() {
            return this;
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.length / 2;
        }

        @Override
        public boolean isDefined(Object object) {
            Object[] objectArray = this.attributes;
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; i2 += 2) {
                if (!object.equals(objectArray[i2])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                return attributeSet == this;
            }
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        @Override
        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.getLocalAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return new KeyEnumeration(this.attributes);
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl2 = true;
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (bl2 && enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                bl2 = attributeSet.getAttribute(obj).equals(this.getAttribute(obj));
            }
            return bl2;
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.resolveParent;
        }
    }
}

